/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.templates.ContributionContextTypeRegistry;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.ChainedPreferenceStore;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.python.pydev.core.ICallback;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.bundle.BundleInfo;
import org.python.pydev.core.bundle.IBundleInfo;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.shell.AbstractShell;
import org.python.pydev.editorinput.PydevFileEditorInput;
import org.python.pydev.editorinput.PydevZipFileEditorInput;
import org.python.pydev.editorinput.PydevZipFileStorage;
import org.python.pydev.plugin.PyFileLabelProvider;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.pyunit.ITestRunListener;
import org.python.pydev.pyunit.PyUnitTestRunner;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;
import org.python.pydev.ui.interpreters.JythonInterpreterManager;
import org.python.pydev.ui.interpreters.PythonInterpreterManager;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PydevPlugin
extends AbstractUIPlugin
implements Preferences.IPropertyChangeListener {
    public static final String version = "1.3.18";
    public static IBundleInfo info;
    private static IInterpreterManager pythonInterpreterManager;
    private static IInterpreterManager jythonInterpreterManager;
    private static PydevPlugin plugin;
    private ResourceBundle resourceBundle;
    private TemplateStore fStore;
    private ContributionContextTypeRegistry fRegistry = null;
    private static final String CUSTOM_TEMPLATES_PY_KEY = "org.python.pydev.editor.templates.PyTemplatePreferencesPage";
    public static final String DEFAULT_PYDEV_SCOPE = "org.python.pydev";
    private static final String[][] IMAGES;
    private List testListeners = new ArrayList();
    private static IPreferenceStore fChainedPrefStore;

    static {
        IMAGES = new String[][]{{"icons/save.gif", "save.gif"}, {"icons/terminate.gif", "terminate.gif"}};
    }

    public static IBundleInfo getBundleInfo() {
        if (info == null) {
            info = new BundleInfo(PydevPlugin.getDefault().getBundle());
        }
        return info;
    }

    public static void setBundleInfo(IBundleInfo b) {
        info = b;
    }

    public static void setPythonInterpreterManager(IInterpreterManager interpreterManager) {
        pythonInterpreterManager = interpreterManager;
    }

    public static IInterpreterManager getPythonInterpreterManager() {
        return PydevPlugin.getPythonInterpreterManager(false);
    }

    public static IInterpreterManager getPythonInterpreterManager(boolean haltOnStub) {
        return pythonInterpreterManager;
    }

    public static void setJythonInterpreterManager(IInterpreterManager interpreterManager) {
        jythonInterpreterManager = interpreterManager;
    }

    public static IInterpreterManager getJythonInterpreterManager() {
        return PydevPlugin.getJythonInterpreterManager(false);
    }

    public static IInterpreterManager getJythonInterpreterManager(boolean haltOnStub) {
        return jythonInterpreterManager;
    }

    public static IInterpreterManager getInterpreterManager(IPythonNature nature) {
        try {
            if (nature.isJython()) {
                return jythonInterpreterManager;
            }
            if (nature.isPython()) {
                return pythonInterpreterManager;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException("Unable to get the interpreter manager for the nature passed.");
    }

    public PydevPlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        try {
            this.resourceBundle = ResourceBundle.getBundle("org.python.pydev.PyDevPluginResources");
        }
        catch (MissingResourceException missingResourceException) {
            this.resourceBundle = null;
        }
        Preferences preferences = plugin.getPluginPreferences();
        preferences.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
        PydevPlugin.setPythonInterpreterManager(new PythonInterpreterManager(preferences));
        PydevPlugin.setJythonInterpreterManager(new JythonInterpreterManager(preferences));
        new Job("PyDev: Restoring projects python nature"){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IProject[] projects = PydevPlugin.getWorkspace().getRoot().getProjects();
                    int i = 0;
                    while (i < projects.length) {
                        IProject project = projects[i];
                        try {
                            if (project.isOpen() && project.hasNature("org.python.pydev.pythonNature")) {
                                PythonNature.addNature(project, monitor, null, null);
                            }
                        }
                        catch (Exception e) {
                            PydevPlugin.log(e);
                        }
                        ++i;
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public static boolean isPythonInterpreterInitialized() {
        return true;
    }

    public static boolean isJythonInterpreterInitialized() {
        return true;
    }

    public void stop(BundleContext context) throws Exception {
        try {
            AbstractShell.shutdownAllShells();
            Preferences preferences = plugin.getPluginPreferences();
            preferences.removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
            IProject[] projects = PydevPlugin.getWorkspace().getRoot().getProjects();
            int i = 0;
            while (i < projects.length) {
                try {
                    IProjectNature n;
                    IProject project = projects[i];
                    if (project.isOpen() && (n = project.getNature("org.python.pydev.pythonNature")) instanceof PythonNature) {
                        PythonNature nature = (PythonNature)n;
                        nature.saveAstManager();
                    }
                }
                catch (CoreException e) {
                    PydevPlugin.log(e);
                }
                ++i;
            }
        }
        finally {
            super.stop(context);
        }
    }

    public static PydevPlugin getDefault() {
        return plugin;
    }

    public static String getPluginID() {
        return PydevPlugin.getBundleInfo().getPluginID();
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static Status makeStatus(int errorLevel, String message, Throwable e) {
        return new Status(errorLevel, PydevPlugin.getPluginID(), errorLevel, message, e);
    }

    public static String getResourceString(String key) {
        ResourceBundle bundle = plugin.getResourceBundle();
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            return key;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
    }

    public static void log(String message, Throwable e) {
        PydevPlugin.log(4, message, e);
    }

    public static void log(int errorLevel, String message, Throwable e) {
        PydevPlugin.log(errorLevel, message, e, true);
    }

    public static void log(String message, Throwable e, boolean printToConsole) {
        PydevPlugin.log(4, message, e, printToConsole);
    }

    public static void logInfo(Exception e) {
        PydevPlugin.log(1, e.getMessage(), e, true);
    }

    public static void log(int errorLevel, String message, Throwable e, boolean printToConsole) {
        if (printToConsole) {
            if (errorLevel == 4) {
                System.out.println("Error received...");
            } else {
                System.out.println("Log received...");
            }
            System.out.println(message);
            System.err.println(message);
            if (e != null) {
                e.printStackTrace();
            }
        }
        try {
            Status s = new Status(errorLevel, PydevPlugin.getPluginID(), errorLevel, message, e);
            PydevPlugin.getDefault().getLog().log((IStatus)s);
        }
        catch (Throwable throwable) {}
    }

    public static void log(IStatus status) {
        PydevPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable e) {
        PydevPlugin.log(e, true);
    }

    public static void log(Throwable e, boolean printToConsole) {
        PydevPlugin.log(4, e.getMessage() != null ? e.getMessage() : "No message gotten.", e, printToConsole);
    }

    public static void logInfo(String msg) {
        Status s = PydevPlugin.makeStatus(1, msg, null);
        PydevPlugin plug = PydevPlugin.getDefault();
        if (plug == null) {
            System.out.println(msg);
        } else {
            plug.getLog().log((IStatus)s);
        }
    }

    public static CoreException log(String msg) {
        Status s = PydevPlugin.makeStatus(4, msg, new RuntimeException(msg));
        CoreException e = new CoreException((IStatus)s);
        PydevPlugin.log(e);
        return e;
    }

    public static IEditorPart doOpenEditor(IFile f, boolean activate) {
        if (f == null) {
            return null;
        }
        try {
            FileEditorInput file = new FileEditorInput(f);
            return PydevPlugin.openEditorInput((IEditorInput)file);
        }
        catch (Exception e) {
            PydevPlugin.log(4, new StringBuffer("Unexpected error opening path ").append(f.toString()).toString(), e);
            return null;
        }
    }

    public static IEditorPart doOpenEditor(File zipFile, String zipFilePath, boolean activate) {
        if (zipFile == null || zipFilePath == null) {
            return null;
        }
        try {
            PydevZipFileEditorInput file = new PydevZipFileEditorInput(new PydevZipFileStorage(zipFile, zipFilePath));
            return PydevPlugin.openEditorInput((IEditorInput)file);
        }
        catch (Exception e) {
            PydevPlugin.log(4, new StringBuffer("Unexpected error opening zip file ").append(zipFile.getAbsolutePath()).append(" - ").append(zipFilePath).toString(), e);
            return null;
        }
    }

    public static IEditorPart doOpenEditor(IPath path, boolean activate) {
        if (path == null) {
            return null;
        }
        try {
            IEditorInput file = PydevPlugin.createEditorInput(path);
            return PydevPlugin.openEditorInput(file);
        }
        catch (Exception e) {
            PydevPlugin.log(4, new StringBuffer("Unexpected error opening path ").append(path.toString()).toString(), e);
            return null;
        }
    }

    private static IEditorPart openEditorInput(IEditorInput file) throws PartInitException {
        IWorkbench workbench = plugin.getWorkbench();
        if (workbench == null) {
            throw new RuntimeException("workbench cannot be null");
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            throw new RuntimeException("activeWorkbenchWindow cannot be null (we have to be in a ui thread for this to work)");
        }
        IWorkbenchPage wp = activeWorkbenchWindow.getActivePage();
        return IDE.openEditor((IWorkbenchPage)wp, (IEditorInput)file, (String)"org.python.pydev.editor.PythonEditor");
    }

    public static IEditorInput createEditorInput(IPath path) {
        return PydevPlugin.createEditorInput(path, true);
    }

    private static IEditorInput createEditorInput(IPath path, boolean askIfDoesNotExist) {
        IEditorInput edInput = null;
        IWorkspace w = ResourcesPlugin.getWorkspace();
        IFile fileForLocation = w.getRoot().getFileForLocation(path);
        if (fileForLocation != null) {
            return new FileEditorInput(fileForLocation);
        }
        IFile[] files = w.getRoot().findFilesForLocation(path);
        if (files == null || files.length == 0 || !files[0].exists()) {
            File systemFile = path.toFile();
            if (systemFile.exists()) {
                edInput = PydevPlugin.createEditorInput(systemFile);
            } else if (askIfDoesNotExist) {
                List<IFile> likelyFiles = PydevPlugin.getLikelyFiles(path, w);
                IFile iFile = PydevPlugin.selectWorkspaceFile(likelyFiles.toArray(new IFile[0]));
                if (iFile != null) {
                    return new FileEditorInput(iFile);
                }
                IEditorInput input = PydevPlugin.selectFilesystemFileForPath(path);
                if (input != null) {
                    return input;
                }
            }
        } else {
            edInput = PydevPlugin.doFileEditorInput(PydevPlugin.selectWorkspaceFile(files));
        }
        return edInput;
    }

    private static IEditorInput doFileEditorInput(IFile file) {
        if (file == null) {
            return null;
        }
        return new FileEditorInput(file);
    }

    private static IEditorInput selectFilesystemFileForPath(final IPath path) {
        final ArrayList l = new ArrayList();
        Runnable r = new Runnable(){

            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                FileDialog dialog = new FileDialog(shell);
                dialog.setText(path + " - select correspondent filesystem file.");
                dialog.setFilterExtensions(FileTypesPreferencesPage.getWildcardValidSourceFiles());
                String string = dialog.open();
                if (string != null) {
                    l.add(string);
                }
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(r);
        } else {
            r.run();
        }
        if (l.size() > 0) {
            String fileAbsolutePath = REF.getFileAbsolutePath((String)((String)l.get(0)));
            return new PydevFileEditorInput(new File(fileAbsolutePath));
        }
        return null;
    }

    private static List<IFile> getLikelyFiles(IPath path, IWorkspace w) {
        ArrayList<IFile> ret = new ArrayList<IFile>();
        try {
            IResource[] resources = w.getRoot().members();
            PydevPlugin.getLikelyFiles(path, ret, resources);
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        return ret;
    }

    private static void getLikelyFiles(IPath path, List<IFile> ret, IResource[] resources) throws CoreException {
        String strPath = path.removeFileExtension().lastSegment().toLowerCase();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile) {
                IFile f = (IFile)resource;
                if (PythonPathHelper.isValidSourceFile(f) && resource.getFullPath().removeFileExtension().lastSegment().toLowerCase().equals(strPath)) {
                    ret.add((IFile)resource);
                }
            } else if (resource instanceof IContainer) {
                PydevPlugin.getLikelyFiles(path, ret, ((IContainer)resource).members());
            }
            ++n2;
        }
    }

    private static IEditorInput createEditorInput(File file) {
        IFile[] workspaceFile = PydevPlugin.getWorkspaceFiles(file);
        if (workspaceFile != null && workspaceFile.length > 0) {
            IFile file2 = PydevPlugin.selectWorkspaceFile(workspaceFile);
            if (file2 != null) {
                return new FileEditorInput(file2);
            }
            return new FileEditorInput(workspaceFile[0]);
        }
        return new PydevFileEditorInput(file);
    }

    public static IFile getWorkspaceFile(File file) {
        IFile[] files = PydevPlugin.getWorkspaceFiles(file);
        return PydevPlugin.selectWorkspaceFile(files);
    }

    public static IFile[] getWorkspaceFiles(File file) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IPath location = Path.fromOSString((String)file.getAbsolutePath());
        IFile[] files = workspace.getRoot().findFilesForLocation(location);
        if ((files = PydevPlugin.filterNonExistentFiles(files)) == null || files.length == 0) {
            return null;
        }
        return files;
    }

    private static IFile[] filterNonExistentFiles(IFile[] files) {
        if (files == null) {
            return null;
        }
        int length = files.length;
        ArrayList<IFile> existentFiles = new ArrayList<IFile>(length);
        int i = 0;
        while (i < length) {
            if (files[i].exists()) {
                existentFiles.add(files[i]);
            }
            ++i;
        }
        return existentFiles.toArray(new IFile[existentFiles.size()]);
    }

    private static IFile selectWorkspaceFile(final IFile[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        if (files.length == 1) {
            return files[0];
        }
        final ArrayList selected = new ArrayList();
        Runnable r = new Runnable(){

            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new PyFileLabelProvider());
                dialog.setElements((Object[])files);
                dialog.setTitle("Select Workspace File");
                dialog.setMessage("File may be matched to multiple files in the workspace.");
                if (dialog.open() == 0) {
                    selected.add((IFile)dialog.getFirstResult());
                }
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(r);
        } else {
            r.run();
        }
        if (selected.size() > 0) {
            return (IFile)selected.get(0);
        }
        return null;
    }

    public TemplateStore getTemplateStore() {
        if (this.fStore == null) {
            this.fStore = new ContributionTemplateStore(this.getContextTypeRegistry(), this.getPreferenceStore(), CUSTOM_TEMPLATES_PY_KEY);
            try {
                this.fStore.load();
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return this.fStore;
    }

    public ContextTypeRegistry getContextTypeRegistry() {
        if (this.fRegistry == null) {
            this.fRegistry = new ContributionContextTypeRegistry();
            this.fRegistry.addContextType("org.python.pydev.editor.templates.python");
        }
        return this.fRegistry;
    }

    public static File getScriptWithinPySrc(String targetExec) throws CoreException {
        IPath relative = new Path("PySrc").addTrailingSeparator().append(targetExec);
        return PydevPlugin.getBundleInfo().getRelativePath(relative);
    }

    public static ImageCache getImageCache() {
        return PydevPlugin.getBundleInfo().getImageCache();
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        int i = 0;
        while (i < IMAGES.length) {
            URL url = PydevPlugin.getDefault().getBundle().getEntry(IMAGES[i][0]);
            registry.put(IMAGES[i][1], ImageDescriptor.createFromURL((URL)url));
            ++i;
        }
    }

    public ImageDescriptor getImageDescriptor(String key) {
        return this.getImageRegistry().getDescriptor(key);
    }

    public void addTestListener(ITestRunListener listener) {
        this.testListeners.add(listener);
    }

    public void removeTestListener(ITestRunListener listener) {
        this.testListeners.remove(listener);
    }

    public List getListeners() {
        return this.testListeners;
    }

    public void runTests(String moduleDir, String moduleName, IProject project) throws IOException, CoreException {
        new PyUnitTestRunner().runTests(moduleDir, moduleName, project);
    }

    public void fireTestsStarted(int count) {
        for (ITestRunListener each : this.getListeners()) {
            each.testsStarted(count);
        }
    }

    public void fireTestsFinished() {
        for (ITestRunListener each : this.getListeners()) {
            each.testsFinished();
        }
    }

    public void fireTestStarted(String klass, String methodName) {
        for (ITestRunListener each : this.getListeners()) {
            each.testStarted(klass, methodName);
        }
    }

    public void fireTestFailed(String klass, String methodName, String trace) {
        for (ITestRunListener each : this.getListeners()) {
            each.testFailed(klass, methodName, trace);
        }
    }

    public static Tuple<SystemPythonNature, String> getInfoForFile(File file) {
        SystemPythonNature systemPythonNature;
        String modName = null;
        IInterpreterManager pythonInterpreterManager = PydevPlugin.getPythonInterpreterManager(false);
        IInterpreterManager jythonInterpreterManager = PydevPlugin.getJythonInterpreterManager(false);
        if (pythonInterpreterManager == null || jythonInterpreterManager == null) {
            return null;
        }
        SystemPythonNature pySystemPythonNature = systemPythonNature = new SystemPythonNature(pythonInterpreterManager);
        SystemPythonNature jySystemPythonNature = null;
        try {
            modName = systemPythonNature.resolveModule(file);
        }
        catch (Exception exception) {}
        if (modName == null) {
            jySystemPythonNature = systemPythonNature = new SystemPythonNature(jythonInterpreterManager);
            try {
                modName = systemPythonNature.resolveModule(file);
            }
            catch (Exception exception) {}
        }
        if (modName != null) {
            return new Tuple((Object)systemPythonNature, (Object)modName);
        }
        try {
            pythonInterpreterManager.getDefaultInterpreter();
            modName = PydevPlugin.getModNameFromFile(file);
            return new Tuple((Object)pySystemPythonNature, (Object)modName);
        }
        catch (Exception exception) {
            try {
                jythonInterpreterManager.getDefaultInterpreter();
                modName = PydevPlugin.getModNameFromFile(file);
                return new Tuple((Object)jySystemPythonNature, (Object)modName);
            }
            catch (Exception exception2) {
                return null;
            }
        }
    }

    private static String getModNameFromFile(File file) {
        if (file == null) {
            return null;
        }
        String name = file.getName();
        int i = name.indexOf(46);
        if (i != -1) {
            return name.substring(0, i);
        }
        return name;
    }

    public static synchronized IPreferenceStore getChainedPrefStore() {
        if (fChainedPrefStore == null) {
            IPreferenceStore general = EditorsUI.getPreferenceStore();
            IPreferenceStore preferenceStore = PydevPlugin.getDefault().getPreferenceStore();
            fChainedPrefStore = new ChainedPreferenceStore(new IPreferenceStore[]{preferenceStore, general});
        }
        return fChainedPrefStore;
    }

    public static String getIResourceOSString(IResource f) {
        String fullPath = f.getRawLocation().toOSString();
        File file = new File(fullPath);
        if (file.exists()) {
            return REF.getFileAbsolutePath((File)file);
        }
        IProject project = f.getProject();
        IPath location = project.getLocation();
        File projectFile = location.toFile();
        if (projectFile.exists()) {
            String projectFilePath = REF.getFileAbsolutePath((File)projectFile);
            if (fullPath.startsWith(projectFilePath)) {
                return fullPath;
            }
            if (fullPath.toLowerCase().startsWith(projectFilePath.toLowerCase())) {
                String relativePart = fullPath.substring(projectFilePath.length());
                return new StringBuffer(String.valueOf(projectFilePath)).append(relativePart).toString();
            }
        }
        return fullPath;
    }

    public static void writeToWorkspaceMetadata(Object obj, String fileName) {
        Bundle bundle = Platform.getBundle((String)DEFAULT_PYDEV_SCOPE);
        IPath path = Platform.getStateLocation((Bundle)bundle);
        path = path.addTrailingSeparator();
        path = path.append(fileName);
        try {
            FileOutputStream out = new FileOutputStream(path.toFile());
            REF.writeToStreamAndCloseIt((Object)obj, (OutputStream)out);
        }
        catch (Exception e) {
            PydevPlugin.log(e);
            throw new RuntimeException(e);
        }
    }

    public static Object readFromWorkspaceMetadata(String fileName) {
        Bundle bundle = Platform.getBundle((String)DEFAULT_PYDEV_SCOPE);
        IPath path = Platform.getStateLocation((Bundle)bundle);
        path = path.addTrailingSeparator();
        path = path.append(fileName);
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(path.toFile());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return REF.readFromInputStreamAndCloseIt((ICallback)new ICallback<Object, ObjectInputStream>(){

            public Object call(ObjectInputStream arg) {
                try {
                    return arg.readObject();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            public /* synthetic */ Object call(Object object) {
                return this.call((ObjectInputStream)object);
            }
        }, (InputStream)fileInputStream);
    }
}

