/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.plugin.nature;

import java.io.File;
import java.util.EmptyStackException;
import java.util.Stack;
import org.eclipse.core.resources.IResource;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.REF;
import org.python.pydev.plugin.PydevPlugin;

public abstract class AbstractPythonNature
implements IPythonNature {
    private Stack<IModulesManager> modulesManagerStack = new Stack();

    public boolean isResourceInPythonpath(IResource resource) {
        return this.resolveModule(resource) != null;
    }

    public boolean isResourceInPythonpath(String absPath) {
        return this.resolveModule(absPath) != null;
    }

    public String resolveModule(IResource resource) {
        return this.resolveModule(PydevPlugin.getIResourceOSString(resource));
    }

    public String resolveModule(File file) {
        return this.resolveModule(REF.getFileAbsolutePath((File)file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean startRequests() {
        ICodeCompletionASTManager astManager = this.getAstManager();
        if (astManager == null) {
            return false;
        }
        IModulesManager modulesManager = astManager.getModulesManager();
        if (modulesManager == null) {
            return false;
        }
        Stack<IModulesManager> stack = this.modulesManagerStack;
        synchronized (stack) {
            this.modulesManagerStack.push(modulesManager);
            return modulesManager.startCompletionCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void endRequests() {
        Stack<IModulesManager> stack = this.modulesManagerStack;
        synchronized (stack) {
            try {
                IModulesManager modulesManager = this.modulesManagerStack.pop();
                modulesManager.endCompletionCache();
            }
            catch (EmptyStackException e) {
                PydevPlugin.log(e);
            }
        }
    }
}

