/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.pyunit;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.pyunit.TestResult;

public class TestReportLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IColorProvider {
    private Image[] images = new Image[2];

    public TestReportLabelProvider() {
        this.images[0] = TestReportLabelProvider.createImage("icons/testok.gif");
        this.images[1] = TestReportLabelProvider.createImage("icons/testerr.gif");
    }

    private static Image createImage(String path) {
        URL url = PydevPlugin.getDefault().getBundle().getEntry("/");
        ImageDescriptor descriptor = null;
        try {
            descriptor = ImageDescriptor.createFromURL((URL)new URL(url, path));
        }
        catch (MalformedURLException malformedURLException) {
            descriptor = ImageDescriptor.getMissingImageDescriptor();
        }
        return descriptor.createImage();
    }

    public String getColumnText(Object element, int columnIndex) {
        TestResult result = (TestResult)element;
        switch (columnIndex) {
            case 0: {
                return String.valueOf(result.method) + " - " + result.klass;
            }
            case 1: {
                return Long.toString(result.testDuration());
            }
        }
        return null;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            return this.images[((TestResult)element).status];
        }
        return null;
    }

    public void dispose() {
        int i = 0;
        while (i < this.images.length) {
            this.images[i].dispose();
            ++i;
        }
    }

    public Color getForeground(Object element) {
        if (((TestResult)element).isFailure()) {
            return Display.getDefault().getSystemColor(3);
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

