/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import java.io.CharArrayWriter;
import java.io.File;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.python.copiedfromeclipsesrc.JDTNotAvailableException;
import org.python.copiedfromeclipsesrc.PythonListEditor;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.runners.SimpleJythonRunner;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

public abstract class AbstractInterpreterEditor
extends PythonListEditor {
    public static boolean USE_ICONS = true;
    private String lastPath;
    private IInterpreterManager interpreterManager;
    private Tree tree;
    private List listControl;
    private Image imageSystemLibRoot;
    private Image imageSystemLib;
    private Composite box;
    private Button addBtOthers;
    private Button removeBtOthers;
    private SelectionListener selectionListenerOthers;
    private List listBuiltins;
    boolean changed = false;
    private Composite boxSystem;
    private Button addBtSystemFolder;
    private Button removeBtSystemFolder;
    private Button addBtSystemJar;
    private SelectionListener selectionListenerSystem;
    Label l1;
    Label l2;
    private static String lastDirectoryDialogPath = null;
    private static String lastFileDialogPath = null;

    public abstract String[] getInterpreterFilterExtensions();

    public List getExesList() {
        return this.listControl;
    }

    protected AbstractInterpreterEditor(String preferenceName, String labelText, Composite parent, IInterpreterManager interpreterManager) {
        this.init(preferenceName, labelText);
        this.interpreterManager = interpreterManager;
        if (USE_ICONS) {
            this.imageSystemLibRoot = PydevPlugin.getImageCache().get("icons/library_obj.gif");
            this.imageSystemLib = PydevPlugin.getImageCache().get("icons/jar_l_obj.gif");
        }
        this.createControl(parent);
        this.updateTree();
    }

    protected void createControl(Composite parent) {
        super.createControl(parent);
        this.listControl = this.getListControl(parent);
        this.listControl.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                AbstractInterpreterEditor.this.updateTree();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                AbstractInterpreterEditor.this.updateTree();
            }
        });
    }

    private Tree getTreeLibsControl(Composite parent) {
        if (this.tree == null) {
            this.tree = new Tree(parent, 2050);
            this.tree.setFont(parent.getFont());
            this.tree.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AbstractInterpreterEditor.this.tree = null;
                }
            });
        }
        return this.tree;
    }

    protected void removePressed() {
        super.removePressed();
        this.updateTree();
        this.changed = true;
        this.store();
    }

    protected void addPressed() {
        super.addPressed();
        this.updateTree();
        this.changed = true;
    }

    protected void upPressed() {
        super.upPressed();
        this.changed = true;
    }

    protected void downPressed() {
        super.downPressed();
        this.changed = true;
    }

    protected void adjustForNumColumns(int numColumns) {
        super.adjustForNumColumns(numColumns);
        ((GridData)this.l1.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.tree.getLayoutData()).horizontalSpan = numColumns - 1;
        ((GridData)this.boxSystem.getLayoutData()).horizontalSpan = 1;
        ((GridData)this.l2.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.listBuiltins.getLayoutData()).horizontalSpan = numColumns - 1;
        ((GridData)this.box.getLayoutData()).horizontalSpan = 1;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        this.l1 = new Label(parent, 0);
        this.l1.setText("System PYTHONPATH");
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        this.l1.setLayoutData((Object)gd);
        this.tree = this.getTreeLibsControl(parent);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        this.tree.setLayoutData((Object)gd);
        Composite control = this.getButtonBoxControlSystem(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        control.setLayoutData((Object)gd);
        this.l2 = new Label(parent, 0);
        this.l2.setText("Forced builtin libs (check http://pydev.sf.net/faq.html for more info).");
        gd = new GridData();
        this.l2.setLayoutData((Object)gd);
        List list = this.getBuiltinsListControl(parent);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = false;
        gd.heightHint = 100;
        list.setLayoutData((Object)gd);
        control = this.getButtonBoxControlOthers(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        control.setLayoutData((Object)gd);
    }

    private List getBuiltinsListControl(Composite parent) {
        if (this.listBuiltins == null) {
            this.listBuiltins = new List(parent, 2820);
            this.listBuiltins.setFont(parent.getFont());
            this.listBuiltins.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AbstractInterpreterEditor.this.listBuiltins = null;
                }
            });
        } else {
            this.checkParent((Control)this.listBuiltins, parent);
        }
        return this.listBuiltins;
    }

    public Composite getButtonBoxControlSystem(Composite parent) {
        if (this.boxSystem == null) {
            this.boxSystem = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.boxSystem.setLayout((Layout)layout);
            this.addBtSystemFolder = this.createBt(this.boxSystem, "New Folder", this.getSelectionListenerSystem());
            this.addBtSystemJar = this.interpreterManager.isJython() ? this.createBt(this.boxSystem, "New Jar/Zip(s)", this.getSelectionListenerSystem()) : this.createBt(this.boxSystem, "New Egg/Zip(s)", this.getSelectionListenerSystem());
            this.removeBtSystemFolder = this.createBt(this.boxSystem, "ListEditor.remove", this.getSelectionListenerSystem());
            this.boxSystem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AbstractInterpreterEditor.this.addBtSystemJar = null;
                    AbstractInterpreterEditor.this.addBtSystemFolder = null;
                    AbstractInterpreterEditor.this.removeBtSystemFolder = null;
                    AbstractInterpreterEditor.this.boxSystem = null;
                }
            });
        } else {
            this.checkParent((Control)this.boxSystem, parent);
        }
        return this.boxSystem;
    }

    public Composite getButtonBoxControlOthers(Composite parent) {
        if (this.box == null) {
            this.box = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.box.setLayout((Layout)layout);
            this.addBtOthers = this.createBt(this.box, "ListEditor.add", this.getSelectionListenerOthers());
            this.removeBtOthers = this.createBt(this.box, "ListEditor.remove", this.getSelectionListenerOthers());
            this.box.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AbstractInterpreterEditor.this.addBtOthers = null;
                    AbstractInterpreterEditor.this.removeBtOthers = null;
                    AbstractInterpreterEditor.this.box = null;
                }
            });
        } else {
            this.checkParent((Control)this.box, parent);
        }
        return this.box;
    }

    private SelectionListener getSelectionListenerOthers() {
        if (this.selectionListenerOthers == null) {
            this.selectionListenerOthers = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Widget widget = event.widget;
                    if (widget == AbstractInterpreterEditor.this.addBtOthers) {
                        AbstractInterpreterEditor.this.addOthers();
                    } else if (widget == AbstractInterpreterEditor.this.removeBtOthers) {
                        AbstractInterpreterEditor.this.removeOthers();
                    }
                }
            };
        }
        return this.selectionListenerOthers;
    }

    private SelectionListener getSelectionListenerSystem() {
        if (this.selectionListenerSystem == null) {
            this.selectionListenerSystem = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (AbstractInterpreterEditor.this.listControl.getSelectionCount() == 1) {
                        String executable = AbstractInterpreterEditor.this.listControl.getSelection()[0];
                        InterpreterInfo info = (InterpreterInfo)AbstractInterpreterEditor.this.interpreterManager.getInterpreterInfo(executable, (IProgressMonitor)new NullProgressMonitor());
                        Widget widget = event.widget;
                        if (widget == AbstractInterpreterEditor.this.addBtSystemFolder) {
                            DirectoryDialog dialog = new DirectoryDialog(AbstractInterpreterEditor.this.getShell());
                            dialog.setFilterPath(lastDirectoryDialogPath);
                            String filePath = dialog.open();
                            if (filePath != null) {
                                lastDirectoryDialogPath = filePath;
                                info.libs.add(filePath);
                                AbstractInterpreterEditor.this.changed = true;
                            }
                        } else if (widget == AbstractInterpreterEditor.this.addBtSystemJar) {
                            FileDialog dialog = new FileDialog(AbstractInterpreterEditor.this.getShell(), 32770);
                            if (AbstractInterpreterEditor.this.interpreterManager.isJython()) {
                                dialog.setFilterExtensions(FileTypesPreferencesPage.getWildcardJythonValidZipFiles());
                            } else {
                                dialog.setFilterExtensions(FileTypesPreferencesPage.getWildcardPythonValidZipFiles());
                            }
                            dialog.setFilterPath(lastFileDialogPath);
                            String filePath = dialog.open();
                            if (filePath != null) {
                                String[] fileNames;
                                lastFileDialogPath = filePath;
                                File filePath1 = new File(filePath);
                                String dir = filePath1.getParent();
                                String[] stringArray = fileNames = dialog.getFileNames();
                                int n = fileNames.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String f = stringArray[n2];
                                    f = String.valueOf(dir) + File.separatorChar + f;
                                    if (!info.libs.contains(f)) {
                                        info.libs.add(f);
                                    }
                                    ++n2;
                                }
                                AbstractInterpreterEditor.this.changed = true;
                            }
                        } else if (widget == AbstractInterpreterEditor.this.removeBtSystemFolder) {
                            TreeItem[] selection = AbstractInterpreterEditor.this.tree.getSelection();
                            int i = 0;
                            while (i < selection.length) {
                                TreeItem s = selection[i];
                                String text = s.getText();
                                info.libs.remove(text);
                                AbstractInterpreterEditor.this.changed = true;
                                ++i;
                            }
                        }
                        AbstractInterpreterEditor.this.updateTree();
                    }
                }
            };
        }
        return this.selectionListenerSystem;
    }

    protected void addOthers() {
        if (this.listControl.getSelectionCount() == 1) {
            String executable = this.listControl.getSelection()[0];
            InterpreterInfo info = (InterpreterInfo)this.interpreterManager.getInterpreterInfo(executable, (IProgressMonitor)new NullProgressMonitor());
            InputDialog d = new InputDialog(this.getShell(), "Builtin to add", "Builtin to add", "", null);
            int retCode = d.open();
            if (retCode == 0) {
                info.addForcedLib(d.getValue());
                this.changed = true;
            }
        }
        this.updateTree();
    }

    protected void removeOthers() {
        if (this.listControl.getSelectionCount() == 1 && this.listBuiltins.getSelectionCount() == 1) {
            String executable = this.listControl.getSelection()[0];
            String builtin = this.listBuiltins.getSelection()[0];
            InterpreterInfo info = (InterpreterInfo)this.interpreterManager.getInterpreterInfo(executable, (IProgressMonitor)new NullProgressMonitor());
            info.removeForcedLib(builtin);
            this.changed = true;
        }
        this.updateTree();
    }

    private Button createBt(Composite parent, String key, SelectionListener listenerToAdd) {
        Button button = new Button(parent, 8);
        button.setText(JFaceResources.getString((String)key));
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(listenerToAdd);
        return button;
    }

    private void updateTree() {
        if (this.listControl.getSelectionCount() == 1) {
            String s = this.listControl.getSelection()[0];
            this.fillPathItems(s);
        } else {
            this.fillPathItems(null);
            if (this.listControl.getItemCount() > 0) {
                this.listControl.select(0);
                this.selectionChanged();
                String s = this.listControl.getSelection()[0];
                this.fillPathItems(s);
            }
        }
    }

    private void fillPathItems(String executable) {
        this.tree.removeAll();
        this.listBuiltins.removeAll();
        if (executable != null) {
            TreeItem item = new TreeItem(this.tree, 0);
            item.setText("System libs");
            item.setImage(this.imageSystemLibRoot);
            InterpreterInfo info = (InterpreterInfo)this.interpreterManager.getInterpreterInfo(executable, (IProgressMonitor)new NullProgressMonitor());
            Iterator<String> iter = info.libs.iterator();
            while (iter.hasNext()) {
                TreeItem subItem = new TreeItem(item, 0);
                subItem.setText(iter.next());
                subItem.setImage(this.imageSystemLib);
            }
            item.setExpanded(true);
            iter = info.forcedLibsIterator();
            while (iter.hasNext()) {
                this.listBuiltins.add(iter.next());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String getNewInputObject() {
        CharArrayWriter charWriter = new CharArrayWriter();
        PrintWriter logger = new PrintWriter(charWriter);
        logger.println("Information about process of adding new interpreter:");
        try {
            FileDialog dialog = new FileDialog(this.getShell(), 4096);
            String[] filterExtensions = this.getInterpreterFilterExtensions();
            if (filterExtensions != null) {
                dialog.setFilterExtensions(filterExtensions);
            }
            if (this.lastPath != null && new File(this.lastPath).exists()) {
                dialog.setFilterPath(this.lastPath);
            }
            logger.println("- Opening dialog to request executable (or jar).");
            String file = dialog.open();
            if (file != null) {
                logger.println("- Chosen interpreter file:'" + file);
                file = file.trim();
                if (file.length() == 0) {
                    logger.println("- When trimmed, the chosen file was empty (returning null).");
                    return null;
                }
            } else {
                logger.println("- The file chosen was null (returning null).");
                return null;
            }
            this.lastPath = file;
            if (file == null) return null;
            logger.println("- Ok, file is non-null. Getting info on:" + file);
            ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(this.getShell());
            monitorDialog.setBlockOnOpen(false);
            Operation operation = new Operation(file, logger);
            monitorDialog.run(true, false, (IRunnableWithProgress)operation);
            if (operation.e != null) {
                logger.println("- Some error happened while getting info on the interpreter:");
                operation.e.printStackTrace(logger);
                if (operation.e instanceof SimpleJythonRunner.JavaNotConfiguredException) {
                    SimpleJythonRunner.JavaNotConfiguredException javaNotConfiguredException = (SimpleJythonRunner.JavaNotConfiguredException)operation.e;
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Error getting info on interpreter", (String)javaNotConfiguredException.getMessage(), (IStatus)PydevPlugin.makeStatus(4, "Java vm not configured.\n", javaNotConfiguredException));
                    throw operation.e;
                } else if (operation.e instanceof JDTNotAvailableException) {
                    JDTNotAvailableException noJdtException = (JDTNotAvailableException)operation.e;
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Error getting info on interpreter", (String)noJdtException.getMessage(), (IStatus)PydevPlugin.makeStatus(4, "JDT not available.\n", noJdtException));
                    throw operation.e;
                } else {
                    String errorMsg = "Some error happened while getting info on the interpreter.\n\nCommon reasons include:\n\n- Specifying an invalid interpreter(usually a link to the actual interpreter on Mac or Linux)\n- Having spaces in your Eclipse installation path.";
                    ErrorDialog.openError((Shell)this.getShell(), (String)"Error getting info on interpreter", (String)errorMsg, (IStatus)PydevPlugin.makeStatus(4, "Check your error log for more details.\n\nMore info can also be found at the bug report: http://sourceforge.net/tracker/index.php?func=detail&aid=1523582&group_id=85796&atid=577329", operation.e));
                }
                throw operation.e;
            }
            logger.println("- Success getting the info. Result:" + operation.result);
            String string = operation.result;
            return string;
        }
        catch (Exception e) {
            PydevPlugin.log(e);
            return null;
        }
        finally {
            PydevPlugin.logInfo(charWriter.toString());
        }
    }

    protected void doStore() {
        String s = this.createList(this.list.getItems());
        if (s != null) {
            this.interpreterManager.setPersistedString(s);
        }
    }

    protected void doLoad() {
        if (this.list != null) {
            String s = this.interpreterManager.getPersistedString();
            String[] array = this.parseString(s);
            int i = 0;
            while (i < array.length) {
                this.list.add(array[i]);
                ++i;
            }
        }
        this.updateTree();
    }

    public String getPreferenceName() {
        throw new RuntimeException("The preferences should be stored/gotten from the IInterpreterManager, and not directly.");
    }

    protected String createList(String[] executables) {
        return this.interpreterManager.getStringToPersist(executables);
    }

    protected String[] parseString(String stringList) {
        return this.interpreterManager.getInterpretersFromPersistedString(stringList);
    }

    protected void doLoadDefault() {
        super.doLoadDefault();
        this.updateTree();
    }

    public boolean hasChanged() {
        return this.changed;
    }

    private class Operation
    implements IRunnableWithProgress {
        public String result;
        public String file;
        public Exception e;
        private PrintWriter logger;

        public Operation(String file2, PrintWriter logger) {
            this.file = file2;
            this.logger = logger;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            monitor = new OperationMonitor((IProgressMonitor)monitor, this.logger);
            monitor.beginTask("Getting libs", 100);
            try {
                this.result = AbstractInterpreterEditor.this.interpreterManager.addInterpreter(this.file, monitor);
            }
            catch (Exception e) {
                this.logger.println("Exception detected: " + e.getMessage());
                this.e = e;
            }
            monitor.done();
        }
    }

    private static class OperationMonitor
    extends ProgressMonitorWrapper {
        private PrintWriter logger;

        protected OperationMonitor(IProgressMonitor monitor, PrintWriter logger) {
            super(monitor);
            this.logger = logger;
        }

        public void beginTask(String name, int totalWork) {
            super.beginTask(name, totalWork);
            this.logger.print("- Beggining task:");
            this.logger.print(name);
            this.logger.print(" totalWork:");
            this.logger.println(totalWork);
        }

        public void setTaskName(String name) {
            super.setTaskName(name);
            this.logger.print("- Setting task name:");
            this.logger.println(name);
        }

        public void subTask(String name) {
            super.subTask(name);
            this.logger.print("- Sub Task:");
            this.logger.println(name);
        }
    }
}

