/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.python.pydev.core.ICallback;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.ISystemModulesManager;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.core.uiutils.RunInUiThread;
import org.python.pydev.editor.codecompletion.revisited.ProjectModulesManager;
import org.python.pydev.editor.codecompletion.revisited.SystemModulesManager;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InterpreterInfo
implements IInterpreterInfo {
    public String executableOrJar;
    public List<String> libs = new ArrayList<String>();
    @Deprecated
    private List<String> dllLibs = new ArrayList<String>();
    private Set<String> forcedLibs = new TreeSet<String>();
    private String[] builtinsCache;
    private ISystemModulesManager modulesManager;
    public static ICallback<Boolean, Tuple<List<String>, List<String>>> configurePathsCallback = null;
    private String version;

    public void setModulesManager(ISystemModulesManager modulesManager) {
        modulesManager.setInfo((Object)this);
        this.modulesManager = modulesManager;
    }

    public ISystemModulesManager getModulesManager() {
        return this.modulesManager;
    }

    public List<String> getPythonPath() {
        ArrayList<String> ret = new ArrayList<String>();
        ret.addAll(this.libs);
        return ret;
    }

    public InterpreterInfo(String version, String exe, Collection<String> libs0) {
        this.executableOrJar = exe;
        this.version = version;
        this.dllLibs.clear();
        this.setModulesManager(new SystemModulesManager());
        this.libs.addAll(libs0);
    }

    public InterpreterInfo(String version, String exe, Collection<String> libs0, Collection<String> dlls) {
        this(version, exe, libs0);
    }

    public InterpreterInfo(String version, String exe, List<String> libs0, List<String> dlls, List<String> forced) {
        this(version, exe, libs0, dlls);
        this.forcedLibs.addAll(forced);
        this.builtinsCache = null;
    }

    public boolean equals(Object o) {
        if (!(o instanceof InterpreterInfo)) {
            return false;
        }
        InterpreterInfo info = (InterpreterInfo)o;
        if (!info.executableOrJar.equals(this.executableOrJar)) {
            return false;
        }
        if (!info.libs.equals(this.libs)) {
            return false;
        }
        return info.forcedLibs.equals(this.forcedLibs);
    }

    public static InterpreterInfo fromString(String received) {
        return InterpreterInfo.fromString(received, true);
    }

    public static InterpreterInfo fromString(String received, boolean askUserInOutPath) {
        if (received.toLowerCase().indexOf("executable") == -1) {
            throw new RuntimeException(new StringBuffer("Unable to recreate the Interpreter info (Its format changed. Please, re-create your Interpreter information).Contents found:").append(received).toString());
        }
        received = received.replaceAll("\n", "").replaceAll("\r", "");
        String[] forcedSplit = received.split("\\$");
        String[] libsSplit = forcedSplit[0].split("\\@");
        String exeAndLibs = libsSplit[0];
        String version = "2.4";
        String[] exeAndLibs1 = exeAndLibs.split("\\|");
        String exeAndVersion = exeAndLibs1[0];
        String lowerExeAndVersion = exeAndVersion.toLowerCase();
        if (lowerExeAndVersion.startsWith("version")) {
            int execut = lowerExeAndVersion.indexOf("executable");
            version = exeAndVersion.substring(0, execut).substring(7);
            exeAndVersion = exeAndVersion.substring(7 + version.length());
        }
        String executable = exeAndVersion.substring(exeAndVersion.indexOf(":") + 1, exeAndVersion.length());
        final ArrayList<String> l = new ArrayList<String>();
        final ArrayList<String> toAsk = new ArrayList<String>();
        int i = 1;
        while (i < exeAndLibs1.length) {
            String trimmed = exeAndLibs1[i].trim();
            if (trimmed.length() > 0) {
                if (trimmed.endsWith("OUT_PATH")) {
                    trimmed = trimmed.substring(0, trimmed.length() - 8);
                    if (askUserInOutPath) {
                        toAsk.add(trimmed);
                    }
                } else if (trimmed.endsWith("INS_PATH")) {
                    trimmed = trimmed.substring(0, trimmed.length() - 8);
                    if (askUserInOutPath) {
                        toAsk.add(trimmed);
                        l.add(trimmed);
                    } else {
                        l.add(trimmed);
                    }
                } else {
                    l.add(trimmed);
                }
            }
            ++i;
        }
        final Boolean[] result = new Boolean[]{Autobox.valueOf((boolean)true)};
        if (ProjectModulesManager.IN_TESTS) {
            if (configurePathsCallback != null) {
                configurePathsCallback.call((Object)new Tuple(toAsk, l));
            }
        } else if (toAsk.size() > 0) {
            Runnable runnable = new Runnable(){

                public void run() {
                    ListSelectionDialog dialog = new ListSelectionDialog(Display.getDefault().getActiveShell(), (Object)toAsk, new IStructuredContentProvider(){

                        public Object[] getElements(Object inputElement) {
                            List elements = (List)inputElement;
                            return elements.toArray(new String[0]);
                        }

                        public void dispose() {
                        }

                        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                        }
                    }, new ILabelProvider(){

                        public Image getImage(Object element) {
                            return PydevPlugin.getImageCache().get("icons/jar_l_obj.gif");
                        }

                        public String getText(Object element) {
                            return element.toString();
                        }

                        public void addListener(ILabelProviderListener listener) {
                        }

                        public void dispose() {
                        }

                        public boolean isLabelProperty(Object element, String property) {
                            return true;
                        }

                        public void removeListener(ILabelProviderListener listener) {
                        }
                    }, "Select the folders to be added to the SYSTEM pythonpath!\n\nIMPORTANT: The folders for your PROJECTS should NOT be added here, but in your project configuration.\n\nCheck:http://fabioz.com/pydev/manual_101_interpreter.html for more details.");
                    dialog.setInitialSelections((Object[])l.toArray(new String[0]));
                    int i = dialog.open();
                    if (i == 0) {
                        result[0] = Autobox.valueOf((boolean)true);
                        Object[] result2 = dialog.getResult();
                        l.clear();
                        Object[] objectArray = result2;
                        int n = result2.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object string = objectArray[n2];
                            l.add((String)string);
                            ++n2;
                        }
                    } else {
                        result[0] = Autobox.valueOf((boolean)false);
                    }
                }
            };
            try {
                RunInUiThread.sync((Runnable)runnable);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {}
        }
        if (!result[0].booleanValue()) {
            return null;
        }
        ArrayList<String> l1 = new ArrayList<String>();
        if (libsSplit.length > 1) {
            String dllLibs = libsSplit[1];
            String[] dllLibs1 = dllLibs.split("\\|");
            int i2 = 0;
            while (i2 < dllLibs1.length) {
                String trimmed = dllLibs1[i2].trim();
                if (trimmed.length() > 0) {
                    l1.add(trimmed);
                }
                ++i2;
            }
        }
        ArrayList<String> l2 = new ArrayList<String>();
        if (forcedSplit.length > 1) {
            String forcedLibs = forcedSplit[1];
            String[] forcedLibs1 = forcedLibs.split("\\|");
            int i3 = 0;
            while (i3 < forcedLibs1.length) {
                String trimmed = forcedLibs1[i3].trim();
                if (trimmed.length() > 0) {
                    l2.add(trimmed);
                }
                ++i3;
            }
        }
        return new InterpreterInfo(version, executable, l, l1, l2);
    }

    public String toString() {
        FastStringBuffer buffer = new FastStringBuffer();
        buffer.append("Version");
        buffer.append(this.version);
        buffer.append("Executable:");
        buffer.append(this.executableOrJar);
        Iterator<String> iter = this.libs.iterator();
        while (iter.hasNext()) {
            buffer.append("|");
            buffer.append(iter.next().toString());
        }
        buffer.append("@");
        buffer.append("$");
        if (this.forcedLibs.size() > 0) {
            iter = this.forcedLibs.iterator();
            while (iter.hasNext()) {
                buffer.append("|");
                buffer.append(iter.next().toString());
            }
        }
        return buffer.toString();
    }

    public void restoreCompiledLibs(IProgressMonitor monitor) {
        this.forcedLibs.add("os");
        this.forcedLibs.add("__builtin__");
        this.forcedLibs.add("sys");
        if (this.isJythonInfo()) {
            this.forcedLibs.add("StringIO");
        } else {
            this.forcedLibs.add("OpenGL");
            this.forcedLibs.add("wxPython");
            this.forcedLibs.add("wx");
        }
        this.builtinsCache = null;
    }

    public void restorePythonpath(String path, IProgressMonitor monitor) {
        this.getModulesManager().changePythonPath(path, null, monitor, null);
    }

    public void restorePythonpath(IProgressMonitor monitor) {
        StringBuffer buffer = new StringBuffer();
        for (String folder : this.libs) {
            buffer.append(folder);
            buffer.append("|");
        }
        this.restorePythonpath(buffer.toString(), monitor);
    }

    public boolean isJythonInfo() {
        return InterpreterInfo.isJythonExecutable(this.executableOrJar);
    }

    public static boolean isJythonExecutable(String executable) {
        if (executable.endsWith("\"")) {
            return executable.endsWith(".jar\"");
        }
        return executable.endsWith(".jar");
    }

    public String getExeAsFileSystemValidPath() {
        char[] invalidChars = new char[]{'/', '\\', ':', '*', '?', '\"', '<', '>', '|'};
        String systemValid = new String(REF.encodeBase64((byte[])this.executableOrJar.getBytes()));
        char[] cArray = invalidChars;
        int n = invalidChars.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            systemValid = systemValid.replace(c, '_');
            ++n2;
        }
        return systemValid;
    }

    public String getVersion() {
        return this.version;
    }

    public int getGrammarVersion() {
        int grammarVersion = 10;
        if (this.getVersion().equals("2.5")) {
            grammarVersion = 11;
        }
        return grammarVersion;
    }

    public String[] getBuiltins() {
        if (this.builtinsCache == null) {
            this.builtinsCache = this.forcedLibs.toArray(new String[0]);
        }
        return this.builtinsCache;
    }

    public void addForcedLib(String forcedLib) {
        this.forcedLibs.add(forcedLib);
        this.builtinsCache = null;
    }

    public void removeForcedLib(String forcedLib) {
        this.forcedLibs.remove(forcedLib);
        this.builtinsCache = null;
    }

    public Iterator<String> forcedLibsIterator() {
        return this.forcedLibs.iterator();
    }
}

