/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.coderefactoring.extractlocal;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.visitors.VisitorFactory;
import org.python.pydev.refactoring.coderefactoring.extractlocal.ExtractLocalChangeProcessor;
import org.python.pydev.refactoring.coderefactoring.extractlocal.ExtractLocalRequestProcessor;
import org.python.pydev.refactoring.core.AbstractPythonRefactoring;
import org.python.pydev.refactoring.core.RefactoringInfo;
import org.python.pydev.refactoring.core.change.IChangeProcessor;
import org.python.pydev.refactoring.messages.Messages;
import org.python.pydev.refactoring.ui.pages.extractlocal.ExtractLocalPage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractLocalRefactoring
extends AbstractPythonRefactoring {
    private ExtractLocalRequestProcessor requestProcessor;
    private IChangeProcessor changeProcessor;

    public ExtractLocalRefactoring(RefactoringInfo info) {
        super(info);
        try {
            this.initWizard();
        }
        catch (Throwable e) {
            this.status.addInfo(new StringBuffer(String.valueOf(Messages.infoFixCode)).append(" Error-Message: ").append(e.getLocalizedMessage()).toString());
        }
    }

    private void initWizard() throws Throwable {
        this.requestProcessor = new ExtractLocalRequestProcessor(this.info);
        this.pages.add(new ExtractLocalPage(this.getName(), this.requestProcessor));
    }

    @Override
    protected List<IChangeProcessor> getChangeProcessors() {
        ArrayList<IChangeProcessor> processors = new ArrayList<IChangeProcessor>();
        this.changeProcessor = new ExtractLocalChangeProcessor(this.getName(), this.info, this.requestProcessor);
        processors.add(this.changeProcessor);
        return processors;
    }

    @Override
    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        LinkedList<ModuleAdapter> selections = new LinkedList<ModuleAdapter>();
        selections.add(this.info.getParsedUserSelection());
        selections.add(this.info.getParsedExtendedSelection());
        selections.add(this.getParsedMultilineSelection(this.info.getUserSelection()));
        exprType expression = null;
        for (ModuleAdapter selection : selections) {
            if (selection != null && (expression = this.extractExpression(selection)) != null) break;
        }
        if (expression == null) {
            this.status.addFatalError(Messages.extractLocalNoExpressionSelected);
        }
        this.requestProcessor.setExpression(expression);
        return this.status;
    }

    private ModuleAdapter getParsedMultilineSelection(ITextSelection selection) {
        String source = selection.getText();
        source = source.replaceAll("\n", "");
        source = source.replaceAll("\r", "");
        try {
            ModuleAdapter node = VisitorFactory.createModuleAdapter(null, null, (IDocument)new Document(source), null);
            return node;
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    private exprType extractExpression(ModuleAdapter node) {
        stmtType[] body = ((Module)node.getASTNode()).body;
        if (body.length > 0 && body[0] instanceof Expr) {
            Expr expr = (Expr)body[0];
            return expr.value;
        }
        return null;
    }

    public String getName() {
        return Messages.extractLocalLabel;
    }
}

