/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.coderefactoring.extractmethod.edit;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.ITextSelection;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.adapters.SimpleAdapter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterReturnDeduce {
    private List<String> parameters;
    private Set<String> returns;
    private AbstractScopeNode<?> scopeAdapter;
    private ITextSelection selection;
    private ModuleAdapter moduleAdapter;

    public ParameterReturnDeduce(AbstractScopeNode<?> scope, ITextSelection selection, ModuleAdapter moduleAdapter) {
        this.scopeAdapter = scope;
        this.selection = selection;
        this.parameters = new ArrayList<String>();
        this.returns = new HashSet<String>();
        this.moduleAdapter = moduleAdapter;
        this.deduce();
    }

    private void deduce() {
        ArrayList<SimpleAdapter> before = new ArrayList<SimpleAdapter>();
        ArrayList<SimpleAdapter> after = new ArrayList<SimpleAdapter>();
        ModuleAdapter module = this.scopeAdapter.getModule();
        List<SimpleAdapter> selected = module.getWithinSelection(this.selection, this.scopeAdapter.getUsedVariables());
        this.extractBeforeAfterVariables(selected, before, after);
        this.deduceParameters(before, selected);
        this.deduceReturns(after, selected);
    }

    private void deduceParameters(List<SimpleAdapter> before, List<SimpleAdapter> selected) {
        HashSet<String> globarVarNames = new HashSet<String>(this.moduleAdapter.getGlobarVarNames());
        for (SimpleAdapter adapter : before) {
            if (!(adapter.getASTNode() instanceof Name)) continue;
            Name variable = (Name)adapter.getASTNode();
            if (globarVarNames.contains(variable.id) || !this.isUsed(variable.id, selected) || this.parameters.contains(variable.id)) continue;
            this.parameters.add(variable.id);
        }
    }

    private void deduceReturns(List<SimpleAdapter> after, List<SimpleAdapter> selected) {
        for (SimpleAdapter adapter : after) {
            if (!(adapter.getASTNode() instanceof Name)) continue;
            Name variable = (Name)adapter.getASTNode();
            if (!this.isStored(variable.id, selected)) continue;
            this.returns.add(variable.id);
        }
    }

    private void extractBeforeAfterVariables(List<SimpleAdapter> selectedVariables, List<SimpleAdapter> before, List<SimpleAdapter> after) {
        List<SimpleAdapter> scopeVariables = this.scopeAdapter.getUsedVariables();
        if (selectedVariables.size() < 1) {
            return;
        }
        SimpleAdapter firstSelectedVariable = selectedVariables.get(0);
        SimpleAdapter lastSelectedVariable = selectedVariables.get(selectedVariables.size() - 1);
        for (SimpleAdapter adapter : scopeVariables) {
            if (this.isBeforeSelectedLine(firstSelectedVariable, adapter) || this.isBeforeOnSameLine(firstSelectedVariable, adapter)) {
                before.add(adapter);
                continue;
            }
            if (!this.isAfterSelectedLine(lastSelectedVariable, adapter) && !this.isAfterOnSameLine(lastSelectedVariable, adapter)) continue;
            after.add(adapter);
        }
    }

    private boolean isAfterOnSameLine(SimpleAdapter lastSelectedVariable, SimpleAdapter adapter) {
        return adapter.getNodeFirstLine() == lastSelectedVariable.getNodeFirstLine() && adapter.getNodeIndent() > lastSelectedVariable.getNodeIndent();
    }

    private boolean isAfterSelectedLine(SimpleAdapter lastSelectedVariable, SimpleAdapter adapter) {
        return adapter.getNodeFirstLine() > lastSelectedVariable.getNodeFirstLine();
    }

    private boolean isBeforeOnSameLine(SimpleAdapter firstSelectedVariable, SimpleAdapter adapter) {
        return adapter.getNodeFirstLine() == firstSelectedVariable.getNodeFirstLine() && adapter.getNodeIndent() < firstSelectedVariable.getNodeIndent();
    }

    private boolean isBeforeSelectedLine(SimpleAdapter firstSelectedVariable, SimpleAdapter adapter) {
        return adapter.getNodeFirstLine() < firstSelectedVariable.getNodeFirstLine();
    }

    private boolean isUsed(String var, List<SimpleAdapter> scopeVariables) {
        for (SimpleAdapter adapter : scopeVariables) {
            Object astNode = adapter.getASTNode();
            if (!(astNode instanceof Name)) continue;
            Name scopeVar = (Name)astNode;
            if (scopeVar.ctx != 1 && scopeVar.ctx != 4 || !scopeVar.id.equals(var)) continue;
            return true;
        }
        return false;
    }

    private boolean isStored(String var, List<SimpleAdapter> scopeVariables) {
        boolean isStored = false;
        for (SimpleAdapter adapter : scopeVariables) {
            Object astNode = adapter.getASTNode();
            if (astNode instanceof Name) {
                Name scopeVar = (Name)astNode;
                if (scopeVar.id.equals(var)) {
                    boolean bl = isStored = scopeVar.ctx == 2 || scopeVar.ctx == 5;
                }
            }
            if (isStored) break;
        }
        return isStored;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public List<String> getReturns() {
        return new ArrayList<String>(this.returns);
    }
}

