/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ui.controls.preview;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.PyCodeScanner;
import org.python.pydev.editor.PyColoredScanner;
import org.python.pydev.editor.PyDoubleClickStrategy;
import org.python.pydev.editor.autoedit.PyAutoIndentStrategy;
import org.python.pydev.editor.hover.PyAnnotationHover;
import org.python.pydev.editor.hover.PyTextHover;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.ColorCache;

public class PyPreviewConfiguration
extends SourceViewerConfiguration {
    private ColorCache colorCache;
    private PyAutoIndentStrategy autoIndentStrategy;
    private String[] indentPrefixes = new String[]{"    ", "\t", ""};
    private PresentationReconciler reconciler;
    private PyCodeScanner codeScanner;
    private PyColoredScanner commentScanner;
    private PyColoredScanner stringScanner;
    private PyColoredScanner backquotesScanner;
    private static final DefaultInformationControl.IInformationPresenter presenter = new DefaultInformationControl.IInformationPresenter(){

        public String updatePresentation(Display display, String infoText, TextPresentation presentation, int maxWidth, int maxHeight) {
            int start = -1;
            int i = 0;
            while (i < infoText.length()) {
                switch (infoText.charAt(i)) {
                    case '<': {
                        start = i;
                        break;
                    }
                    case '>': {
                        if (start < 0) break;
                        StyleRange range = new StyleRange(start, i - start + 1, null, null, 1);
                        presentation.addStyleRange(range);
                        start = -1;
                    }
                }
                ++i;
            }
            return infoText;
        }
    };

    public PyPreviewConfiguration(ColorCache colorManager) {
        this.colorCache = colorManager;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new PyAnnotationHover(sourceViewer);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType) {
        return new PyTextHover(sourceViewer, contentType);
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__python_comment", "__python_singleline_string1", "__python_singleline_string2", "__python_multiline_string1", "__python_multiline_string2"};
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__PYTHON_PARTITION_TYPE";
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{this.getPyAutoIndentStrategy()};
    }

    public PyAutoIndentStrategy getPyAutoIndentStrategy() {
        if (this.autoIndentStrategy == null) {
            this.autoIndentStrategy = new PyAutoIndentStrategy();
        }
        return this.autoIndentStrategy;
    }

    public void resetIndentPrefixes() {
        boolean spacesFirst;
        Preferences prefs = PydevPlugin.getDefault().getPluginPreferences();
        int tabWidth = prefs.getInt("TAB_WIDTH");
        FastStringBuffer spaces = new FastStringBuffer(8);
        int i = 0;
        while (i < tabWidth) {
            spaces.append(" ");
            ++i;
        }
        boolean bl = spacesFirst = prefs.getBoolean("SUBSTITUTE_TABS") && !this.getPyAutoIndentStrategy().getIndentPrefs().getForceTabs();
        if (spacesFirst) {
            this.indentPrefixes[0] = spaces.toString();
            this.indentPrefixes[1] = "\t";
        } else {
            this.indentPrefixes[0] = "\t";
            this.indentPrefixes[1] = spaces.toString();
        }
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        this.resetIndentPrefixes();
        sourceViewer.setIndentPrefixes(this.indentPrefixes, contentType);
        return this.indentPrefixes;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (contentType.equals("__dftl_partition_content_type")) {
            return new PyDoubleClickStrategy();
        }
        return super.getDoubleClickStrategy(sourceViewer, contentType);
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return PydevPlugin.getDefault().getPluginPreferences().getInt("TAB_WIDTH");
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        if (this.reconciler == null) {
            this.reconciler = new PresentationReconciler();
            this.reconciler.setDocumentPartitioning("__PYTHON_PARTITION_TYPE");
            IPreferenceStore preferences = PydevPlugin.getChainedPrefStore();
            this.commentScanner = new PyColoredScanner(this.colorCache, "COMMENT_COLOR", preferences.getInt("COMMENT_STYLE"));
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.commentScanner);
            this.reconciler.setDamager((IPresentationDamager)dr, "__python_comment");
            this.reconciler.setRepairer((IPresentationRepairer)dr, "__python_comment");
            this.backquotesScanner = new PyColoredScanner(this.colorCache, "BACKQUOTES_COLOR", preferences.getInt("BACKQUOTES_STYLE"));
            dr = new DefaultDamagerRepairer((ITokenScanner)this.backquotesScanner);
            this.reconciler.setDamager((IPresentationDamager)dr, "__python_backquotes");
            this.reconciler.setRepairer((IPresentationRepairer)dr, "__python_backquotes");
            this.stringScanner = new PyColoredScanner(this.colorCache, "STRING_COLOR", preferences.getInt("STRING_STYLE"));
            dr = new DefaultDamagerRepairer((ITokenScanner)this.stringScanner);
            this.reconciler.setDamager((IPresentationDamager)dr, "__python_singleline_string1");
            this.reconciler.setRepairer((IPresentationRepairer)dr, "__python_singleline_string1");
            this.reconciler.setDamager((IPresentationDamager)dr, "__python_singleline_string2");
            this.reconciler.setRepairer((IPresentationRepairer)dr, "__python_singleline_string2");
            this.reconciler.setDamager((IPresentationDamager)dr, "__python_multiline_string1");
            this.reconciler.setRepairer((IPresentationRepairer)dr, "__python_multiline_string1");
            this.reconciler.setDamager((IPresentationDamager)dr, "__python_multiline_string2");
            this.reconciler.setRepairer((IPresentationRepairer)dr, "__python_multiline_string2");
            this.codeScanner = new PyCodeScanner(this.colorCache);
            dr = new DefaultDamagerRepairer((ITokenScanner)this.codeScanner);
            this.reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
            this.reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        }
        return this.reconciler;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return new IInformationControlCreator(){

            public IInformationControl createInformationControl(Shell parent) {
                return new DefaultInformationControl(parent, presenter);
            }
        };
    }

    public void updateSyntaxColorAndStyle() {
        if (this.reconciler != null) {
            this.codeScanner.updateColors();
            IPreferenceStore preferences = PydevPlugin.getChainedPrefStore();
            this.commentScanner.setStyle(preferences.getInt("COMMENT_STYLE"));
            this.commentScanner.updateColorAndStyle();
            this.stringScanner.setStyle(preferences.getInt("STRING_STYLE"));
            this.stringScanner.updateColorAndStyle();
            this.backquotesScanner.setStyle(preferences.getInt("BACKQUOTES_STYLE"));
            this.backquotesScanner.updateColorAndStyle();
        }
    }
}

