/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.grammarcommon;

import com.rc.retroweaver.runtime.Autobox;
import java.math.BigInteger;
import java.util.List;
import org.python.pydev.parser.grammarcommon.IJJTPythonGrammarState;
import org.python.pydev.parser.grammarcommon.ITreeConstants;
import org.python.pydev.parser.jython.IParserHost;
import org.python.pydev.parser.jython.Node;
import org.python.pydev.parser.jython.ParseException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.SpecialStr;
import org.python.pydev.parser.jython.Token;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.Num;
import org.python.pydev.parser.jython.ast.Str;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPythonGrammar
implements ITreeConstants {
    public IParserHost hostLiteralMkr;
    public SimpleNode prev;
    public static boolean DEBUG = false;
    public static final boolean DEFAULT_SEARCH_ON_LAST = false;
    public static final int STRATEGY_ADD_AFTER_PREV = 0;
    public static final int STRATEGY_BEFORE_NEXT = 1;

    protected abstract IJJTPythonGrammarState getJJTree();

    public abstract Token getToken(int var1);

    protected abstract List<Object> getTokenSourceSpecialTokensList();

    protected abstract Token getJJLastPos();

    protected abstract Token getCurrentToken();

    protected final void addToPeek(Object t, boolean after) {
        this.addToPeek(t, after, null);
    }

    protected final void addToPeekCallFunc(Object t, boolean after) {
        Call n = (Call)this.getJJTree().peekNode();
        n.func.addSpecial(t, after);
    }

    protected final void addToPeek(Object t, boolean after, Class class_) {
        SimpleNode peeked = this.getJJTree().peekNode();
        this.addToPeek(peeked, t, after, class_);
    }

    protected final void addToPeek(SimpleNode peeked, Object t, boolean after, Class class_) {
        if (class_ != null && !peeked.getClass().equals(class_)) {
            throw new RuntimeException(new StringBuffer("Error, expecting class:").append(class_).append(" received class:").append(peeked.getClass()).append(" Representation:").append(peeked).toString());
        }
        t = this.convertStringToSpecialStr(t);
        peeked.addSpecial(t, after);
    }

    protected final void jjtreeOpenNodeScope(Node n) {
        if (DEBUG) {
            System.out.println(new StringBuffer("opening scope:").append(n).toString());
        }
        Token t = this.getToken(1);
        this.getJJTree().pushNodePos(t.beginLine, t.beginColumn);
    }

    protected final void jjtreeCloseNodeScope(Node n) {
        if (DEBUG) {
            System.out.println(new StringBuffer("closing scope:").append(n).toString());
        }
        SimpleNode peeked = this.getJJTree().setNodePos();
        List<Object> specialTokens = this.getTokenSourceSpecialTokensList();
        boolean after = true;
        if (n instanceof SimpleNode) {
            if (specialTokens.size() > 0) {
                if (this.prev == null) {
                    after = false;
                    this.prev = peeked;
                }
                if (DEBUG) {
                    System.out.println(new StringBuffer("closing scope ").append(peeked.getClass()).toString());
                }
                for (Object next : specialTokens) {
                    int strategy = 0;
                    if (next instanceof Object[]) {
                        strategy = (Integer)((Object[])next)[1];
                        next = ((Object[])next)[0];
                    }
                    if (strategy == 1) {
                        this.addToPeek(peeked, next, false, null);
                        continue;
                    }
                    if (next instanceof Token) {
                        this.findTokenToAdd((Token)next).addSpecial(next, after);
                        continue;
                    }
                    this.prev.addSpecial(next, after);
                }
                specialTokens.clear();
            }
            this.prev = peeked;
        }
    }

    public final SimpleNode findTokenToAdd(Token next) {
        SimpleNode curr = this.getJJTree().peekNode();
        if (curr != this.prev) {
            if (this.prev.beginLine == next.beginLine) {
                return this.prev;
            }
            if (curr.beginLine == next.beginLine) {
                return curr;
            }
            if (next.beginLine > this.prev.beginLine && next.beginLine > curr.beginLine) {
                return curr;
            }
        }
        return this.prev;
    }

    public final void addSpecialTokenToLastOpened(Object o) {
        o = this.convertStringToSpecialStr(o);
        this.getJJTree().getLastOpened().getSpecialsBefore().add(o);
    }

    public final void addSpecialToken(Object o, int strategy) {
        o = this.convertStringToSpecialStr(o);
        this.getTokenSourceSpecialTokensList().add(new Object[]{o, Autobox.valueOf((int)strategy)});
    }

    public final Object convertStringToSpecialStr(Object o) {
        if (o instanceof String) {
            try {
                o = this.createSpecialStr((String)o);
            }
            catch (ParseException parseException) {}
        }
        return o;
    }

    public final void addSpecialToken(Object o) {
        this.getTokenSourceSpecialTokensList().add(new Object[]{o, Autobox.valueOf((int)0)});
    }

    public final boolean findTokenAndAdd(String token) throws ParseException {
        return this.findTokenAndAdd(token, token, false);
    }

    public final Object createSpecialStr(String token) throws ParseException {
        return this.createSpecialStr(token, token);
    }

    public final Object createSpecialStr(String token, boolean searchOnLast) throws ParseException {
        return this.createSpecialStr(token, token, searchOnLast);
    }

    public final Object createSpecialStr(String token, String put) throws ParseException {
        return this.createSpecialStr(token, put, false);
    }

    public final Object createSpecialStr(String token, String put, boolean searchOnLast) throws ParseException {
        Token t = searchOnLast ? this.getJJLastPos() : this.getCurrentToken();
        while (t != null && t.image != null && !t.image.equals(token)) {
            t = t.next;
        }
        if (t != null) {
            return new SpecialStr(put, t.beginLine, t.beginColumn);
        }
        if (this.getCurrentToken() != null) {
            throw new ParseException(new StringBuffer("Expected:").append(token).toString(), this.getCurrentToken());
        }
        if (this.getJJLastPos() != null) {
            throw new ParseException(new StringBuffer("Expected:").append(token).toString(), this.getJJLastPos());
        }
        throw new ParseException(new StringBuffer("Expected:").append(token).toString());
    }

    public final boolean findTokenAndAdd(String token, String put, boolean searchOnLast) throws ParseException {
        Object s = this.createSpecialStr(token, put, searchOnLast);
        this.getTokenSourceSpecialTokensList().add(new Object[]{s, Autobox.valueOf((int)0)});
        return s instanceof SpecialStr;
    }

    protected final void makeInt(String s, int radix, String token, Num numberToFill) {
        numberToFill.num = token;
        if (s.endsWith("L") || s.endsWith("l")) {
            s = s.substring(0, s.length() - 1);
            numberToFill.n = this.hostLiteralMkr.newLong(new BigInteger(s, radix));
            numberToFill.type = 2;
            return;
        }
        int ndigits = s.length();
        int i = 0;
        while (i < ndigits && s.charAt(i) == '0') {
            ++i;
        }
        if (ndigits - i > 11) {
            numberToFill.n = this.hostLiteralMkr.newLong(new BigInteger(s, radix));
            numberToFill.type = 2;
            return;
        }
        long l = Long.valueOf(s, radix);
        if (l > 0xFFFFFFFFL || radix == 10 && l > Integer.MAX_VALUE) {
            numberToFill.n = this.hostLiteralMkr.newLong(new BigInteger(s, radix));
            numberToFill.type = 2;
            return;
        }
        numberToFill.n = this.hostLiteralMkr.newInteger((int)l);
        numberToFill.type = 1;
    }

    protected final void makeFloat(String s, Num numberToFill) {
        numberToFill.num = s;
        numberToFill.n = this.hostLiteralMkr.newFloat(Double.valueOf(s));
        numberToFill.type = 3;
    }

    protected final void makeLong(String s, Num numberToFill) {
        numberToFill.num = s;
        numberToFill.n = this.hostLiteralMkr.newLong(s);
        numberToFill.type = 2;
    }

    protected final void makeComplex(String s, Num numberToFill) {
        String compNumber = s.substring(0, s.length() - 1);
        numberToFill.num = s;
        numberToFill.n = this.hostLiteralMkr.newImaginary(Double.valueOf(compNumber));
        numberToFill.type = 6;
    }

    protected final void makeString(String s, int quotes, Str strToFill) {
        char quoteChar = s.charAt(0);
        int start = 0;
        boolean ustring = false;
        boolean bstring = false;
        if (quoteChar == 'u' || quoteChar == 'U') {
            ustring = true;
            ++start;
        } else if (quoteChar == 'b' || quoteChar == 'B') {
            bstring = true;
            ++start;
        }
        quoteChar = s.charAt(start);
        if (quoteChar == 'r' || quoteChar == 'R') {
            String str = s.substring(quotes + start + 1, s.length() - quotes);
            strToFill.type = this.getType(s.charAt(start + 1), quotes);
            strToFill.s = str;
            strToFill.unicode = ustring;
            strToFill.raw = true;
            strToFill.binary = bstring;
        } else {
            int n = s.length() - quotes;
            int i = quotes + start;
            String str = this.hostLiteralMkr.decode_UnicodeEscape(s, i, n, "strict", ustring);
            strToFill.type = this.getType(s.charAt(start), quotes);
            strToFill.s = str;
            strToFill.unicode = ustring;
            strToFill.raw = false;
            strToFill.binary = bstring;
        }
    }

    private final int getType(char c, int quotes) {
        switch (c) {
            case '\'': {
                return quotes == 1 ? 3 : 1;
            }
            case '\"': {
                return quotes == 1 ? 4 : 2;
            }
        }
        throw new RuntimeException(new StringBuffer("Unable to determine type. Char: ").append(c).append(" quotes:").append(quotes).toString());
    }
}

