/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.pylint;

import java.io.File;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.FileFieldEditor;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.PydevPrefs;
import org.python.pydev.utils.CustomizableFieldEditor;
import org.python.pydev.utils.LabelFieldEditor;

public class PyLintPrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String PYLINT_FILE_LOCATION = "PYLINT_FILE_LOCATION";
    public static final String USE_PYLINT = "USE_PYLINT";
    public static final boolean DEFAULT_USE_PYLINT = false;
    public static final int SEVERITY_IGNORE = -1;
    public static final int COLS = 4;
    public static final String[][] LABEL_AND_VALUE = new String[][]{{"Error", String.valueOf(2)}, {"Warning", String.valueOf(1)}, {"Info", String.valueOf(0)}, {"Ignore", String.valueOf(-1)}};
    public static final String SEVERITY_ERRORS = "SEVERITY_ERRORS";
    public static final int DEFAULT_SEVERITY_ERRORS = 2;
    public static final String SEVERITY_WARNINGS = "SEVERITY_WARNINGS";
    public static final int DEFAULT_SEVERITY_WARNINGS = 1;
    public static final String SEVERITY_FATAL = "SEVERITY_FATAL";
    public static final int DEFAULT_SEVERITY_FATAL = 2;
    public static final String SEVERITY_CODING_STANDARD = "SEVERITY_CODING_STANDARD";
    public static final int DEFAULT_SEVERITY_CODING_STANDARD = -1;
    public static final String SEVERITY_REFACTOR = "SEVERITY_REFACTOR";
    public static final int DEFAULT_SEVERITY_REFACTOR = -1;
    public static final String USE_CONSOLE = "USE_CONSOLE";
    public static final boolean DEFAULT_USE_CONSOLE = true;
    public static final String PYLINT_ARGS = "PYLINT_ARGS";
    public static final String DEFAULT_PYLINT_ARGS = "";
    public static final String MAX_PYLINT_DELTA = "MAX_PYLINT_DELTA";
    public static final int DEFAULT_MAX_PYLINT_DELTA = 4;
    private static boolean communicatedOnce = false;

    public PyLintPrefPage() {
        super(0);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("Pylint");
    }

    protected void createFieldEditors() {
        final Composite p = this.getFieldEditorParent();
        this.addField((FieldEditor)new BooleanFieldEditor(USE_PYLINT, "Use pylint?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(USE_CONSOLE, "Redirect Pylint output to console?", p));
        this.addField((FieldEditor)new IntegerFieldEditor(MAX_PYLINT_DELTA, "Max simultaneous processes for PyLint?", p));
        FileFieldEditor fileField = new FileFieldEditor(PYLINT_FILE_LOCATION, "Location of pylint (lint.py):", true, p);
        this.addField((FieldEditor)fileField);
        this.addField((FieldEditor)new RadioGroupFieldEditor(SEVERITY_FATAL, "FATAL Severity", 4, LABEL_AND_VALUE, p, true));
        this.addField((FieldEditor)new RadioGroupFieldEditor(SEVERITY_ERRORS, "ERRORS Severity", 4, LABEL_AND_VALUE, p, true));
        this.addField((FieldEditor)new RadioGroupFieldEditor(SEVERITY_WARNINGS, "WARNINGS Severity", 4, LABEL_AND_VALUE, p, true));
        this.addField((FieldEditor)new RadioGroupFieldEditor(SEVERITY_CODING_STANDARD, "CONVENTIONS Severity", 4, LABEL_AND_VALUE, p, true));
        this.addField((FieldEditor)new RadioGroupFieldEditor(SEVERITY_REFACTOR, "REFACTOR Severity", 4, LABEL_AND_VALUE, p, true));
        CustomizableFieldEditor stringFieldEditor = new CustomizableFieldEditor(PYLINT_ARGS, "Arguments to pass to pylint (customize its output).\nThe  --include-ids=y is always included and does not appear here..", p);
        this.addField(stringFieldEditor);
        String w = DEFAULT_PYLINT_ARGS;
        Button button = new Button(p, 0);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MessageDialog.openInformation((Shell)p.getShell(), (String)"Help", (String)"\n\nTo ignore some warning on a line in a file, you can put the comment: \n#IGNORE:ID, so that the id is the warning that you want to ignore. \nE.g.: if you have the code:\n\nfrom foo import * #IGNORE:W0401\n\nThe wildcard import will be ignored.\n\nNOTE:for warnings to appear in the problems view, you have\nto set your filter to accept the org.python.pydev.pylintproblem type!\n\nNOTE2: Make sure that your file is a valid module in the PYTHONPATH, because\npylint doesn't analyze the file itself, but the module itself (you should\nbe able to import it from python without giving the file path).");
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        button.setText("Click for help (ignoring errors and troubleshooting)");
        GridData d = new GridData();
        d.horizontalAlignment = 4;
        d.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)d);
        LabelFieldEditor fe = new LabelFieldEditor("Help", w, p);
        this.addField(fe);
    }

    public void init(IWorkbench workbench) {
    }

    public static String getPyLintLocation() {
        return PydevPrefs.getPreferences().getString(PYLINT_FILE_LOCATION);
    }

    public static boolean usePyLint() {
        boolean b = PydevPrefs.getPreferences().getBoolean(USE_PYLINT);
        if (!PyLintPrefPage.isPylintConfigured(PyLintPrefPage.getPyLintLocation())) {
            if (b && !communicatedOnce) {
                communicatedOnce = true;
                PydevPlugin.log("Unable to use pylint because it is not properly configured.");
            }
            return false;
        }
        return b;
    }

    public static boolean isPylintConfigured(String pylintLocation) {
        File pylint = new File(pylintLocation);
        return pylint.exists() || !pylint.isFile();
    }

    public static boolean useErrors() {
        return PyLintPrefPage.eSeverity() != -1;
    }

    public static boolean useWarnings() {
        return PyLintPrefPage.wSeverity() != -1;
    }

    public static boolean useFatal() {
        return PyLintPrefPage.fSeverity() != -1;
    }

    public static boolean useCodingStandard() {
        return PyLintPrefPage.cSeverity() != -1;
    }

    public static boolean useRefactorTips() {
        return PyLintPrefPage.rSeverity() != -1;
    }

    public static boolean useConsole() {
        return PydevPrefs.getPreferences().getBoolean(USE_CONSOLE);
    }

    public static String getPylintArgs() {
        return PydevPrefs.getPreferences().getString(PYLINT_ARGS);
    }

    public static int getMaxPyLintDelta() {
        return PydevPrefs.getPreferences().getInt(MAX_PYLINT_DELTA);
    }

    public static int wSeverity() {
        return PydevPrefs.getPreferences().getInt(SEVERITY_WARNINGS);
    }

    public static int eSeverity() {
        return PydevPrefs.getPreferences().getInt(SEVERITY_ERRORS);
    }

    public static int fSeverity() {
        return PydevPrefs.getPreferences().getInt(SEVERITY_FATAL);
    }

    public static int cSeverity() {
        return PydevPrefs.getPreferences().getInt(SEVERITY_CODING_STANDARD);
    }

    public static int rSeverity() {
        return PydevPrefs.getPreferences().getInt(SEVERITY_REFACTOR);
    }
}

