/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.docutils.ParsingUtils;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.parser.prettyprinter.IFormatter;
import org.python.pydev.plugin.PyCodeFormatterPage;

public class PyFormatStd
extends PyAction
implements IFormatter {
    public void run(IAction action) {
        try {
            IFormatter participant = (IFormatter)ExtensionHelper.getParticipant((String)"org.python.pydev.pydev_formatter");
            if (participant == null) {
                participant = this;
            }
            PySelection ps = new PySelection(this.getTextEditor());
            IDocument doc = ps.getDoc();
            int startLine = ps.getStartLineIndex();
            PyEdit pyEdit = this.getPyEdit();
            if (ps.getTextSelection().getLength() == 0) {
                participant.formatAll(doc, (IPyEdit)pyEdit);
            } else {
                participant.formatSelection(doc, startLine, ps.getEndLineIndex(), (IPyEdit)pyEdit, ps);
            }
            if (startLine >= doc.getNumberOfLines()) {
                startLine = doc.getNumberOfLines() - 1;
            }
            TextSelection sel = new TextSelection(doc, doc.getLineOffset(startLine), 0);
            this.getTextEditor().getSelectionProvider().setSelection((ISelection)sel);
        }
        catch (Exception e) {
            PyFormatStd.beep(e);
        }
    }

    public void formatSelection(IDocument doc, int startLine, int endLineIndex, IPyEdit edit, PySelection ps) {
        try {
            IRegion start = doc.getLineInformation(startLine);
            IRegion end = doc.getLineInformation(endLineIndex);
            int iStart = start.getOffset();
            int iEnd = end.getOffset() + end.getLength();
            String d = doc.get(iStart, iEnd - iStart);
            FormatStd formatStd = this.getFormat();
            String formatted = this.formatStr(d, formatStd);
            doc.replace(iStart, iEnd - iStart, formatted);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void formatAll(IDocument doc, IPyEdit edit) {
        String d = doc.get();
        FormatStd formatStd = this.getFormat();
        String formatted = this.formatStr(d, formatStd);
        doc.set(formatted);
    }

    private FormatStd getFormat() {
        FormatStd formatStd = new FormatStd();
        formatStd.assignWithSpaceInsideParens = PyCodeFormatterPage.useAssignWithSpacesInsideParenthesis();
        formatStd.operatorsWithSpace = PyCodeFormatterPage.useOperatorsWithSpace();
        formatStd.parametersWithSpace = PyCodeFormatterPage.useSpaceForParentesis();
        formatStd.spaceAfterComma = PyCodeFormatterPage.useSpaceAfterComma();
        return formatStd;
    }

    public String formatStr(String str, FormatStd std) {
        return this.formatStr(str, std, 0);
    }

    /*
     * Unable to fully structure code
     */
    private String formatStr(String str, FormatStd std, int parensLevel) {
        cs = str.toCharArray();
        buf = new FastStringBuffer();
        parsingUtils = ParsingUtils.create((Object)cs);
        lastChar = '\u0000';
        i = 0;
        while (i < cs.length) {
            c = cs[i];
            switch (c) {
                case '\"': 
                case '\'': {
                    i = parsingUtils.eatLiterals(buf, i);
                    break;
                }
                case '#': {
                    i = parsingUtils.eatComments(buf, i);
                    break;
                }
                case ',': {
                    i = this.formatForComma(std, cs, buf, i);
                    break;
                }
                case '(': {
                    i = this.formatForPar(parsingUtils, cs, i, std, buf, parensLevel + 1);
                    break;
                }
                case '*': {
                    isOperator = false;
                    j = buf.length() - 1;
                    while (j >= 0) {
                        localC = buf.charAt(j);
                        if (!Character.isWhitespace(localC)) {
                            if (localC == '(' || localC == ',') break;
                            if (Character.isJavaIdentifierPart(localC)) {
                                localBufToCheckWildImport = new FastStringBuffer();
                                while (Character.isJavaIdentifierPart(localC)) {
                                    localBufToCheckWildImport.append(localC);
                                    if (--j < 0) break;
                                    localC = buf.charAt(j);
                                }
                                if (localBufToCheckWildImport.reverse().toString().equals("import")) break;
                                isOperator = true;
                                break;
                            }
                        }
                        --j;
                    }
                    if (!isOperator) {
                        buf.append('*');
                        break;
                    }
                }
                case '+': 
                case '-': {
                    if (c == '-' || c == '+') {
                        localBufToCheckNumber = new FastStringBuffer();
                        j = buf.length() - 1;
                        while (j >= 0) {
                            localC = buf.charAt(j);
                            if (!Character.isJavaIdentifierPart(localC)) break;
                            localBufToCheckNumber.append(localC);
                            --j;
                        }
                        isExponential = true;
                        partialNumber = localBufToCheckNumber.reverse().toString();
                        partialLen = partialNumber.length();
                        if (partialLen < 2 || !Character.isDigit(partialNumber.charAt(0))) {
                            isExponential = false;
                        } else if (partialNumber.charAt(partialLen - 1) != 'e') {
                            isExponential = false;
                        }
                        if (isExponential) {
                            buf.append(c);
                            break;
                        }
                    }
                }
                case '!': 
                case '%': 
                case '&': 
                case '/': 
                case '<': 
                case '>': 
                case '^': 
                case '|': 
                case '~': {
                    i = this.handleOperator(std, cs, buf, parsingUtils, i, c);
                    c = cs[i];
                    break;
                }
                case '=': {
                    if (i >= cs.length - 1 || cs[i + 1] != '=') ** GOTO lbl78
                    i = this.handleOperator(std, cs, buf, parsingUtils, i, c);
                    c = cs[i];
                    break;
lbl-1000:
                    // 1 sources

                    {
                        buf.deleteLast();
lbl78:
                        // 2 sources

                        ** while (buf.length() > 0 && buf.lastChar() == ' ')
                    }
lbl79:
                    // 1 sources

                    surroundWithSpaces = std.operatorsWithSpace;
                    if (parensLevel > 0) {
                        surroundWithSpaces = std.assignWithSpaceInsideParens;
                    }
                    if (surroundWithSpaces) {
                        buf.append(' ');
                    }
                    buf.append('=');
                    if (surroundWithSpaces) {
                        buf.append(' ');
                    }
                    i = parsingUtils.eatWhitespaces(null, i + 1);
                    break;
                }
                default: {
                    if ((c == '\r' || c == '\n') && lastChar == ',' && std.spaceAfterComma && buf.lastChar() == ' ') {
                        buf.deleteLast();
                    }
                    buf.append(c);
                }
            }
            lastChar = c;
            ++i;
        }
        return buf.toString();
    }

    private int handleOperator(FormatStd std, char[] cs, FastStringBuffer buf, ParsingUtils parsingUtils, int i, char c) {
        boolean isUnary = false;
        if (c == '~' || c == '+' || c == '-') {
            isUnary = buf.length() == 0;
        }
        while (buf.length() > 0 && buf.lastChar() == ' ') {
            buf.deleteLast();
        }
        boolean surroundWithSpaces = std.operatorsWithSpace;
        if (!isUnary && surroundWithSpaces) {
            buf.append(' ');
        }
        char localC = c;
        boolean backOne = true;
        while (this.isOperatorPart(localC)) {
            buf.append(localC);
            if (++i == cs.length) break;
            localC = cs[i];
            if (localC != '=') continue;
            buf.append(localC);
            backOne = false;
            break;
        }
        if (backOne) {
            --i;
        }
        if (!isUnary && surroundWithSpaces) {
            buf.append(' ');
        }
        i = parsingUtils.eatWhitespaces(null, i + 1);
        return i;
    }

    private boolean isOperatorPart(char c) {
        switch (c) {
            case '!': 
            case '%': 
            case '&': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case '<': 
            case '=': 
            case '>': 
            case '^': 
            case '|': 
            case '~': {
                return true;
            }
        }
        return false;
    }

    private int formatForPar(ParsingUtils parsingUtils, char[] cs, int i, FormatStd std, FastStringBuffer buf, int parensLevel) {
        char c = ' ';
        FastStringBuffer locBuf = new FastStringBuffer();
        int j = i + 1;
        while (j < cs.length && (c = cs[j]) != ')') {
            ++j;
            if (c == '\'' || c == '\"') {
                j = parsingUtils.eatLiterals(locBuf, j - 1) + 1;
                continue;
            }
            if (c == '#') {
                j = parsingUtils.eatComments(locBuf, j - 1) + 1;
                continue;
            }
            if (c == '(') {
                j = this.formatForPar(parsingUtils, cs, j - 1, std, locBuf, parensLevel + 1) + 1;
                continue;
            }
            locBuf.append(c);
        }
        if (c == ')') {
            FastStringBuffer buf1 = new FastStringBuffer();
            if (locBuf.indexOf('\n') != -1 || locBuf.indexOf('\r') != -1) {
                char c1;
                int k = locBuf.length();
                while (k > 0 && (c1 = locBuf.charAt(k - 1)) != '\n' && c1 != '\r') {
                    buf1.insert(0, c1);
                    --k;
                }
            }
            String formatStr = this.formatStr(this.trim(locBuf).toString(), std, parensLevel);
            FastStringBuffer formatStrBuf = this.trim(new FastStringBuffer(formatStr, 10));
            String closing = ")";
            if (buf1.length() > 0 && PySelection.containsOnlyWhitespaces((String)buf1.toString())) {
                formatStrBuf.append(buf1);
            } else if (std.parametersWithSpace) {
                closing = " )";
            }
            if (std.parametersWithSpace) {
                if (formatStrBuf.length() == 0) {
                    buf.append("()");
                } else {
                    buf.append("( ");
                    buf.append(formatStrBuf);
                    buf.append(closing);
                }
            } else {
                buf.append('(');
                buf.append(formatStrBuf);
                buf.append(closing);
            }
            return j;
        }
        return i;
    }

    private FastStringBuffer trim(FastStringBuffer locBuf) {
        while (locBuf.length() > 0 && locBuf.firstChar() == ' ') {
            locBuf.deleteCharAt(0);
        }
        while (locBuf.length() > 0 && locBuf.lastChar() == ' ') {
            locBuf.deleteLast();
        }
        return locBuf;
    }

    private int formatForComma(FormatStd std, char[] cs, FastStringBuffer buf, int i) {
        while (i < cs.length - 1 && cs[i + 1] == ' ') {
            ++i;
        }
        if (std.spaceAfterComma) {
            buf.append(", ");
        } else {
            buf.append(',');
        }
        return i;
    }

    public static class FormatStd {
        public boolean spaceAfterComma;
        public boolean parametersWithSpace;
        public boolean assignWithSpaceInsideParens;
        public boolean operatorsWithSpace;
    }
}

