/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited.modules;

import com.rc.retroweaver.runtime.Autobox;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.IDefinition;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ISourceModule;
import org.python.pydev.core.IToken;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.Tuple3;
import org.python.pydev.core.cache.Cache;
import org.python.pydev.core.cache.LRUCache;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.structure.CompletionRecursionException;
import org.python.pydev.core.structure.FastStack;
import org.python.pydev.editor.codecompletion.revisited.AbstractToken;
import org.python.pydev.editor.codecompletion.revisited.CompletionState;
import org.python.pydev.editor.codecompletion.revisited.ConcreteToken;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.AbstractJavaClassModule;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.editor.codecompletion.revisited.modules.CompiledModule;
import org.python.pydev.editor.codecompletion.revisited.modules.CompiledToken;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.AssignDefinition;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.codecompletion.revisited.visitors.FindDefinitionModelVisitor;
import org.python.pydev.editor.codecompletion.revisited.visitors.FindScopeVisitor;
import org.python.pydev.editor.codecompletion.revisited.visitors.GlobalModelVisitor;
import org.python.pydev.editor.codecompletion.revisited.visitors.LocalScope;
import org.python.pydev.editor.codecompletion.revisited.visitors.StopVisitingException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Module;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceModule
extends AbstractModule
implements ISourceModule {
    private static final IToken[] EMPTY_ITOKEN_ARRAY = new IToken[0];
    private static final boolean DEBUG_INTERNAL_GLOBALS_CACHE = false;
    public static boolean TESTING = false;
    private SimpleNode ast;
    private File file;
    private Boolean bootstrap;
    public String zipFilePath;
    public final Throwable parseError;
    private long lastModified;
    private HashMap<Integer, TreeMap<String, Object>> tokensCache = new HashMap();
    private GlobalModelVisitor globalModelVisitorCache = null;
    private Cache<Object, FindScopeVisitor> scopeVisitorCache = new LRUCache(10);
    private Cache<Object, FindDefinitionModelVisitor> findDefinitionVisitorCache = new LRUCache(10);

    @Override
    public String getZipFilePath() {
        return this.zipFilePath;
    }

    public GlobalModelVisitor getGlobalModelVisitorCache() {
        return this.globalModelVisitorCache;
    }

    @Override
    public IToken[] getWildImportedModules() {
        return this.getTokens(2, null, null);
    }

    @Override
    public IToken[] getTokenImportedModules() {
        return this.getTokens(4, null, null);
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public IToken[] getGlobalTokens() {
        return this.getTokens(1, null, null);
    }

    @Override
    public String getDocString() {
        IToken[] l = this.getTokens(8, null, null);
        if (l.length > 0) {
            SimpleNode a = ((SourceToken)l[0]).getAst();
            return ((Str)a).s;
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInDirectGlobalTokens(String tok, ICompletionCache completionCache) {
        TreeMap<String, Object> tokens = this.tokensCache.get(Autobox.valueOf((int)1));
        if (tokens == null) {
            this.getGlobalTokens();
        }
        boolean ret = false;
        if (tokens != null) {
            TreeMap<String, Object> treeMap = tokens;
            synchronized (treeMap) {
                ret = tokens.containsKey(tok);
            }
        }
        if (!ret) {
            ret = this.isInDirectImportTokens(tok);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInDirectImportTokens(String tok) {
        TreeMap<String, Object> tokens = this.tokensCache.get(Autobox.valueOf((int)4));
        if (tokens != null) {
            this.getTokenImportedModules();
        }
        boolean ret = false;
        if (tokens != null) {
            TreeMap<String, Object> treeMap = tokens;
            synchronized (treeMap) {
                ret = tokens.containsKey(tok);
            }
        }
        return ret;
    }

    private synchronized IToken[] getTokens(int which, ICompletionState state, String lookOnlyForNameStartingWith) {
        if ((which & 0x10) != 0) {
            throw new RuntimeException("Cannot do this one with caches");
        }
        TreeMap<String, Object> tokens = this.tokensCache.get(Autobox.valueOf((int)which));
        if (tokens != null) {
            return this.createArrayFromCacheValues(tokens, lookOnlyForNameStartingWith);
        }
        try {
            GlobalModelVisitor globalModelVisitor;
            this.tokensCache.put(Autobox.valueOf((int)4), new TreeMap());
            this.tokensCache.put(Autobox.valueOf((int)1), new TreeMap());
            this.tokensCache.put(Autobox.valueOf((int)2), new TreeMap());
            this.tokensCache.put(Autobox.valueOf((int)8), new TreeMap());
            int all = 15;
            this.globalModelVisitorCache = globalModelVisitor = GlobalModelVisitor.getGlobalModuleVisitorWithTokens(this.ast, all, this.name, state, false);
            List<IToken> ret = globalModelVisitor.getTokens();
            for (IToken token : ret) {
                int choice = token.isWildImport() ? 2 : (token.isImportFrom() || token.isImport() ? 4 : (token.isString() ? 8 : 1));
                String rep = token.getRepresentation();
                TreeMap<String, Object> treeMap = this.tokensCache.get(Autobox.valueOf((int)choice));
                SourceToken newSourceToken = (SourceToken)token;
                Object current = treeMap.get(rep);
                if (current == null) {
                    treeMap.put(rep, newSourceToken);
                    continue;
                }
                if (current instanceof List) {
                    ((List)current).add(0, newSourceToken);
                    continue;
                }
                if (current instanceof SourceToken) {
                    ArrayList<SourceToken> lst = new ArrayList<SourceToken>();
                    lst.add(newSourceToken);
                    lst.add((SourceToken)current);
                    treeMap.put(rep, lst);
                    continue;
                }
                throw new RuntimeException(new StringBuffer("Unexpected class in cache:").append(current).toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tokens = this.tokensCache.get(Autobox.valueOf((int)which));
        return this.createArrayFromCacheValues(tokens, lookOnlyForNameStartingWith);
    }

    private IToken[] createArrayFromCacheValues(TreeMap<String, Object> tokens, String lookOnlyForNameStartingWith) {
        ArrayList<SourceToken> ret = new ArrayList<SourceToken>();
        Collection<Object> lookIn = lookOnlyForNameStartingWith == null ? tokens.values() : tokens.subMap(lookOnlyForNameStartingWith, new StringBuffer(String.valueOf(lookOnlyForNameStartingWith)).append("z").toString()).values();
        for (Object o : lookIn) {
            if (o instanceof SourceToken) {
                ret.add((SourceToken)o);
                continue;
            }
            if (o instanceof List) {
                ret.addAll((List)o);
                continue;
            }
            throw new RuntimeException(new StringBuffer("Unexpected class in cache:").append(o).toString());
        }
        return ret.toArray(new SourceToken[ret.size()]);
    }

    public SourceModule(String name, File f, SimpleNode n, Throwable parseError) {
        super(name);
        this.ast = n;
        this.file = f;
        this.parseError = parseError;
        if (f != null) {
            this.lastModified = f.lastModified();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public IToken[] getGlobalTokens(ICompletionState initialState, ICodeCompletionASTManager manager) {
        String activationToken = initialState.getActivationToken();
        int activationTokenLen = activationToken.length();
        String[] actToks = StringUtils.dotSplit((String)activationToken);
        String goFor = null;
        if (actToks.length > 0) {
            goFor = actToks[0];
        }
        IToken[] t = this.getTokens(1, null, goFor);
        int i = 0;
        while (i < t.length) {
            SourceToken token = (SourceToken)t[i];
            String rep = token.getRepresentation();
            SimpleNode ast = token.getAst();
            if (activationTokenLen > rep.length() && activationToken.startsWith(rep)) {
                int iActTok = 0;
                if (actToks[iActTok].equals(rep)) {
                    try {
                        String value = activationToken;
                        String initialValue = null;
                        while (!value.equals(initialValue)) {
                            initialValue = value;
                            if (iActTok > actToks.length) break;
                            Definition[] definitions = this.findDefinition(initialState.getCopyWithActTok(value), token.getLineDefinition(), token.getColDefinition() + 1, manager.getNature());
                            if (definitions.length != 1) return this.getValueCompletions(initialState, manager, value, this);
                            Definition d = definitions[0];
                            if (d.ast instanceof Assign) {
                                Assign assign = (Assign)d.ast;
                                value = NodeUtils.getRepresentationString((SimpleNode)assign.value);
                                definitions = this.findDefinition(initialState.getCopyWithActTok(value), d.line, d.col, manager.getNature());
                            } else if (d.ast instanceof ClassDef) {
                                IToken[] toks = ((SourceModule)d.module).getClassToks(initialState, manager, d.ast).toArray(EMPTY_ITOKEN_ARRAY);
                                if (iActTok == actToks.length - 1) {
                                    return toks;
                                }
                                value = d.value;
                            } else if (d.ast instanceof Name) {
                                ClassDef classDef = (ClassDef)d.scope.getClassDef();
                                if (classDef != null) {
                                    FindDefinitionModelVisitor visitor = new FindDefinitionModelVisitor(actToks[actToks.length - 1], d.line, d.col, d.module);
                                    try {
                                        classDef.accept((VisitorIF)visitor);
                                    }
                                    catch (StopVisitingException stopVisitingException) {}
                                    if (visitor.definitions.size() == 0) {
                                        return EMPTY_ITOKEN_ARRAY;
                                    }
                                    d = visitor.definitions.get(0);
                                    value = d.value;
                                    if (d instanceof AssignDefinition) {
                                        return this.getValueCompletions(initialState, manager, value, d.module);
                                    }
                                } else if (d.module instanceof SourceModule) {
                                    SourceModule m = (SourceModule)d.module;
                                    String joined = FullRepIterable.joinFirstParts((String[])actToks);
                                    Definition[] definitions2 = m.findDefinition(initialState.getCopyWithActTok(joined), d.line, d.col, manager.getNature());
                                    if (definitions2.length == 0) {
                                        return EMPTY_ITOKEN_ARRAY;
                                    }
                                    d = definitions2[0];
                                    value = new StringBuffer(String.valueOf(d.value)).append(".").append(actToks[actToks.length - 1]).toString();
                                    if (d instanceof AssignDefinition) {
                                        return ((SourceModule)d.module).getValueCompletions(initialState, manager, value, d.module);
                                    }
                                }
                            } else {
                                if ((d.ast != null || d.module == null) && !(d.ast instanceof ImportFrom)) break;
                                return this.getValueCompletions(initialState, manager, value, d.module);
                            }
                            ++iActTok;
                        }
                    }
                    catch (CompletionRecursionException completionRecursionException) {
                    }
                    catch (Exception e) {
                        PydevPlugin.log(e);
                    }
                }
            } else if (rep.equals(activationToken)) {
                List<IToken> classToks;
                if (ast instanceof ClassDef) {
                    initialState.setLookingFor(2);
                }
                if ((classToks = this.getClassToks(initialState, manager, ast)).size() != 0) return classToks.toArray(EMPTY_ITOKEN_ARRAY);
                if (initialState.getLookingFor() != 4) {
                    return EMPTY_ITOKEN_ARRAY;
                }
            }
            ++i;
        }
        return EMPTY_ITOKEN_ARRAY;
    }

    private IToken[] getValueCompletions(ICompletionState initialState, ICodeCompletionASTManager manager, String value, IModule module) throws CompletionRecursionException {
        initialState.checkFindMemory((IModule)this, value);
        ICompletionState copy = initialState.getCopy();
        copy.setActivationToken(value);
        IToken[] completionsForModule = manager.getCompletionsForModule(module, copy);
        return completionsForModule;
    }

    public List<IToken> getClassToks(ICompletionState initialState, ICodeCompletionASTManager manager, SimpleNode ast) {
        List<IToken> modToks = GlobalModelVisitor.getTokens(ast, 16, this.name, initialState, false);
        try {
            if (ast instanceof ClassDef) {
                ClassDef c = (ClassDef)ast;
                int j = 0;
                while (j < c.bases.length) {
                    IToken[] comps;
                    ICompletionState state;
                    if (c.bases[j] instanceof Name) {
                        Name n = (Name)c.bases[j];
                        String base = n.id;
                        state = initialState.getCopy();
                        state.setActivationToken(base);
                        state.checkMemory((IModule)this, base);
                        comps = manager.getCompletionsForModule((IModule)this, state);
                        modToks.addAll((Collection<IToken>)Arrays.asList(comps));
                    } else if (c.bases[j] instanceof Attribute) {
                        Attribute attr = (Attribute)c.bases[j];
                        String s = NodeUtils.getFullRepresentationString((SimpleNode)attr);
                        state = initialState.getCopy();
                        state.setActivationToken(s);
                        comps = manager.getCompletionsForModule((IModule)this, state);
                        modToks.addAll((Collection<IToken>)Arrays.asList(comps));
                    }
                    ++j;
                }
            }
        }
        catch (CompletionRecursionException completionRecursionException) {}
        return modToks;
    }

    private FindScopeVisitor getScopeVisitor(int line, int col) throws Exception {
        Tuple key = new Tuple((Object)Autobox.valueOf((int)line), (Object)Autobox.valueOf((int)col));
        FindScopeVisitor scopeVisitor = (FindScopeVisitor)((Object)this.scopeVisitorCache.getObj((Object)key));
        if (scopeVisitor == null) {
            scopeVisitor = new FindScopeVisitor(line, col);
            if (this.ast != null) {
                this.ast.accept((VisitorIF)scopeVisitor);
            }
            this.scopeVisitorCache.add((Object)key, (Object)scopeVisitor);
        }
        return scopeVisitor;
    }

    private FindDefinitionModelVisitor getFindDefinitionsScopeVisitor(String rep, int line, int col) throws Exception {
        Tuple3 key = new Tuple3((Object)rep, (Object)Autobox.valueOf((int)line), (Object)Autobox.valueOf((int)col));
        FindDefinitionModelVisitor visitor = (FindDefinitionModelVisitor)((Object)this.findDefinitionVisitorCache.getObj((Object)key));
        if (visitor == null) {
            visitor = new FindDefinitionModelVisitor(rep, line, col, this);
            if (this.ast != null) {
                try {
                    this.ast.accept((VisitorIF)visitor);
                }
                catch (StopVisitingException stopVisitingException) {}
            }
            this.findDefinitionVisitorCache.add((Object)key, (Object)visitor);
        }
        return visitor;
    }

    @Override
    public Definition[] findDefinition(ICompletionState state, int line, int col, IPythonNature nature) throws Exception {
        ClassDef classDef;
        ICompletionState copy;
        Tuple3 o;
        String rep = state.getActivationToken();
        ArrayList<Definition> toRet = new ArrayList<Definition>();
        FindScopeVisitor scopeVisitor = this.getScopeVisitor(line, col);
        FindDefinitionModelVisitor visitor = this.getFindDefinitionsScopeVisitor(rep, line, col);
        if (visitor.definitions.size() > 0) {
            for (Definition next : visitor.definitions) {
                if (next instanceof AssignDefinition) {
                    AssignDefinition element = (AssignDefinition)next;
                    if (!element.target.startsWith("self")) {
                        if (!element.scope.isOuterOrSameScope(scopeVisitor.scope) && !element.foundAsGlobal) continue;
                        toRet.add(element);
                        continue;
                    }
                    toRet.add(element);
                    continue;
                }
                toRet.add(next);
            }
            if (toRet.size() > 0) {
                return toRet.toArray(new Definition[0]);
            }
        }
        IToken[] localTokens = scopeVisitor.scope.getAllLocalTokens();
        IToken[] iTokenArray = localTokens;
        int n = localTokens.length;
        int element = 0;
        while (element < n) {
            IToken tok = iTokenArray[element];
            if (tok.getRepresentation().equals(rep)) {
                return new Definition[]{new Definition(tok, scopeVisitor.scope, this, true)};
            }
            ++element;
        }
        List localImportedModules = scopeVisitor.scope.getLocalImportedModules(line, col, this.name);
        ICodeCompletionASTManager astManager = nature.getAstManager();
        for (IToken tok : localImportedModules) {
            if (!tok.getRepresentation().equals(rep)) continue;
            o = astManager.findOnImportedMods(new IToken[]{tok}, state.getCopyWithActTok(rep), this.getName());
            if (o != null && o.o1 instanceof SourceModule) {
                copy = state.getCopy();
                copy.setActivationToken((String)o.o2);
                this.findDefinitionsFromModAndTok(nature, toRet, null, (SourceModule)o.o1, copy);
            }
            if (toRet.size() <= 0) continue;
            return toRet.toArray(new Definition[0]);
        }
        if (rep.startsWith("self.") && (classDef = (ClassDef)scopeVisitor.scope.getClassDef()) != null) {
            String classRep = NodeUtils.getRepresentationString((SimpleNode)classDef);
            IToken[] globalTokens = this.getGlobalTokens(new CompletionState(line - 1, col - 1, classRep, nature, "", (ICompletionCache)state), astManager);
            String withoutSelf = rep.substring(5);
            IToken[] iTokenArray2 = globalTokens;
            int n2 = globalTokens.length;
            int n3 = 0;
            while (n3 < n2) {
                IToken token = iTokenArray2[n3];
                if (token.getRepresentation().equals(withoutSelf)) {
                    String parentPackage = token.getParentPackage();
                    IModule module = astManager.getModule(parentPackage, nature, true);
                    if (token instanceof SourceToken && (module != null || this.name.equals(parentPackage))) {
                        if (module == null) {
                            module = this;
                        }
                        SimpleNode ast2 = ((SourceToken)token).getAst();
                        Tuple<Integer, Integer> def = this.getLineColForDefinition(ast2);
                        FastStack stack = new FastStack();
                        if (module instanceof SourceModule) {
                            stack.push((Object)((SourceModule)module).getAst());
                        }
                        stack.push((Object)classDef);
                        LocalScope scope = new LocalScope((FastStack<SimpleNode>)stack);
                        return new Definition[]{new Definition((Integer)def.o1, (Integer)def.o2, token.getRepresentation(), ast2, scope, module)};
                    }
                    return new Definition[0];
                }
                ++n3;
            }
        }
        String tok = rep;
        SourceModule mod = this;
        o = astManager.findOnImportedMods(state.getCopyWithActTok(rep), (IModule)this);
        if (o != null) {
            if (o.o1 instanceof SourceModule) {
                mod = (SourceModule)o.o1;
                tok = (String)o.o2;
            } else {
                if (o.o1 instanceof CompiledModule) {
                    tok = (String)o.o2;
                    if (tok == null || tok.length() == 0) {
                        return new Definition[]{new Definition(1, 1, "", null, null, (IModule)o.o1)};
                    }
                    state.checkFindDefinitionMemory((IModule)o.o1, tok);
                    return (Definition[])((IModule)o.o1).findDefinition(state.getCopyWithActTok(tok), -1, -1, nature);
                }
                if (o.o1 instanceof AbstractJavaClassModule) {
                    tok = (String)o.o2;
                    state.checkFindDefinitionMemory((IModule)o.o1, tok);
                    return (Definition[])((IModule)o.o1).findDefinition(state.getCopyWithActTok(tok), -1, -1, nature);
                }
                throw new RuntimeException(new StringBuffer("Unexpected module found in imports: ").append(o).toString());
            }
        }
        copy = state.getCopy();
        copy.setActivationToken(tok);
        try {
            state.checkFindDefinitionMemory((IModule)mod, tok);
            this.findDefinitionsFromModAndTok(nature, toRet, visitor.moduleImported, mod, copy);
        }
        catch (CompletionRecursionException completionRecursionException) {}
        return toRet.toArray(new Definition[0]);
    }

    private void findDefinitionsFromModAndTok(IPythonNature nature, ArrayList<Definition> toRet, String moduleImported, SourceModule mod, ICompletionState state) throws Exception {
        String tok = state.getActivationToken();
        if (tok != null) {
            if (tok.length() > 0) {
                Definition d = mod.findGlobalTokDef(state.getCopyWithActTok(tok), nature);
                if (d != null) {
                    toRet.add(d);
                } else if (moduleImported != null) {
                    this.getModuleDefinition(nature, toRet, mod, moduleImported);
                }
            } else {
                toRet.add(new Definition(1, 1, "", null, null, mod));
            }
        }
    }

    private IDefinition getModuleDefinition(IPythonNature nature, ArrayList<Definition> toRet, SourceModule mod, String moduleImported) {
        String rel = AbstractToken.makeRelative(mod.getName(), moduleImported);
        IModule modFound = nature.getAstManager().getModule(rel, nature, false);
        if (modFound == null) {
            modFound = nature.getAstManager().getModule(moduleImported, nature, false);
        }
        if (modFound != null) {
            Definition definition = new Definition(1, 1, "", null, null, modFound);
            if (toRet != null) {
                toRet.add(definition);
            }
            return definition;
        }
        return null;
    }

    public Definition findGlobalTokDef(ICompletionState state, IPythonNature nature) throws Exception {
        String tok = state.getActivationToken();
        String[] headAndTail = FullRepIterable.headAndTail((String)tok);
        String firstPart = headAndTail[0];
        String rep = headAndTail[1];
        IToken[] tokens = null;
        tokens = nature != null ? nature.getAstManager().getCompletionsForModule((IModule)this, state.getCopyWithActTok(firstPart), true) : this.getGlobalTokens();
        IToken[] iTokenArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            block17: {
                IToken token = iTokenArray[n2];
                boolean sameRep = token.getRepresentation().equals(rep);
                if (sameRep) {
                    if (token instanceof SourceToken) {
                        if (((SourceToken)token).getType() != 10) {
                            IModule mod;
                            SimpleNode a = ((SourceToken)token).getAst();
                            Tuple<Integer, Integer> def = this.getLineColForDefinition(a);
                            String parentPackage = token.getParentPackage();
                            SourceModule module = this;
                            if (nature != null && (mod = nature.getAstManager().getModule(parentPackage, nature, true)) != null) {
                                module = mod;
                            }
                            if (module instanceof SourceModule) {
                                SourceModule m = module;
                                FindScopeVisitor scopeVisitor = super.getScopeVisitor(a.beginLine, a.beginColumn);
                                return new Definition((Integer)def.o1, (Integer)def.o2, rep, a, scopeVisitor.scope, module);
                            }
                            return new Definition((Integer)def.o1, (Integer)def.o2, rep, a, new LocalScope((FastStack<SimpleNode>)new FastStack()), module);
                        }
                    } else {
                        if (token instanceof ConcreteToken) {
                            String modName = token.getParentPackage();
                            if (modName.length() > 0) {
                                modName = new StringBuffer(String.valueOf(modName)).append(".").toString();
                            }
                            modName = new StringBuffer(String.valueOf(modName)).append(token.getRepresentation()).toString();
                            IModule module = nature.getAstManager().getModule(modName, nature, true);
                            if (module == null) {
                                return null;
                            }
                            return new Definition(1, 1, "", null, null, module);
                        }
                        if (token instanceof CompiledToken) {
                            String parentPackage = token.getParentPackage();
                            FullRepIterable iterable = new FullRepIterable(parentPackage, true);
                            IModule module = null;
                            for (String modName : iterable) {
                                module = nature.getAstManager().getModule(modName, nature, true);
                                if (module != null) break;
                            }
                            if (module == null) {
                                return null;
                            }
                            int length = module.getName().length();
                            String finalRep = "";
                            if (parentPackage.length() > length) {
                                finalRep = new StringBuffer(String.valueOf(parentPackage.substring(length + 1))).append('.').toString();
                            }
                            finalRep = new StringBuffer(String.valueOf(finalRep)).append(token.getRepresentation()).toString();
                            try {
                                IDefinition[] definitions = module.findDefinition(state.getCopyWithActTok(finalRep), -1, -1, nature);
                                if (definitions.length > 0) {
                                    return (Definition)definitions[0];
                                }
                                break block17;
                            }
                            catch (Exception e) {
                                throw new RuntimeException(e);
                            }
                        }
                        throw new RuntimeException(new StringBuffer("Unexpected token:").append(token.getClass()).toString());
                    }
                }
            }
            ++n2;
        }
        return null;
    }

    public Tuple<Integer, Integer> getLineColForDefinition(SimpleNode a) {
        int line = a.beginLine;
        int col = a.beginColumn;
        if (a instanceof ClassDef) {
            ClassDef c = (ClassDef)a;
            line = c.name.beginLine;
            col = c.name.beginColumn;
        } else if (a instanceof FunctionDef) {
            FunctionDef c = (FunctionDef)a;
            line = c.name.beginLine;
            col = c.name.beginColumn;
        }
        return new Tuple((Object)Autobox.valueOf((int)line), (Object)Autobox.valueOf((int)col));
    }

    @Override
    public IToken[] getLocalTokens(int line, int col, ILocalScope scope) {
        try {
            if (scope == null) {
                FindScopeVisitor scopeVisitor = this.getScopeVisitor(line, col);
                scope = scopeVisitor.scope;
            }
            return scope.getLocalTokens(line, col, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            return EMPTY_ITOKEN_ARRAY;
        }
    }

    @Override
    public ILocalScope getLocalScope(int line, int col) {
        try {
            FindScopeVisitor scopeVisitor = this.getScopeVisitor(line, col);
            return scopeVisitor.scope;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isSynched() {
        if (this.file == null && TESTING) {
            return true;
        }
        return this.file.lastModified() == this.lastModified;
    }

    public SimpleNode getAst() {
        return this.ast;
    }

    public int findAstEnd(SimpleNode node) {
        try {
            FindScopeVisitor scopeVisitor = this.getScopeVisitor(node.beginLine, node.beginColumn);
            return scopeVisitor.scope.getScopeEndLine();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public int findIfMain() {
        try {
            FindScopeVisitor scopeVisitor = this.getScopeVisitor(-1, -1);
            return scopeVisitor.scope.getIfMainLine();
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SourceModule)) {
            return false;
        }
        SourceModule m = (SourceModule)obj;
        if (this.file == null || m.file == null) {
            if (this.file != null) {
                return false;
            }
            if (m.file != null) {
                return false;
            }
            return this.name.equals(m.name);
        }
        return REF.getFileAbsolutePath((File)this.file).equals(REF.getFileAbsolutePath((File)m.file)) && this.name.equals(m.name);
    }

    public void setName(String n) {
        this.name = n;
    }

    public boolean isBootstrapModule() {
        if (this.bootstrap == null) {
            SimpleNode ast;
            IToken tok;
            IToken[] ret = this.getGlobalTokens();
            if (ret != null && ret.length == 1 && this.file != null && "__bootstrap__".equals((tok = ret[0]).getRepresentation()) && (ast = this.getAst()) instanceof Module) {
                Module module = (Module)ast;
                if (module.body != null && module.body.length > 0 && (ast = module.body[module.body.length - 1]) instanceof Expr) {
                    Call call;
                    String callRep;
                    Expr expr = (Expr)ast;
                    ast = expr.value;
                    if (ast instanceof Call && (callRep = NodeUtils.getRepresentationString((SimpleNode)(call = (Call)ast))) != null && callRep.equals("__bootstrap__")) {
                        final String modName = FullRepIterable.getLastPart((String)this.getName());
                        File folder = this.file.getParentFile();
                        File[] validBootsrappedDlls = folder.listFiles(new FilenameFilter(){

                            public boolean accept(File dir, String name) {
                                String extension;
                                String namePart;
                                int i = name.lastIndexOf(46);
                                return i > 0 && (namePart = name.substring(0, i)).equals(modName) && (extension = name.substring(i + 1)).length() > 0 && FileTypesPreferencesPage.isValidDllExtension(extension);
                            }
                        });
                        if (validBootsrappedDlls.length > 0) {
                            this.bootstrap = Boolean.TRUE;
                        }
                    }
                }
            }
            if (this.bootstrap == null) {
                this.bootstrap = Boolean.FALSE;
            }
        }
        return this.bootstrap;
    }

    public /* synthetic */ Object getAst() {
        return this.getAst();
    }

    @Override
    public /* synthetic */ IDefinition[] findDefinition(ICompletionState iCompletionState, int n, int n2, IPythonNature iPythonNature) throws Exception {
        return this.findDefinition(iCompletionState, n, n2, iPythonNature);
    }
}

