/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editorinput;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.plugin.PydevPlugin;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PySourceLocatorPrefs {
    public static final String DONTASK = "DONTASK";

    public static String isValid(String[] translation) {
        if (translation.length != 2) {
            return "Input must have 2 elements.";
        }
        if (translation[1].equals(DONTASK)) {
            return null;
        }
        if (!new File(translation[1]).exists()) {
            return StringUtils.format((String)"The file: %s does not exist and doesn't match 'DONTASK'.", (Object[])new Object[]{translation[1]});
        }
        return null;
    }

    public static void addPathTranslation(IPath path, IPath location) {
        PySourceLocatorPrefs.addPathTranslation(new String[]{path.toOSString(), location.toOSString()});
    }

    public static void setIgnorePathTranslation(IPath path) {
        PySourceLocatorPrefs.addPathTranslation(new String[]{path.toOSString(), DONTASK});
    }

    private static void addPathTranslation(String[] translation) {
        String valid = PySourceLocatorPrefs.isValid(translation);
        if (valid != null) {
            throw new RuntimeException(valid);
        }
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        String available = store.getString("SOURCE_LOCATION_PATHS");
        if (available == null || available.trim().length() == 0) {
            available = StringUtils.join((String)",", (String[])translation);
        } else {
            String pathAsked = translation[0].trim();
            String existent = PySourceLocatorPrefs.getPathTranslation(pathAsked);
            if (existent != null) {
                String[] splitted = StringUtils.split((String)available, (char)'\n');
                int i = 0;
                while (i < splitted.length) {
                    String s = splitted[i];
                    String initialPart = StringUtils.split((String)s, (char)',')[0].trim();
                    if (initialPart.equals(pathAsked)) {
                        splitted[i] = StringUtils.join((String)",", (String[])translation);
                        break;
                    }
                    ++i;
                }
                available = StringUtils.join((String)"\n", (String[])splitted);
            } else {
                available = new StringBuffer(String.valueOf(available)).append("\n").toString();
                available = new StringBuffer(String.valueOf(available)).append(StringUtils.join((String)",", (String[])translation)).toString();
            }
        }
        store.putValue("SOURCE_LOCATION_PATHS", available);
    }

    public static String getPathTranslation(IPath pathToTranslate) {
        return PySourceLocatorPrefs.getPathTranslation(pathToTranslate.toOSString());
    }

    public static String getPathTranslation(String pathToTranslate) {
        String[] splitted;
        pathToTranslate = pathToTranslate.trim();
        IPreferenceStore store = PydevPlugin.getDefault().getPreferenceStore();
        String available = store.getString("SOURCE_LOCATION_PATHS");
        if (available == null || available.trim().length() == 0) {
            return null;
        }
        String[] stringArray = splitted = StringUtils.split((String)available, (char)'\n');
        int n = splitted.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            String[] translation = StringUtils.split((String)string, (char)',');
            if (translation.length == 2 && translation[0].trim().equals(pathToTranslate)) {
                return translation[1].trim();
            }
            ++n2;
        }
        return null;
    }

    public static String wordsAsString(List<String[]> words) {
        StringBuffer buf = new StringBuffer();
        for (String[] string : words) {
            buf.append(string[0].trim());
            buf.append(',');
            buf.append(string[1].trim());
            buf.append('\n');
        }
        return buf.toString();
    }

    public static List<String[]> stringAsWords(String string) {
        ArrayList<String[]> strs = new ArrayList<String[]>();
        String[] stringArray = StringUtils.split((String)string, (char)'\n');
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String str = stringArray[n2];
            strs.add(StringUtils.split((String)str, (char)','));
            ++n2;
        }
        return strs;
    }
}

