/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.actions.refactoring;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.UIJob;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.REF;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.refactoring.AbstractPyRefactoring;
import org.python.pydev.editor.refactoring.IPyRefactoring;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.views.PyRefactorView;

public abstract class PyRefactorAction
extends PyAction {
    protected IWorkbenchWindow workbenchWindow;
    protected volatile RefactoringRequest request;
    protected PySelection ps;

    protected abstract IPyRefactoring getPyRefactoring();

    protected abstract String perform(IAction var1, String var2, IProgressMonitor var3) throws Exception;

    protected abstract String getInputMessage();

    protected String getInput(String msg) {
        InputDialog d = new InputDialog(this.getPyEditShell(), "Refactoring", msg, this.getDefaultValue(), null);
        int retCode = d.open();
        if (retCode == 0) {
            return d.getValue();
        }
        return "";
    }

    protected String getDefaultValue() {
        return "";
    }

    protected IPyRefactoring getPyRefactoring(String conditionalMethod) {
        IPyRefactoring pyRefactoring = AbstractPyRefactoring.getPyRefactoring();
        try {
            if (((Boolean)REF.invoke((Object)pyRefactoring, (String)conditionalMethod, (Object[])new Object[0])).booleanValue()) {
                return pyRefactoring;
            }
        }
        catch (Exception e) {
            PydevPlugin.log(e);
        }
        return AbstractPyRefactoring.getDefaultPyRefactoring();
    }

    public RefactoringRequest getRefactoringRequest() {
        return this.getRefactoringRequest(null, null);
    }

    public RefactoringRequest getRefactoringRequest(IProgressMonitor monitor) {
        return this.getRefactoringRequest(null, monitor);
    }

    public RefactoringRequest getRefactoringRequest(String name, IProgressMonitor monitor) {
        if (this.request == null) {
            PyEdit pyEdit = this.getPyEdit();
            this.request = PyRefactorAction.createRefactoringRequest(monitor, pyEdit, this.ps);
        }
        this.request.pushMonitor(monitor);
        this.request.inputName = name;
        return this.request;
    }

    public static RefactoringRequest createRefactoringRequest(IProgressMonitor monitor, PyEdit pyEdit, PySelection ps) {
        File file = pyEdit.getEditorFile();
        IPythonNature nature = pyEdit.getPythonNature();
        return new RefactoringRequest(file, ps, monitor, nature, pyEdit);
    }

    private void refreshEditor(PyEdit edit) throws CoreException {
        IFile file = (IFile)((FileEditorInput)edit.getEditorInput()).getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile"));
        file.refreshLocal(2, null);
    }

    protected void refreshEditors(PyEdit edit) throws CoreException {
        this.refreshEditor(edit);
        IWorkbenchPage[] pages = this.workbenchWindow.getPages();
        int i = 0;
        while (i < pages.length) {
            Object e;
            IEditorReference[] editorReferences = pages[i].getEditorReferences();
            IViewReference[] viewReferences = pages[i].getViewReferences();
            int j = 0;
            while (j < editorReferences.length) {
                IEditorPart ed = editorReferences[j].getEditor(false);
                if (ed instanceof PyEdit && (e = (PyEdit)ed) != edit) {
                    try {
                        this.refreshEditor((PyEdit)((Object)e));
                    }
                    catch (Exception exception) {}
                }
                ++j;
            }
            j = 0;
            while (j < viewReferences.length) {
                IWorkbenchPart view = viewReferences[j].getPart(false);
                if (view instanceof PyRefactorView) {
                    view = viewReferences[j].getPart(true);
                    e = (PyRefactorView)view;
                    ((PyRefactorView)((Object)e)).refresh();
                }
                ++j;
            }
            ++i;
        }
    }

    protected boolean areRefactorPreconditionsOK(RefactoringRequest request, IPyRefactoring pyRefactoring) {
        boolean editorsSaved;
        try {
            PyRefactorAction.checkAvailableForRefactoring(request, pyRefactoring);
        }
        catch (Exception e) {
            ErrorDialog.openError(null, (String)"Error", (String)"Unable to do requested action", (IStatus)new Status(4, PydevPlugin.getPluginID(), 0, e.getMessage(), null));
            return false;
        }
        this.workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEditorPart[] dirtyEditors = this.workbenchWindow.getActivePage().getDirtyEditors();
        boolean saveEditors = false;
        if (dirtyEditors.length > 0 && !(saveEditors = MessageDialog.openQuestion((Shell)this.getPyEditShell(), (String)"Save All?", (String)"All the editors must be saved to make this operation.\nIs it ok to save them?"))) {
            return false;
        }
        return !saveEditors || (editorsSaved = this.workbenchWindow.getActivePage().saveAllEditors(false));
    }

    public void run(final IAction action) {
        IPyRefactoring pyRefactoring;
        this.request = null;
        this.ps = new PySelection(this.getTextEditor());
        RefactoringRequest req = this.getRefactoringRequest();
        if (!this.areRefactorPreconditionsOK(req, pyRefactoring = this.getPyRefactoring())) {
            return;
        }
        if (!pyRefactoring.useDefaultRefactoringActionCycle()) {
            UIJob job = new UIJob("Performing: " + ((Object)((Object)this)).getClass().getName()){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        Operation o = new Operation(null, action);
                        o.execute(monitor);
                    }
                    catch (Exception e) {
                        PydevPlugin.log(e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
            return;
        }
        String msg = this.getInputMessage();
        String name = "";
        if (msg != null) {
            name = this.getInput(msg);
        }
        Operation operation = new Operation(name, action);
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(this.getPyEditShell());
        monitorDialog.setBlockOnOpen(false);
        try {
            monitorDialog.run(true, false, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        try {
            this.refreshEditors(this.getPyEdit());
        }
        catch (CoreException e1) {
            e1.printStackTrace();
        }
        if (operation.statusOfOperation != null && operation.statusOfOperation.startsWith("ERROR:")) {
            this.restartRefactorShell(req);
            String[] strings = operation.statusOfOperation.split("DETAILS:");
            if (strings.length == 2) {
                Status status = new Status(4, PydevPlugin.getPluginID(), 0, strings[0], (Throwable)new Exception(strings[0]));
                ErrorDialog.openError((Shell)this.getPyEditShell(), (String)"ERROR", (String)strings[0], (IStatus)status);
            } else {
                MessageDialog.openError((Shell)this.getPyEditShell(), (String)"ERROR", (String)operation.statusOfOperation);
            }
            throw new RuntimeException(strings[1]);
        }
        this.getTextEditor().selectAndReveal(this.ps.getEndLine().getOffset(), 0);
    }

    private void restartRefactorShell(final RefactoringRequest req) {
        Thread thread = new Thread(){

            public void run() {
                AbstractPyRefactoring.restartShells(req);
            }
        };
        thread.setName("Restart Refactor Shell");
        thread.start();
    }

    protected Shell getPyEditShell() {
        return this.getPyEdit().getSite().getShell();
    }

    public static void checkAvailableForRefactoring(RefactoringRequest request, IPyRefactoring pyRefactoring) {
        IPythonNature pythonNature = request.nature;
        if (pythonNature == null) {
            throw new RuntimeException("Unable to do refactor because the file is an a project that does not have the pydev nature configured.");
        }
        pyRefactoring.canRefactorNature(pythonNature);
    }

    private final class Operation
    extends WorkspaceModifyOperation {
        public String statusOfOperation;
        private final String nameUsed;
        private final IAction action;

        public Operation(String nameUsed, IAction action) {
            this.nameUsed = nameUsed;
            this.action = action;
        }

        protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
            try {
                monitor.beginTask("Refactor", -1);
                this.statusOfOperation = PyRefactorAction.this.perform(this.action, this.nameUsed, monitor);
                monitor.done();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

