/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion.revisited;

import java.io.File;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IProjectModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.editor.codecompletion.IASTManagerObserver;
import org.python.pydev.editor.codecompletion.revisited.AbstractASTManager;
import org.python.pydev.editor.codecompletion.revisited.IOUtils;
import org.python.pydev.editor.codecompletion.revisited.ProjectModulesManager;
import org.python.pydev.plugin.PydevPlugin;

public class ASTManager
extends AbstractASTManager
implements ICodeCompletionASTManager,
Serializable {
    protected static final long serialVersionUID = 11L;

    public void setProject(IProject project, IPythonNature nature, boolean restoreDeltas) {
        this.getProjectModulesManager().setProject(project, nature, restoreDeltas);
        List participants = ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_manager_observer");
        Iterator iterator = participants.iterator();
        while (iterator.hasNext()) {
            IASTManagerObserver observer = (IASTManagerObserver)iterator.next();
            try {
                observer.notifyASTManagerAttached(this);
            }
            catch (Exception e) {
                PydevPlugin.log(e);
            }
        }
    }

    public IModulesManager getModulesManager() {
        return this.getProjectModulesManager();
    }

    private synchronized IProjectModulesManager getProjectModulesManager() {
        if (this.modulesManager == null) {
            this.modulesManager = new ProjectModulesManager();
        }
        return (IProjectModulesManager)this.modulesManager;
    }

    public void changePythonPath(String pythonpath, IProject project, IProgressMonitor monitor) {
        this.getProjectModulesManager().changePythonPath(pythonpath, project, monitor);
    }

    public void rebuildModule(File f, IDocument doc, IProject project, IProgressMonitor monitor, IPythonNature nature) {
        this.getProjectModulesManager().rebuildModule(f, doc, project, monitor, nature);
    }

    public void removeModule(File file, IProject project, IProgressMonitor monitor) {
        this.getProjectModulesManager().removeModule(file, project, monitor);
    }

    public int getSize() {
        return this.getProjectModulesManager().getSize(true);
    }

    public static ICodeCompletionASTManager loadFromFile(File astOutputFile) {
        return (ICodeCompletionASTManager)IOUtils.readFromFile(astOutputFile);
    }
}

