/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.navigator;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IProjectModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.ModulesKey;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.navigator.elements.IWrappedResource;
import org.python.pydev.navigator.elements.PythonFile;
import org.python.pydev.navigator.elements.PythonFolder;
import org.python.pydev.navigator.elements.PythonNode;
import org.python.pydev.navigator.elements.PythonProjectSourceFolder;
import org.python.pydev.navigator.elements.PythonResource;
import org.python.pydev.navigator.elements.PythonSourceFolder;
import org.python.pydev.outline.ParsedItem;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.visitors.scope.ASTEntryWithChildren;
import org.python.pydev.parser.visitors.scope.OutlineCreatorVisitor;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.IPythonNatureListener;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.plugin.nature.PythonNatureListenersManager;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PythonBaseModelProvider
extends BaseWorkbenchContentProvider
implements IResourceChangeListener,
IPythonNatureListener {
    private static final Object[] EMPTY = new Object[0];
    private Map<IProject, Set<PythonSourceFolder>> projectToSourceFolders = new HashMap<IProject, Set<PythonSourceFolder>>();
    protected Viewer viewer;
    public static final boolean DEBUG = false;

    public PythonBaseModelProvider() {
        PythonNatureListenersManager.addPythonNatureListener(this);
    }

    @Override
    public void notifyPythonPathRebuilt(IProject project, List<String> projectPythonpath) {
        if (project == null) {
            return;
        }
        this.internalDoNotifyPythonPathRebuilt(project, projectPythonpath);
    }

    public IResource internalDoNotifyPythonPathRebuilt(IProject project, List<String> projectPythonpath) {
        Set<PythonSourceFolder> existingSourceFolders;
        IProject refreshObject = project;
        HashSet<Path> projectPythonpathSet = new HashSet<Path>();
        for (String string : projectPythonpath) {
            Path newPath = new Path(string);
            if (project.getLocation().equals((Object)newPath)) {
                refreshObject = project.getParent();
            }
            projectPythonpathSet.add(newPath);
        }
        Map<IProject, Set<PythonSourceFolder>> p = this.projectToSourceFolders;
        if (p != null && (existingSourceFolders = p.get(project)) != null) {
            for (PythonSourceFolder pythonSourceFolder : new HashSet<PythonSourceFolder>(existingSourceFolders)) {
                IPath fullPath = pythonSourceFolder.container.getLocation();
                if (projectPythonpathSet.contains(fullPath)) continue;
                if (pythonSourceFolder instanceof PythonProjectSourceFolder) {
                    refreshObject = project.getParent();
                }
                existingSourceFolders.remove(pythonSourceFolder);
            }
        }
        Runnable refreshRunnable = this.getRefreshRunnable((IResource)refreshObject);
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        runnables.add(refreshRunnable);
        this.processRunnables(runnables);
        return refreshObject;
    }

    protected Object getResourceInPythonModel(IResource object) {
        return this.getResourceInPythonModel(object, false, false);
    }

    protected Object getResourceInPythonModel(IResource object, boolean returnNullIfNotFound) {
        return this.getResourceInPythonModel(object, false, returnNullIfNotFound);
    }

    protected Object getResourceInPythonModel(IResource object, boolean removeFoundResource, boolean returnNullIfNotFound) {
        Set<PythonSourceFolder> sourceFolders = this.getProjectSourceFolders(object.getProject());
        Object f = null;
        PythonSourceFolder sourceFolder = null;
        Iterator<PythonSourceFolder> it = sourceFolders.iterator();
        while (f == null && it.hasNext()) {
            sourceFolder = it.next();
            f = sourceFolder.getActualObject().equals((Object)object) ? sourceFolder : sourceFolder.getChild(object);
        }
        if (f == null) {
            if (returnNullIfNotFound) {
                return null;
            }
            return object;
        }
        if (removeFoundResource) {
            if (f == sourceFolder) {
                sourceFolders.remove(f);
            } else {
                sourceFolder.removeChild(object);
            }
        }
        return f;
    }

    protected Set<PythonSourceFolder> getProjectSourceFolders(IProject project) {
        Map<IProject, Set<PythonSourceFolder>> p = this.projectToSourceFolders;
        if (p != null) {
            Set<PythonSourceFolder> sourceFolder = p.get(project);
            if (sourceFolder == null) {
                sourceFolder = new HashSet<PythonSourceFolder>();
                p.put(project, sourceFolder);
            }
            return sourceFolder;
        }
        return new HashSet<PythonSourceFolder>();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasChildren(Object element) {
        if (!(element instanceof PythonFile)) {
            if (this.getChildren(element).length <= 0) return false;
            return true;
        }
        PythonFile f = (PythonFile)element;
        if (!PythonPathHelper.isValidSourceFile((IFile)f.getActualObject())) return false;
        try {
            InputStream contents = f.getContents();
            try {
                if (contents.read() != -1) return true;
                return false;
            }
            finally {
                contents.close();
            }
        }
        catch (Exception e) {
            PydevPlugin.log(e);
            return false;
        }
    }

    public Object[] getChildren(Object parentElement) {
        Object[] childrenToReturn = null;
        if (parentElement instanceof IWrappedResource) {
            childrenToReturn = this.getChildrenForIWrappedResource((IWrappedResource)parentElement);
        } else if (parentElement instanceof IResource || parentElement instanceof IWorkingSet) {
            childrenToReturn = this.getChildrenForIResourceOrWorkingSet(parentElement);
        }
        if (childrenToReturn == null) {
            return EMPTY;
        }
        return childrenToReturn;
    }

    private Object[] getChildrenForIResourceOrWorkingSet(Object parentElement) {
        PythonNature nature = null;
        IProject project = null;
        if (parentElement instanceof IResource) {
            project = ((IResource)parentElement).getProject();
        }
        if (project != null && project.isOpen()) {
            nature = PythonNature.getPythonNature(project);
        }
        Object[] childrenToReturn = super.getChildren(parentElement);
        ArrayList<Object> ret = new ArrayList<Object>(childrenToReturn.length);
        int i = 0;
        while (i < childrenToReturn.length) {
            block15: {
                PythonNature localNature = nature;
                IProject localProject = project;
                Object child = childrenToReturn[i];
                if (child != null) {
                    ret.add(child);
                    if (child instanceof IResource && (child = this.getResourceInPythonModel((IResource)child)) != null) {
                        ret.set(ret.size() - 1, child);
                        if (child instanceof IContainer && !(child instanceof PythonSourceFolder)) {
                            IContainer container = (IContainer)child;
                            try {
                                IPath fullPath;
                                Set sourcePathSet;
                                if (localNature == null) {
                                    if (!(container instanceof IProject) || !(localProject = (IProject)container).isOpen()) break block15;
                                    localNature = PythonNature.getPythonNature(localProject);
                                }
                                if (localNature != null && (sourcePathSet = localNature.getPythonPathNature().getProjectSourcePathSet()).contains((fullPath = container.getFullPath()).toString())) {
                                    PythonSourceFolder createdSourceFolder;
                                    if (container instanceof IFolder) {
                                        createdSourceFolder = new PythonSourceFolder(parentElement, (IFolder)container);
                                    } else if (container instanceof IProject) {
                                        createdSourceFolder = new PythonProjectSourceFolder(parentElement, (IProject)container);
                                    } else {
                                        throw new RuntimeException("Should not get here.");
                                    }
                                    ret.set(ret.size() - 1, createdSourceFolder);
                                    Set<PythonSourceFolder> sourceFolders = this.getProjectSourceFolders(localProject);
                                    sourceFolders.add(createdSourceFolder);
                                }
                            }
                            catch (CoreException e) {
                                throw new RuntimeException(e);
                            }
                        }
                    }
                }
            }
            ++i;
        }
        return ret.toArray();
    }

    private Object[] getChildrenForIWrappedResource(IWrappedResource wrappedResourceParent) {
        IResource resource;
        PythonNature nature = null;
        Object[] childrenToReturn = null;
        Object obj = wrappedResourceParent.getActualObject();
        IProject project = null;
        if (obj instanceof IResource && (project = (resource = (IResource)obj).getProject()) != null && project.isOpen()) {
            nature = PythonNature.getPythonNature(project);
        }
        if (wrappedResourceParent instanceof PythonNode) {
            PythonNode node = (PythonNode)wrappedResourceParent;
            childrenToReturn = this.getChildrenFromParsedItem(wrappedResourceParent, node.entry, node.pythonFile);
        } else if (wrappedResourceParent instanceof PythonFile) {
            IProjectModulesManager projectModulesManager;
            String moduleName;
            IModulesManager modulesManager;
            ICodeCompletionASTManager astManager;
            PythonFile file = (PythonFile)wrappedResourceParent;
            if (PythonPathHelper.isValidSourceFile((IFile)file.getActualObject()) && nature != null && (astManager = nature.getAstManager()) != null && (modulesManager = astManager.getModulesManager()) instanceof IProjectModulesManager && (moduleName = (projectModulesManager = (IProjectModulesManager)modulesManager).resolveModuleInDirectManager((IFile)file.getActualObject())) != null) {
                File f;
                IModule module = projectModulesManager.getModuleInDirectManager(moduleName, (IPythonNature)nature, true);
                if (module == null && (f = new File(PydevPlugin.getIResourceOSString(file.getActualObject()))).exists()) {
                    projectModulesManager.addModule(new ModulesKey(moduleName, f));
                    module = projectModulesManager.getModuleInDirectManager(moduleName, (IPythonNature)nature, true);
                }
                if (module instanceof SourceModule) {
                    SourceModule sourceModule = (SourceModule)module;
                    OutlineCreatorVisitor visitor = OutlineCreatorVisitor.create((SimpleNode)sourceModule.getAst());
                    ParsedItem root = new ParsedItem(visitor.getAll().toArray(new ASTEntryWithChildren[0]), null);
                    childrenToReturn = this.getChildrenFromParsedItem(wrappedResourceParent, root, file);
                }
            }
        } else {
            Object[] children = super.getChildren(wrappedResourceParent.getActualObject());
            childrenToReturn = this.wrapChildren(wrappedResourceParent, wrappedResourceParent.getSourceFolder(), children);
        }
        return childrenToReturn;
    }

    protected Object[] wrapChildren(IWrappedResource parent, PythonSourceFolder pythonSourceFolder, Object[] children) {
        ArrayList<Object> ret = new ArrayList<Object>(children.length);
        int i = 0;
        while (i < children.length) {
            Object object = children[i];
            if (object instanceof IResource) {
                Object existing = this.getResourceInPythonModel((IResource)object, true);
                if (existing == null) {
                    if (object instanceof IFolder) {
                        object = new PythonFolder(parent, (IFolder)object, pythonSourceFolder);
                    } else if (object instanceof IFile) {
                        object = new PythonFile(parent, (IFile)object, pythonSourceFolder);
                    } else if (object instanceof IResource) {
                        object = new PythonResource(parent, (IResource)object, pythonSourceFolder);
                    }
                } else {
                    object = existing;
                }
            }
            if (object != null) {
                ret.add(object);
            }
            ++i;
        }
        return ret.toArray();
    }

    public Object getParent(Object element) {
        if (element instanceof IWrappedResource) {
            IWrappedResource resource = (IWrappedResource)element;
            return resource.getParentElement();
        }
        return super.getParent(element);
    }

    private Object[] getChildrenFromParsedItem(Object parentElement, ParsedItem root, PythonFile pythonFile) {
        ParsedItem[] children = root.getChildren();
        Object[] p = new PythonNode[children.length];
        int i = 0;
        ParsedItem[] parsedItemArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            ParsedItem e = parsedItemArray[n2];
            p[i] = new PythonNode(pythonFile, parentElement, e);
            ++i;
            ++n2;
        }
        return p;
    }

    public void dispose() {
        try {
            this.projectToSourceFolders = null;
            if (this.viewer != null) {
                IWorkspace[] workspace = null;
                Object obj = this.viewer.getInput();
                if (obj instanceof IWorkspace) {
                    workspace = new IWorkspace[]{(IWorkspace)obj};
                } else if (obj instanceof IContainer) {
                    workspace = new IWorkspace[]{((IContainer)obj).getWorkspace()};
                } else if (obj instanceof IWorkingSet) {
                    IWorkingSet newWorkingSet = (IWorkingSet)obj;
                    workspace = this.getWorkspaces(newWorkingSet);
                }
                if (workspace != null) {
                    IWorkspace[] iWorkspaceArray = workspace;
                    int n = workspace.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IWorkspace w = iWorkspaceArray[n2];
                        w.removeResourceChangeListener((IResourceChangeListener)this);
                        ++n2;
                    }
                }
            }
            PythonNatureListenersManager.removePythonNatureListener(this);
        }
        catch (Exception e) {
            PydevPlugin.log(e);
        }
        try {
            super.dispose();
        }
        catch (Exception e) {
            PydevPlugin.log(e);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        IWorkspace workspace;
        int n;
        int n2;
        IWorkspace[] iWorkspaceArray;
        super.inputChanged(viewer, oldInput, newInput);
        this.viewer = viewer;
        IWorkspace[] oldWorkspace = null;
        IWorkspace[] newWorkspace = null;
        if (oldInput instanceof IWorkspace) {
            oldWorkspace = new IWorkspace[]{(IWorkspace)oldInput};
        } else if (oldInput instanceof IContainer) {
            oldWorkspace = new IWorkspace[]{((IContainer)oldInput).getWorkspace()};
        } else if (oldInput instanceof IWorkingSet) {
            IWorkingSet oldWorkingSet = (IWorkingSet)oldInput;
            oldWorkspace = this.getWorkspaces(oldWorkingSet);
        }
        if (newInput instanceof IWorkspace) {
            newWorkspace = new IWorkspace[]{(IWorkspace)newInput};
        } else if (newInput instanceof IContainer) {
            newWorkspace = new IWorkspace[]{((IContainer)newInput).getWorkspace()};
        } else if (newInput instanceof IWorkingSet) {
            IWorkingSet newWorkingSet = (IWorkingSet)newInput;
            newWorkspace = this.getWorkspaces(newWorkingSet);
        }
        if (oldWorkspace != null) {
            iWorkspaceArray = oldWorkspace;
            n2 = oldWorkspace.length;
            n = 0;
            while (n < n2) {
                workspace = iWorkspaceArray[n];
                workspace.removeResourceChangeListener((IResourceChangeListener)this);
                ++n;
            }
        }
        if (newWorkspace != null) {
            iWorkspaceArray = newWorkspace;
            n2 = newWorkspace.length;
            n = 0;
            while (n < n2) {
                workspace = iWorkspaceArray[n];
                workspace.addResourceChangeListener((IResourceChangeListener)this, 1);
                ++n;
            }
        }
    }

    private IWorkspace[] getWorkspaces(IWorkingSet newWorkingSet) {
        IAdaptable[] elements = newWorkingSet.getElements();
        HashSet<IWorkspace> set = new HashSet<IWorkspace>();
        IAdaptable[] iAdaptableArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable adaptable = iAdaptableArray[n2];
            IResource adapter = (IResource)adaptable.getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IResource"));
            if (adapter != null) {
                IWorkspace workspace = adapter.getWorkspace();
                set.add(workspace);
            } else {
                PydevPlugin.log("Was not expecting that IWorkingSet adaptable didn't return anything...");
            }
            ++n2;
        }
        return set.toArray(new IWorkspace[0]);
    }

    public final void resourceChanged(IResourceChangeEvent event) {
        this.processDelta(event.getDelta());
    }

    protected void processDelta(IResourceDelta delta) {
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        this.processDelta(delta, runnables);
        this.processRunnables(runnables);
    }

    private void processRunnables(final Collection<Runnable> runnables) {
        if (this.viewer == null) {
            return;
        }
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        if (runnables.isEmpty()) {
            return;
        }
        if (ctrl.getDisplay().getThread() == Thread.currentThread()) {
            this.runUpdates(runnables);
        } else {
            ctrl.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Control ctrl = PythonBaseModelProvider.this.viewer.getControl();
                    if (ctrl == null || ctrl.isDisposed()) {
                        return;
                    }
                    PythonBaseModelProvider.this.runUpdates(runnables);
                }
            });
        }
    }

    private void runUpdates(Collection<Runnable> runnables) {
        for (Runnable runnable : runnables) {
            runnable.run();
        }
    }

    private void processDelta(IResourceDelta delta, Collection<Runnable> runnables) {
        Object[] removedObjects;
        int i;
        Object[] addedObjects;
        Control ctrl = this.viewer.getControl();
        if (ctrl == null || ctrl.isDisposed()) {
            return;
        }
        final IResource resource = delta.getResource();
        IResourceDelta[] affectedChildren = delta.getAffectedChildren(4);
        int i2 = 0;
        while (i2 < affectedChildren.length) {
            if ((affectedChildren[i2].getFlags() & 0x8000) != 0) {
                runnables.add(this.getRefreshRunnable(resource));
                return;
            }
            ++i2;
        }
        int changeFlags = delta.getFlags();
        if ((changeFlags & 0x4000) != 0) {
            if (resource.isAccessible()) {
                runnables.add(this.getUpdateRunnable(resource));
            } else {
                runnables.add(this.getRefreshRunnable(resource));
                return;
            }
        }
        if ((changeFlags & 0x98000) != 0) {
            runnables.add(this.getUpdateRunnable(resource));
        }
        if ((changeFlags & 0x40000) != 0) {
            runnables.add(this.getRefreshRunnable(resource));
            return;
        }
        if ((changeFlags & 0x104) != 0) {
            IFile file;
            if (resource instanceof IFile && PythonPathHelper.isValidSourceFile(file = (IFile)resource)) {
                runnables.add(this.getRefreshRunnable(resource));
            }
            return;
        }
        int i3 = 0;
        while (i3 < affectedChildren.length) {
            this.processDelta(affectedChildren[i3], runnables);
            ++i3;
        }
        IResourceDelta[] addedChildren = delta.getAffectedChildren(1);
        IResourceDelta[] removedChildren = delta.getAffectedChildren(2);
        if (addedChildren.length == 0 && removedChildren.length == 0) {
            return;
        }
        int numMovedFrom = 0;
        int numMovedTo = 0;
        if (addedChildren.length > 0) {
            addedObjects = new Object[addedChildren.length];
            i = 0;
            while (i < addedChildren.length) {
                addedObjects[i] = addedChildren[i].getResource();
                if ((addedChildren[i].getFlags() & 0x1000) != 0) {
                    ++numMovedFrom;
                }
                ++i;
            }
        } else {
            addedObjects = new Object[]{};
        }
        if (removedChildren.length > 0) {
            removedObjects = new Object[removedChildren.length];
            i = 0;
            while (i < removedChildren.length) {
                removedObjects[i] = removedChildren[i].getResource();
                if ((removedChildren[i].getFlags() & 0x2000) != 0) {
                    ++numMovedTo;
                }
                ++i;
            }
        } else {
            removedObjects = new Object[]{};
        }
        final boolean hasRename = numMovedFrom > 0 && numMovedTo > 0;
        Runnable addAndRemove = new Runnable(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public void run() {
                if (PythonBaseModelProvider.this.viewer instanceof AbstractTreeViewer) {
                    AbstractTreeViewer treeViewer = (AbstractTreeViewer)PythonBaseModelProvider.this.viewer;
                    if (hasRename) {
                        treeViewer.getControl().setRedraw(false);
                    }
                    try {
                        if (addedObjects.length > 0) {
                            treeViewer.add((Object)resource, addedObjects);
                        }
                        if (removedObjects.length <= 0) return;
                        treeViewer.remove(removedObjects);
                        Object[] objectArray = removedObjects;
                        int n = removedObjects.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Map p;
                            IResource rem;
                            Object remInPythonModel;
                            Object object = objectArray[n2];
                            if (object instanceof IResource && (remInPythonModel = PythonBaseModelProvider.this.getResourceInPythonModel(rem = (IResource)object, true)) instanceof PythonSourceFolder && (p = PythonBaseModelProvider.this.projectToSourceFolders) != null) {
                                ((Set)p.get(resource.getProject())).remove(remInPythonModel);
                            }
                            ++n2;
                        }
                        return;
                    }
                    finally {
                        if (hasRename) {
                            treeViewer.getControl().setRedraw(true);
                        }
                    }
                } else {
                    ((StructuredViewer)PythonBaseModelProvider.this.viewer).refresh((Object)resource);
                }
            }
        };
        runnables.add(addAndRemove);
    }

    private Runnable getRefreshRunnable(final IResource resource) {
        return new Runnable(){

            public void run() {
                ((StructuredViewer)PythonBaseModelProvider.this.viewer).refresh(PythonBaseModelProvider.this.getResourceInPythonModel(resource));
            }
        };
    }

    private Runnable getUpdateRunnable(final IResource resource) {
        return new Runnable(){

            public void run() {
                ((StructuredViewer)PythonBaseModelProvider.this.viewer).update(PythonBaseModelProvider.this.getResourceInPythonModel(resource), null);
            }
        };
    }
}

