/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.interpreters;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.runners.SimplePythonRunner;
import org.python.pydev.ui.interpreters.AbstractInterpreterManager;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PythonInterpreterManager
extends AbstractInterpreterManager {
    public PythonInterpreterManager(Preferences prefs) {
        super(prefs);
    }

    @Override
    protected String getPreferenceName() {
        return "INTERPRETER_PATH_NEW";
    }

    @Override
    protected String getNotConfiguredInterpreterMsg() {
        return "Interpreter is not properly configured!\nPlease go to window->preferences->PyDev->Python Interpreters and configure it.\nIf this is not supposed to be a Python project, change the project type on the\nproject properties to the project you want (e.g.: Jython project).";
    }

    @Override
    public Tuple<InterpreterInfo, String> createInterpreterInfo(String executable, IProgressMonitor monitor) throws CoreException {
        return PythonInterpreterManager.doCreateInterpreterInfo(executable, monitor);
    }

    public static Tuple<InterpreterInfo, String> doCreateInterpreterInfo(String executable, IProgressMonitor monitor) throws CoreException {
        boolean isJythonExecutable = InterpreterInfo.isJythonExecutable(executable);
        if (isJythonExecutable) {
            throw new RuntimeException("A jar cannot be used in order to get the info for the python interpreter.");
        }
        File script = PydevPlugin.getScriptWithinPySrc("interpreterInfo.py");
        Tuple<String, String> outTup = new SimplePythonRunner().runAndGetOutputWithInterpreter(executable, REF.getFileAbsolutePath((File)script), null, null, null, monitor);
        InterpreterInfo info = PythonInterpreterManager.createInfoFromOutput(monitor, outTup);
        if (info == null) {
            return null;
        }
        info.restoreCompiledLibs(monitor);
        return new Tuple((Object)info, (Object)((String)outTup.o1));
    }

    @Override
    public boolean canGetInfoOnNature(IPythonNature nature) {
        try {
            return nature.isPython();
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean isJython() {
        return false;
    }

    public boolean isPython() {
        return true;
    }

    public String getManagerRelatedName() {
        return "python";
    }
}

