/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.wizards.project;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.WizardNewProjectReferencePage;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.ui.wizards.project.CopiedWizardNewProjectNameAndLocationPage;
import org.python.pydev.ui.wizards.project.IWizardNewProjectNameAndLocationPage;

public class PythonProjectWizard
extends Wizard
implements INewWizard {
    private IWorkbench workbench;
    protected IStructuredSelection selection;
    public static final String WIZARD_ID = "org.python.pydev.ui.wizards.project.PythonProjectWizard";
    IWizardNewProjectNameAndLocationPage projectPage;
    WizardNewProjectReferencePage referencePage;
    Shell shell;
    IProject generatedProject;
    Exception creationThreadException;

    public void init(IWorkbench workbench, IStructuredSelection currentSelection) {
        this.workbench = workbench;
        this.selection = currentSelection;
        this.initializeDefaultPageImageDescriptor();
        this.projectPage = this.createProjectPage();
    }

    protected IWizardNewProjectNameAndLocationPage createProjectPage() {
        return new CopiedWizardNewProjectNameAndLocationPage("Setting project properties");
    }

    public void addPages() {
        this.addPage(this.projectPage);
        this.addProjectReferencePage();
    }

    protected void addProjectReferencePage() {
        if (ResourcesPlugin.getWorkspace().getRoot().getProjects().length > 0) {
            this.referencePage = new WizardNewProjectReferencePage("Reference Page");
            this.referencePage.setTitle("Reference page");
            this.referencePage.setDescription("Select referenced projects");
            this.addPage((IWizardPage)this.referencePage);
        }
    }

    private void createProject(IProjectDescription description, IProject projectHandle, IProgressMonitor monitor, String projectType, String projectInterpreter) throws CoreException, OperationCanceledException {
        try {
            monitor.beginTask("", 2000);
            projectHandle.create(description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            projectHandle.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            String projectPythonpath = null;
            if (this.projectPage.shouldCreatSourceFolder()) {
                IFolder folder = projectHandle.getFolder("src");
                folder.create(true, true, monitor);
                projectPythonpath = folder.getFullPath().toString();
            }
            PythonNature.addNature(projectHandle, null, projectType, projectPythonpath, projectInterpreter);
        }
        finally {
            monitor.done();
        }
    }

    protected IProject createNewProject() {
        IProject[] refProjects;
        IPath newPath;
        final IProject newProjectHandle = this.projectPage.getProjectHandle();
        IPath defaultPath = Platform.getLocation();
        if (defaultPath.equals((Object)(newPath = this.projectPage.getLocationPath()))) {
            newPath = null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProjectDescription description = workspace.newProjectDescription(newProjectHandle.getName());
        description.setLocation(newPath);
        if (this.referencePage != null && (refProjects = this.referencePage.getReferencedProjects()).length > 0) {
            description.setReferencedProjects(refProjects);
        }
        final String projectType = this.projectPage.getProjectType();
        final String projectInterpreter = this.projectPage.getProjectInterpreter();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                PythonProjectWizard.this.createProject(description, newProjectHandle, monitor, projectType, projectInterpreter);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof CoreException) {
                if (((CoreException)t).getStatus().getCode() == 275) {
                    MessageDialog.openError((Shell)this.getShell(), (String)"IDEWorkbenchMessages.CreateProjectWizard_errorTitle", (String)"IDEWorkbenchMessages.CreateProjectWizard_caseVariantExistsError");
                } else {
                    ErrorDialog.openError((Shell)this.getShell(), (String)"IDEWorkbenchMessages.CreateProjectWizard_errorTitle", null, (IStatus)((CoreException)t).getStatus());
                }
            } else {
                PydevPlugin.log(4, t.toString(), t);
                MessageDialog.openError((Shell)this.getShell(), (String)"IDEWorkbenchMessages.CreateProjectWizard_errorTitle", (String)t.getMessage());
            }
            return null;
        }
        return newProjectHandle;
    }

    public boolean performFinish() {
        this.createNewProject();
        IWorkbenchWindow window = this.workbench.getActiveWorkbenchWindow();
        try {
            this.workbench.showPerspective("org.python.pydev.ui.PythonPerspective", window);
        }
        catch (WorkbenchException we) {
            we.printStackTrace();
        }
        return true;
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = PydevPlugin.imageDescriptorFromPlugin((String)PydevPlugin.getPluginID(), (String)"icons/python_logo.png");
        this.setDefaultPageImageDescriptor(desc);
    }
}

