/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser.grammarcommon;

import java.util.ArrayList;
import java.util.List;
import org.python.pydev.parser.grammarcommon.ITreeConstants;
import org.python.pydev.parser.jython.Token;

public abstract class AbstractTokenManager
implements ITreeConstants {
    protected final int[] indentation = new int[20];
    protected int level = 0;
    protected int parens = 0;
    protected int indent;
    public boolean expect_indent = false;
    public boolean compound = false;
    public final List<Object> specialTokens = new ArrayList<Object>();
    private final int DEDENT = this.getDedentId();
    private final int EOF = this.getEofId();
    private final int DEFAULT = this.getDefaultId();
    private final int NEWLINE = this.getNewlineId();

    protected abstract int getDedentId();

    protected abstract int getEofId();

    protected abstract int getDefaultId();

    protected abstract int getNewlineId();

    protected abstract int getCurLexState();

    protected AbstractTokenManager() {
    }

    protected final Token addDedent(Token previous) {
        Token t = new Token();
        t.kind = this.getDedentId();
        t.beginLine = previous.beginLine;
        t.endLine = previous.endLine;
        t.beginColumn = previous.beginColumn;
        t.endColumn = previous.endColumn;
        t.image = "<DEDENT>";
        t.specialToken = null;
        t.next = null;
        previous.next = t;
        return t;
    }

    protected final void CommonTokenAction(Token t) {
        int i = this.specialTokens.size();
        while (t.specialToken != null) {
            this.specialTokens.add(i, t.specialToken);
            t = t.specialToken;
        }
        if (t.kind == this.EOF) {
            if (this.getCurLexState() == this.DEFAULT) {
                t.kind = this.NEWLINE;
            } else {
                t.kind = this.DEDENT;
                if (this.level >= 0) {
                    --this.level;
                }
            }
            while (this.level >= 0) {
                --this.level;
                t = this.addDedent(t);
            }
            t.kind = this.EOF;
            t.image = "<EOF>";
        }
    }
}

