/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.builder.pylint;

import com.rc.retroweaver.runtime.Autobox;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.python.pydev.builder.PyDevBuilderVisitor;
import org.python.pydev.builder.PydevMarkerUtils;
import org.python.pydev.builder.pylint.PyLintPrefPage;
import org.python.pydev.consoles.MessageConsoles;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.REF;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.runners.SimplePythonRunner;

public class PyLintVisitor
extends PyDevBuilderVisitor {
    public static final String PYLINT_PROBLEM_MARKER = "org.python.pydev.pylintproblemmarker";
    public static final List<PyLintThread> pyLintThreads = new ArrayList<PyLintThread>();
    private static Object lock = new Object();

    public void visitChangedResource(IResource resource, IDocument document, IProgressMonitor monitor) {
        IFile file;
        IPath location;
        if (document == null) {
            return;
        }
        if (!PyLintPrefPage.usePyLint()) {
            try {
                resource.deleteMarkers(PYLINT_PROBLEM_MARKER, false, 0);
            }
            catch (CoreException e3) {
                PydevPlugin.log(e3);
            }
            return;
        }
        IProject project = resource.getProject();
        PythonNature pythonNature = PythonNature.getPythonNature(project);
        try {
            if (pythonNature.getInterpreterType() != 0) {
                return;
            }
            if (!this.isResourceInPythonpathProjectSources(resource, pythonNature, false)) {
                return;
            }
        }
        catch (Exception exception) {
            return;
        }
        if (project != null && resource instanceof IFile && (location = (file = (IFile)resource).getRawLocation()) != null) {
            PyLintThread thread = new PyLintThread(resource, document, location);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(String cmdLineToExe, IOConsoleOutputStream out, Object ... args) {
        block11: {
            try {
                if (out == null) break block11;
                Object object = lock;
                synchronized (object) {
                    if (args != null) {
                        Object[] objectArray = args;
                        int n = args.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object arg = objectArray[n2];
                            if (arg instanceof String) {
                                cmdLineToExe = String.valueOf(cmdLineToExe) + " " + arg;
                            } else if (arg instanceof String[]) {
                                String[] strings;
                                String[] stringArray = strings = (String[])arg;
                                int n3 = strings.length;
                                int n4 = 0;
                                while (n4 < n3) {
                                    String string = stringArray[n4];
                                    cmdLineToExe = String.valueOf(cmdLineToExe) + " " + string;
                                    ++n4;
                                }
                            }
                            ++n2;
                        }
                    }
                    out.write(cmdLineToExe);
                }
            }
            catch (IOException e) {
                PydevPlugin.log(e);
            }
        }
    }

    public void visitRemovedResource(IResource resource, IDocument document, IProgressMonitor monitor) {
    }

    public int maxResourcesToVisit() {
        int i = PyLintPrefPage.getMaxPyLintDelta();
        if (i < 0) {
            i = 0;
        }
        return i;
    }

    public static class PyLintThread
    extends Thread {
        IResource resource;
        IDocument document;
        IPath location;
        List<Object[]> markers = new ArrayList<Object[]>();

        public PyLintThread(IResource resource, IDocument document, IPath location) {
            this.setName("PyLint thread");
            this.resource = resource;
            this.document = document;
            this.location = location;
        }

        private boolean canPassPyLint() {
            if (pyLintThreads.size() < PyLintPrefPage.getMaxPyLintDelta()) {
                pyLintThreads.add(this);
                return true;
            }
            return false;
        }

        public void run() {
            try {
                try {
                    if (this.canPassPyLint()) {
                        IOConsoleOutputStream out = this.getConsoleOutputStream();
                        this.passPyLint(this.resource, out);
                        new Job("Adding markers"){

                            protected IStatus run(IProgressMonitor monitor) {
                                ArrayList<PydevMarkerUtils.MarkerInfo> lst = new ArrayList<PydevMarkerUtils.MarkerInfo>();
                                Iterator<Object[]> iter = PyLintThread.this.markers.iterator();
                                while (iter.hasNext()) {
                                    Object[] el = iter.next();
                                    String tok = (String)el[0];
                                    int priority = (Integer)el[1];
                                    String id = (String)el[2];
                                    int line = (Integer)el[3];
                                    lst.add(new PydevMarkerUtils.MarkerInfo(PyLintThread.this.document, "ID:" + id + " " + tok, PyLintVisitor.PYLINT_PROBLEM_MARKER, priority, false, false, line, 0, line, 0, null));
                                }
                                PydevMarkerUtils.replaceMarkers(lst, PyLintThread.this.resource, PyLintVisitor.PYLINT_PROBLEM_MARKER, monitor);
                                return PydevPlugin.makeStatus(0, "", null);
                            }
                        }.schedule();
                    }
                }
                catch (Exception e) {
                    new Job("Error reporting"){

                        protected IStatus run(IProgressMonitor monitor) {
                            PydevPlugin.log(e);
                            return PydevPlugin.makeStatus(0, "", null);
                        }
                    }.schedule();
                    try {
                        pyLintThreads.remove(this);
                    }
                    catch (Exception e2) {
                        PydevPlugin.log(e2);
                    }
                }
            }
            finally {
                try {
                    pyLintThreads.remove(this);
                }
                catch (Exception e) {
                    PydevPlugin.log(e);
                }
            }
        }

        private IOConsoleOutputStream getConsoleOutputStream() throws MalformedURLException {
            if (PyLintPrefPage.useConsole()) {
                return MessageConsoles.getConsoleOutputStream("PyLint", "icons/pylint.png");
            }
            return null;
        }

        private void addToMarkers(String tok, int priority, String id, int line) {
            this.markers.add(new Object[]{tok, Autobox.valueOf((int)priority), id, Autobox.valueOf((int)line)});
        }

        /*
         * Unable to fully structure code
         */
        private void passPyLint(IResource resource, IOConsoleOutputStream out) throws CoreException, MisconfigurationException, PythonNatureWithoutProjectException {
            script = new File(PyLintPrefPage.getPyLintLocation());
            arg = new File(this.location.toOSString());
            list = new ArrayList<String>();
            list.add("--include-ids=y");
            userArgs = StringUtils.replaceNewLines((String)PyLintPrefPage.getPylintArgs(), (String)" ");
            tokenizer2 = new StringTokenizer(userArgs);
            while (tokenizer2.hasMoreTokens()) {
                list.add(tokenizer2.nextToken());
            }
            list.add(REF.getFileAbsolutePath((File)arg));
            project = resource.getProject();
            scriptToExe = REF.getFileAbsolutePath((File)script);
            paramsToExe = list.toArray(new String[0]);
            PyLintVisitor.write("Pylint: Executing command line:'", out, new Object[]{scriptToExe, paramsToExe, "'"});
            nature = PythonNature.getPythonNature(project);
            if (nature == null) {
                PydevPlugin.log(new RuntimeException("PyLint ERROR: Nature not configured for: " + project));
                return;
            }
            outTup = new SimplePythonRunner().runAndGetOutputFromPythonScript(nature.getProjectInterpreter().getExecutableOrJar(), scriptToExe, paramsToExe, arg.getParentFile(), project);
            PyLintVisitor.write("Pylint: The stdout of the command line is: " + (String)outTup.o1, out, new Object[0]);
            PyLintVisitor.write("Pylint: The stderr of the command line is: " + (String)outTup.o2, out, new Object[0]);
            output = (String)outTup.o1;
            tokenizer = new StringTokenizer(output, "\r\n");
            useW = PyLintPrefPage.useWarnings();
            useE = PyLintPrefPage.useErrors();
            useF = PyLintPrefPage.useFatal();
            useC = PyLintPrefPage.useCodingStandard();
            useR = PyLintPrefPage.useRefactorTips();
            wSeverity = PyLintPrefPage.wSeverity();
            eSeverity = PyLintPrefPage.eSeverity();
            fSeverity = PyLintPrefPage.fSeverity();
            cSeverity = PyLintPrefPage.cSeverity();
            rSeverity = PyLintPrefPage.rSeverity();
            if (output.indexOf("Traceback (most recent call last):") != -1) {
                PydevPlugin.log(new RuntimeException("PyLint ERROR: \n" + output));
                return;
            }
            if (((String)outTup.o2).indexOf("Traceback (most recent call last):") == -1) ** GOTO lbl92
            PydevPlugin.log(new RuntimeException("PyLint ERROR: \n" + (String)outTup.o2));
            return;
lbl-1000:
            // 1 sources

            {
                tok = tokenizer.nextToken();
                try {
                    found = false;
                    priority = 0;
                    indexOfDoublePoints = tok.indexOf(":");
                    if (indexOfDoublePoints == -1) continue;
                    if (tok.startsWith("C") && useC) {
                        found = true;
                        priority = cSeverity;
                    } else if (tok.startsWith("R") && useR) {
                        found = true;
                        priority = rSeverity;
                    } else if (tok.startsWith("W") && useW) {
                        found = true;
                        priority = wSeverity;
                    } else if (tok.startsWith("E") && useE) {
                        found = true;
                        priority = eSeverity;
                    } else {
                        if (!tok.startsWith("F") || !useF) continue;
                        found = true;
                        priority = fSeverity;
                    }
                    try {
                        if (!found) continue;
                        id = tok.substring(0, tok.indexOf(":")).trim();
                        i = tok.indexOf(":");
                        if (i == -1 || (i = (tok = tok.substring(i + 1)).indexOf(":")) == -1) continue;
                        line = Integer.parseInt(tok.substring(0, i).trim());
                        region = null;
                        try {
                            region = this.document.getLineInformation(line - 1);
                        }
                        catch (Exception v0) {
                            region = this.document.getLineInformation(line);
                        }
                        lineContents = this.document.get(region.getOffset(), region.getLength());
                        pos = -1;
                        pos = lineContents.indexOf("IGNORE:");
                        if (pos != -1 && (lintW = lineContents.substring(pos + "IGNORE:".length())).startsWith(id) || (i = tok.indexOf(":")) == -1) continue;
                        tok = tok.substring(i + 1);
                        this.addToMarkers(tok, priority, id, line - 1);
                    }
                    catch (RuntimeException e2) {
                        PydevPlugin.log(e2);
                    }
                    continue;
                }
                catch (Exception e1) {
                    PydevPlugin.log(e1);
                }
lbl92:
                // 9 sources

                ** while (tokenizer.hasMoreTokens())
            }
lbl93:
            // 1 sources

        }
    }
}

