/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.spelling.SpellingService;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.editor.PyCodeScanner;
import org.python.pydev.editor.PyColoredScanner;
import org.python.pydev.editor.PyDoubleClickStrategy;
import org.python.pydev.editor.PyReconciler;
import org.python.pydev.editor.autoedit.DefaultIndentPrefs;
import org.python.pydev.editor.autoedit.PyAutoIndentStrategy;
import org.python.pydev.editor.codecompletion.PyContentAssistant;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.ColorAndStyleCache;

public class PyEditConfigurationWithoutEditor
extends TextSourceViewerConfiguration {
    private ColorAndStyleCache colorCache;
    private PyAutoIndentStrategy autoIndentStrategy;
    private String[] indentPrefixes = new String[]{"    ", "\t", ""};
    private PresentationReconciler reconciler;
    private PyCodeScanner codeScanner;
    private PyColoredScanner commentScanner;
    private PyColoredScanner stringScanner;
    private PyColoredScanner backquotesScanner;
    public PyContentAssistant pyContentAssistant = new PyContentAssistant();
    private final Object lock = new Object();

    public PyEditConfigurationWithoutEditor(ColorAndStyleCache colorManager, IPreferenceStore preferenceStore) {
        super(preferenceStore);
        this.colorCache = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__python_comment", "__python_backquotes", "__python_singleline_string1", "__python_singleline_string2", "__python_multiline_string1", "__python_multiline_string2"};
    }

    public String getConfiguredDocumentPartitioning(ISourceViewer sourceViewer) {
        return "__PYTHON_PARTITION_TYPE";
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        return new IAutoEditStrategy[]{this.getPyAutoIndentStrategy()};
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        if (this.fPreferenceStore == null || !this.fPreferenceStore.getBoolean("spellingEnabled")) {
            return null;
        }
        SpellingService spellingService = EditorsUI.getSpellingService();
        if (spellingService.getActiveSpellingEngineDescriptor(this.fPreferenceStore) == null) {
            return null;
        }
        PyReconciler strategy = new PyReconciler(sourceViewer, spellingService);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        reconciler.setIsIncrementalReconciler(false);
        reconciler.setProgressMonitor((IProgressMonitor)new NullProgressMonitor());
        reconciler.setDelay(500);
        return reconciler;
    }

    public PyAutoIndentStrategy getPyAutoIndentStrategy() {
        if (this.autoIndentStrategy == null) {
            this.autoIndentStrategy = new PyAutoIndentStrategy();
        }
        return this.autoIndentStrategy;
    }

    public void resetIndentPrefixes() {
        boolean spacesFirst;
        IPreferenceStore prefs = PydevPlugin.getDefault().getPreferenceStore();
        int tabWidth = DefaultIndentPrefs.getStaticTabWidth();
        FastStringBuffer spaces = new FastStringBuffer(8);
        int i = 0;
        while (i < tabWidth) {
            spaces.append(" ");
            ++i;
        }
        boolean bl = spacesFirst = prefs.getBoolean("SUBSTITUTE_TABS") && !this.getPyAutoIndentStrategy().getIndentPrefs().getForceTabs();
        if (spacesFirst) {
            this.indentPrefixes[0] = spaces.toString();
            this.indentPrefixes[1] = "\t";
        } else {
            this.indentPrefixes[0] = "\t";
            this.indentPrefixes[1] = spaces.toString();
        }
    }

    public String[] getIndentPrefixes(ISourceViewer sourceViewer, String contentType) {
        this.resetIndentPrefixes();
        sourceViewer.setIndentPrefixes(this.indentPrefixes, contentType);
        return this.indentPrefixes;
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        return new PyDoubleClickStrategy(contentType);
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return DefaultIndentPrefs.getStaticTabWidth();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        Object object = this.lock;
        synchronized (object) {
            if (this.reconciler == null) {
                this.reconciler = new PresentationReconciler();
                this.reconciler.setDocumentPartitioning("__PYTHON_PARTITION_TYPE");
                this.commentScanner = new PyColoredScanner(this.colorCache, "COMMENT_COLOR");
                DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.commentScanner);
                this.reconciler.setDamager((IPresentationDamager)dr, "__python_comment");
                this.reconciler.setRepairer((IPresentationRepairer)dr, "__python_comment");
                this.backquotesScanner = new PyColoredScanner(this.colorCache, "BACKQUOTES_COLOR");
                dr = new DefaultDamagerRepairer((ITokenScanner)this.backquotesScanner);
                this.reconciler.setDamager((IPresentationDamager)dr, "__python_backquotes");
                this.reconciler.setRepairer((IPresentationRepairer)dr, "__python_backquotes");
                this.stringScanner = new PyColoredScanner(this.colorCache, "STRING_COLOR");
                dr = new DefaultDamagerRepairer((ITokenScanner)this.stringScanner);
                this.reconciler.setDamager((IPresentationDamager)dr, "__python_singleline_string1");
                this.reconciler.setRepairer((IPresentationRepairer)dr, "__python_singleline_string1");
                this.reconciler.setDamager((IPresentationDamager)dr, "__python_singleline_string2");
                this.reconciler.setRepairer((IPresentationRepairer)dr, "__python_singleline_string2");
                this.reconciler.setDamager((IPresentationDamager)dr, "__python_multiline_string1");
                this.reconciler.setRepairer((IPresentationRepairer)dr, "__python_multiline_string1");
                this.reconciler.setDamager((IPresentationDamager)dr, "__python_multiline_string2");
                this.reconciler.setRepairer((IPresentationRepairer)dr, "__python_multiline_string2");
                this.codeScanner = new PyCodeScanner(this.colorCache);
                dr = new DefaultDamagerRepairer((ITokenScanner)this.codeScanner);
                this.reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
                this.reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
            }
        }
        return this.reconciler;
    }

    public IInformationControlCreator getInformationControlCreator(ISourceViewer sourceViewer) {
        return PyContentAssistant.createInformationControlCreator(sourceViewer);
    }

    protected IDialogSettings getSettings(String sectionName) {
        IDialogSettings settings = PydevPlugin.getDefault().getDialogSettings().getSection(sectionName);
        if (settings == null) {
            settings = PydevPlugin.getDefault().getDialogSettings().addNewSection(sectionName);
        }
        return settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSyntaxColorAndStyle() {
        Object object = this.lock;
        synchronized (object) {
            if (this.reconciler != null) {
                if (this.codeScanner != null) {
                    this.codeScanner.updateColors();
                }
                if (this.commentScanner != null) {
                    this.commentScanner.updateColorAndStyle();
                }
                if (this.stringScanner != null) {
                    this.stringScanner.updateColorAndStyle();
                }
                if (this.backquotesScanner != null) {
                    this.backquotesScanner.updateColorAndStyle();
                }
            }
        }
    }
}

