/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.codecompletion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.editor.IPySyntaxHighlightingAndCodeCompletionEditor;
import org.python.pydev.editor.codecompletion.AbstractCompletionProcessorWithCycling;
import org.python.pydev.editor.codecompletion.CompletionError;
import org.python.pydev.editor.codecompletion.CompletionRequest;
import org.python.pydev.editor.codecompletion.IPyCodeCompletion;
import org.python.pydev.editor.codecompletion.PyCodeCompletion;
import org.python.pydev.editor.codecompletion.PyCodeCompletionPreferencesPage;
import org.python.pydev.editor.codecompletion.PyCodeCompletionUtils;
import org.python.pydev.editor.codecompletion.PyContentAssistant;
import org.python.pydev.editor.codecompletion.PyContextInformationValidator;
import org.python.pydev.editor.codecompletion.templates.PyTemplateCompletionProcessor;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.SystemPythonNature;
import org.python.pydev.ui.interpreters.ChooseInterpreterManager;

public class PythonCompletionProcessor
extends AbstractCompletionProcessorWithCycling {
    private PyTemplateCompletionProcessor templatesCompletion = new PyTemplateCompletionProcessor();
    private IPyCodeCompletion codeCompletion;
    private IPySyntaxHighlightingAndCodeCompletionEditor edit;
    private String error;
    private static volatile char[] activationChars = null;
    private PyContextInformationValidator contextInformationValidator;
    private static volatile boolean listenerToClearAutoActivationAlreadySetup = false;

    public PythonCompletionProcessor(IPySyntaxHighlightingAndCodeCompletionEditor edit, PyContentAssistant pyContentAssistant) {
        super(pyContentAssistant);
        this.edit = edit;
        this.pyContentAssistant = pyContentAssistant;
        this.codeCompletion = this.getCodeCompletionEngine();
        this.contextInformationValidator = new PyContextInformationValidator();
        pyContentAssistant.addCompletionListener(new ICompletionListener(){

            public void assistSessionEnded(ContentAssistEvent event) {
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                PythonCompletionProcessor.this.startCycle();
            }

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }
        });
    }

    protected IPyCodeCompletion getCodeCompletionEngine() {
        return new PyCodeCompletion();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        ICompletionProposal[] proposals;
        this.updateStatus();
        try {
            IInterpreterManager manager;
            IDocument doc = viewer.getDocument();
            ArrayList pythonAndTemplateProposals = new ArrayList();
            IPythonNature nature = this.edit.getPythonNature();
            if (nature == null && (manager = ChooseInterpreterManager.chooseInterpreterManager()) != null) {
                nature = new SystemPythonNature(manager);
            }
            if (nature == null || !nature.startRequests()) {
                return new ICompletionProposal[0];
            }
            try {
                CompletionRequest request = new CompletionRequest(this.edit.getEditorFile(), nature, doc, documentOffset, this.codeCompletion);
                if (PyCodeCompletionPreferencesPage.useCodeCompletion() && this.whatToShow == 1) {
                    try {
                        pythonAndTemplateProposals.addAll(this.getPythonProposals(viewer, documentOffset, doc, request));
                    }
                    catch (Throwable e) {
                        CompletionError completionError = new CompletionError(e);
                        this.setError(e, completionError.getErrorMessage());
                        ICompletionProposal[] iCompletionProposalArray = new ICompletionProposal[]{completionError};
                        nature.endRequests();
                        return iCompletionProposalArray;
                    }
                }
                String[] strs = PySelection.getActivationTokenAndQual((IDocument)doc, (int)documentOffset, (boolean)false);
                String activationToken = strs[0];
                String qualifier = strs[1];
                if (request.showTemplates && (activationToken == null || activationToken.trim().length() == 0)) {
                    List templateProposals = this.getTemplateProposals(viewer, documentOffset, activationToken, qualifier);
                    pythonAndTemplateProposals.addAll(templateProposals);
                }
                proposals = PyCodeCompletionUtils.onlyValidSorted(pythonAndTemplateProposals, request.qualifier, request.isInCalltip);
            }
            finally {
                nature.endRequests();
            }
        }
        catch (Exception e) {
            CompletionError completionError = new CompletionError(e);
            this.setError(e, completionError.getErrorMessage());
            return new ICompletionProposal[]{completionError};
        }
        this.doCycle();
        return proposals;
    }

    private void setError(Throwable e, String error) {
        this.error = error;
        PydevPlugin.log(e);
    }

    private List getPythonProposals(ITextViewer viewer, int documentOffset, IDocument doc, CompletionRequest request) throws CoreException, BadLocationException, IOException, MisconfigurationException, PythonNatureWithoutProjectException {
        String importsTipperStr = request.codeCompletion.getImportsTipperStr((CompletionRequest)request).importsTipperStr;
        if (importsTipperStr.length() != 0 || request.isInCalltip) {
            request.showTemplates = false;
        }
        List<Object> allProposals = request.codeCompletion.getCodeCompletionProposals(viewer, request);
        return allProposals;
    }

    private List getTemplateProposals(ITextViewer viewer, int documentOffset, String activationToken, String qualifier) {
        ArrayList<ICompletionProposal> propList = new ArrayList<ICompletionProposal>();
        this.templatesCompletion.addTemplateProposals(viewer, documentOffset, propList);
        return propList;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        if (viewer.getDocument() != this.contextInformationValidator.doc) {
            return null;
        }
        if (this.contextInformationValidator.returnedFalseOnce && this.contextInformationValidator.isContextInformationValid(documentOffset)) {
            return new IContextInformation[]{this.contextInformationValidator.fInformation};
        }
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return PythonCompletionProcessor.getStaticCompletionProposalAutoActivationCharacters();
    }

    public static char[] getStaticCompletionProposalAutoActivationCharacters() {
        if (!listenerToClearAutoActivationAlreadySetup) {
            IPreferenceStore preferenceStore = PydevPlugin.getDefault().getPreferenceStore();
            preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    activationChars = null;
                }
            });
            listenerToClearAutoActivationAlreadySetup = true;
        }
        if (activationChars == null) {
            if (!PyCodeCompletionPreferencesPage.useAutocomplete()) {
                activationChars = new char[0];
            } else {
                char[] c = new char[]{};
                if (PyCodeCompletionPreferencesPage.isToAutocompleteOnDot()) {
                    c = StringUtils.addChar((char[])c, (char)'.');
                }
                if (PyCodeCompletionPreferencesPage.isToAutocompleteOnPar()) {
                    c = StringUtils.addChar((char[])c, (char)'(');
                }
                activationChars = c;
            }
        }
        return activationChars;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        String ret = this.error;
        this.error = null;
        return ret;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.contextInformationValidator;
    }
}

