/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.internal.texteditor.spelling.NoCompletionsProposal;
import org.eclipse.ui.texteditor.spelling.SpellingAnnotation;
import org.eclipse.ui.texteditor.spelling.SpellingCorrectionProcessor;
import org.eclipse.ui.texteditor.spelling.SpellingProblem;
import org.python.pydev.core.ExtensionHelper;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.bundle.ImageCache;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.IPySyntaxHighlightingAndCodeCompletionEditor;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.editor.codecompletion.IPyCodeCompletion;
import org.python.pydev.editor.correctionassist.docstrings.AssistDocString;
import org.python.pydev.editor.correctionassist.heuristics.AssistAssign;
import org.python.pydev.editor.correctionassist.heuristics.AssistImport;
import org.python.pydev.editor.correctionassist.heuristics.AssistSurroundWith;
import org.python.pydev.editor.correctionassist.heuristics.IAssistProps;
import org.python.pydev.plugin.PydevPlugin;

public class PythonCorrectionProcessor
implements IQuickAssistProcessor {
    private IPySyntaxHighlightingAndCodeCompletionEditor edit;
    private static Map<String, IAssistProps> additionalAssists = new HashMap<String, IAssistProps>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasAdditionalAssist(String id) {
        Map<String, IAssistProps> map = additionalAssists;
        synchronized (map) {
            return additionalAssists.containsKey(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAdditionalAssist(String id, IAssistProps assist) {
        Map<String, IAssistProps> map = additionalAssists;
        synchronized (map) {
            additionalAssists.put(id, assist);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeAdditionalAssist(String id) {
        Map<String, IAssistProps> map = additionalAssists;
        synchronized (map) {
            additionalAssists.remove(id);
        }
    }

    public PythonCorrectionProcessor(IPySyntaxHighlightingAndCodeCompletionEditor edit) {
        this.edit = edit;
    }

    public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
        return true;
    }

    public boolean canFix(Annotation annotation) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        int offset = invocationContext.getOffset();
        PySelection base = this.edit.createPySelection();
        if (!(this.edit instanceof PyEdit) || base == null) {
            return new ICompletionProposal[0];
        }
        PyEdit editor = (PyEdit)this.edit;
        ArrayList<ICompletionProposal> results = new ArrayList<ICompletionProposal>();
        String sel = PyAction.getLineWithoutComments(base);
        ArrayList<IAssistProps> assists = new ArrayList<IAssistProps>();
        Map<String, IAssistProps> map = additionalAssists;
        synchronized (map) {
            Iterator<IAssistProps> iterator = additionalAssists.values().iterator();
            while (iterator.hasNext()) {
                IAssistProps prop = iterator.next();
                assists.add(prop);
            }
        }
        assists.add(new AssistSurroundWith());
        assists.add(new AssistImport());
        assists.add(new AssistDocString());
        assists.add(new AssistAssign());
        assists.addAll(ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_ctrl_1"));
        ImageCache imageCache = PydevPlugin.getImageCache();
        File editorFile = this.edit.getEditorFile();
        IPythonNature pythonNature = null;
        try {
            pythonNature = this.edit.getPythonNature();
        }
        catch (MisconfigurationException e1) {
            Log.log((Throwable)e1);
        }
        Iterator iterator = assists.iterator();
        while (iterator.hasNext()) {
            IAssistProps assist = (IAssistProps)iterator.next();
            PySelection ps = new PySelection(base);
            try {
                if (!assist.isValid(ps, sel, editor, offset)) continue;
                try {
                    results.addAll(assist.getProps(ps, imageCache, editorFile, pythonNature, editor, offset));
                }
                catch (Exception e) {
                    PydevPlugin.log(e);
                }
            }
            catch (Exception e) {
                PydevPlugin.log(e);
            }
        }
        Collections.sort(results, IPyCodeCompletion.PROPOSAL_COMPARATOR);
        try {
            ICompletionProposal[] spellProps = null;
            IAnnotationModel annotationModel = editor.getPySourceViewer().getAnnotationModel();
            Iterator it = annotationModel.getAnnotationIterator();
            while (it.hasNext()) {
                Object annotation = it.next();
                if (!(annotation instanceof SpellingAnnotation)) continue;
                SpellingAnnotation spellingAnnotation = (SpellingAnnotation)annotation;
                SpellingProblem spellingProblem = spellingAnnotation.getSpellingProblem();
                int problemOffset = spellingProblem.getOffset();
                int problemLen = spellingProblem.getLength();
                if (problemOffset > offset || problemOffset + problemLen < offset) continue;
                SpellingCorrectionProcessor spellingCorrectionProcessor = new SpellingCorrectionProcessor();
                spellProps = spellingCorrectionProcessor.computeQuickAssistProposals(invocationContext);
                break;
            }
            if (spellProps == null || spellProps.length == 1 && spellProps[0] instanceof NoCompletionsProposal) {
                return results.toArray(new ICompletionProposal[results.size()]);
            }
            ICompletionProposal[] ret = results.toArray(new ICompletionProposal[results.size() + spellProps.length]);
            System.arraycopy(spellProps, 0, ret, results.size(), spellProps.length);
            return ret;
        }
        catch (Throwable e) {
            if (e instanceof ClassNotFoundException || e instanceof LinkageError || e instanceof NoSuchMethodException || e instanceof NoSuchMethodError || e instanceof NoClassDefFoundError) {
                return results.toArray(new ICompletionProposal[results.size()]);
            }
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ICompletionProposal[] onComputeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
        int offset = invocationContext.getOffset();
        PySelection base = this.edit.createPySelection();
        if (!(this.edit instanceof PyEdit) || base == null) {
            return new ICompletionProposal[0];
        }
        PyEdit editor = (PyEdit)this.edit;
        ArrayList<ICompletionProposal> results = new ArrayList<ICompletionProposal>();
        String sel = PyAction.getLineWithoutComments(base);
        ArrayList<IAssistProps> assists = new ArrayList<IAssistProps>();
        Map<String, IAssistProps> map = additionalAssists;
        synchronized (map) {
            Iterator<IAssistProps> iterator = additionalAssists.values().iterator();
            while (iterator.hasNext()) {
                IAssistProps prop = iterator.next();
                assists.add(prop);
            }
        }
        assists.add(new AssistSurroundWith());
        assists.add(new AssistImport());
        assists.add(new AssistDocString());
        assists.add(new AssistAssign());
        assists.addAll(ExtensionHelper.getParticipants((String)"org.python.pydev.pydev_ctrl_1"));
        ImageCache imageCache = PydevPlugin.getImageCache();
        File editorFile = this.edit.getEditorFile();
        IPythonNature pythonNature = null;
        try {
            pythonNature = this.edit.getPythonNature();
        }
        catch (MisconfigurationException e1) {
            Log.log((Throwable)e1);
        }
        Iterator iterator = assists.iterator();
        while (iterator.hasNext()) {
            IAssistProps assist = (IAssistProps)iterator.next();
            PySelection ps = new PySelection(base);
            try {
                if (!assist.isValid(ps, sel, editor, offset)) continue;
                try {
                    results.addAll(assist.getProps(ps, imageCache, editorFile, pythonNature, editor, offset));
                }
                catch (Exception e) {
                    PydevPlugin.log(e);
                }
            }
            catch (Exception e) {
                PydevPlugin.log(e);
            }
        }
        Collections.sort(results, IPyCodeCompletion.PROPOSAL_COMPARATOR);
        try {
            ICompletionProposal[] spellProps = null;
            IAnnotationModel annotationModel = editor.getPySourceViewer().getAnnotationModel();
            Iterator it = annotationModel.getAnnotationIterator();
            while (it.hasNext()) {
                Object annotation = it.next();
                if (!(annotation instanceof SpellingAnnotation)) continue;
                SpellingAnnotation spellingAnnotation = (SpellingAnnotation)annotation;
                SpellingProblem spellingProblem = spellingAnnotation.getSpellingProblem();
                int problemOffset = spellingProblem.getOffset();
                int problemLen = spellingProblem.getLength();
                if (problemOffset > offset || problemOffset + problemLen < offset) continue;
                SpellingCorrectionProcessor spellingCorrectionProcessor = new SpellingCorrectionProcessor();
                spellProps = spellingCorrectionProcessor.computeQuickAssistProposals(invocationContext);
                break;
            }
            if (spellProps == null || spellProps.length == 1 && spellProps[0] instanceof NoCompletionsProposal) {
                return results.toArray(new ICompletionProposal[results.size()]);
            }
            ICompletionProposal[] ret = results.toArray(new ICompletionProposal[results.size() + spellProps.length]);
            System.arraycopy(spellProps, 0, ret, results.size(), spellProps.length);
            return ret;
        }
        catch (Throwable e) {
            if (e instanceof ClassNotFoundException || e instanceof LinkageError || e instanceof NoSuchMethodException || e instanceof NoSuchMethodError || e instanceof NoClassDefFoundError) {
                return results.toArray(new ICompletionProposal[results.size()]);
            }
            throw new RuntimeException(e);
        }
    }

    public String getErrorMessage() {
        return null;
    }
}

