/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editor.correctionassist.docstrings;

import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.editor.correctionassist.docstrings.ParameterNamePrefixListEditor;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;

public class DocstringsPrefPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IPropertyChangeListener {
    public static final String P_DOCSTRINGCHARACTER = "DOCSTRING CHARACTER";
    public static final String DEFAULT_P_DOCSTRINGCHARACTER = "'";
    public static final String TYPETAG_GENERATION_NEVER = "Never";
    public static final String TYPETAG_GENERATION_ALWAYS = "Always";
    public static final String TYPETAG_GENERATION_CUSTOM = "Custom";
    public static final String P_TYPETAGGENERATION = "TYPETAGGENERATION";
    public static final String DEFAULT_P_TYPETAGGENERATION = "Never";
    public static final String P_DONT_GENERATE_TYPETAGS = "DONT_GENERATE_TYPETAGS_PREFIXES";
    public static final String DEFAULT_P_DONT_GENERATE_TYPETAGS = "sz\u0000n\u0000f";
    private static final Map<String, String> strToMarker = new HashMap<String, String>();
    private RadioGroupFieldEditor typeDoctagEditor;

    static {
        strToMarker.put(DEFAULT_P_DOCSTRINGCHARACTER, "'''");
        strToMarker.put("\"", "\"\"\"");
    }

    public DocstringsPrefPage() {
        super(1);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("Docstring preferences");
    }

    public static String getPreferredDocstringCharacter() {
        PydevPlugin plugin = PydevPlugin.getDefault();
        if (plugin == null) {
            return DEFAULT_P_DOCSTRINGCHARACTER;
        }
        IPreferenceStore preferences = PydevPrefs.getPreferences();
        return preferences.getString(P_DOCSTRINGCHARACTER);
    }

    public static String getDocstringMarker() {
        String docstringChar = DocstringsPrefPage.getPreferredDocstringCharacter();
        String ret = strToMarker.get(docstringChar);
        if (ret == null) {
            ret = String.valueOf(docstringChar) + docstringChar + docstringChar;
            strToMarker.put(docstringChar, ret);
        }
        return ret;
    }

    public static boolean getTypeTagShouldBeGenerated(String parameterName) {
        if (PydevPlugin.getDefault() == null) {
            return true;
        }
        String preference = PydevPrefs.getPreferences().getString(P_TYPETAGGENERATION);
        if (preference.equals("Never")) {
            return false;
        }
        if (preference.equals(TYPETAG_GENERATION_ALWAYS)) {
            return true;
        }
        String prefixesString = PydevPrefs.getPreferences().getString(P_DONT_GENERATE_TYPETAGS);
        StringTokenizer st = new StringTokenizer(prefixesString, "\u0000");
        while (st.hasMoreTokens()) {
            if (!parameterName.startsWith(st.nextToken())) continue;
            return false;
        }
        return true;
    }

    public void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        Composite p2 = new Composite(p, 0);
        p2.setLayout((Layout)new RowLayout());
        RadioGroupFieldEditor docstringCharEditor = new RadioGroupFieldEditor(P_DOCSTRINGCHARACTER, "Docstring character", 1, (String[][])new String[][]{{"Quotation mark (\")", "\""}, {"Apostrophe (')", DEFAULT_P_DOCSTRINGCHARACTER}}, p2, true);
        this.addField((FieldEditor)docstringCharEditor);
        Group typeDoctagGroup = new Group(p2, 0);
        typeDoctagGroup.setText("Type doctag generation (@type x:...)");
        this.typeDoctagEditor = new RadioGroupFieldEditor(P_TYPETAGGENERATION, "", 1, (String[][])new String[][]{{"&Always", TYPETAG_GENERATION_ALWAYS}, {"&Never", "Never"}, {"&Custom", TYPETAG_GENERATION_CUSTOM}}, (Composite)typeDoctagGroup);
        this.addField((FieldEditor)this.typeDoctagEditor);
        this.typeDoctagEditor.setPropertyChangeListener((IPropertyChangeListener)this);
        this.addField((FieldEditor)new ParameterNamePrefixListEditor(P_DONT_GENERATE_TYPETAGS, "Don't create for parameters with prefix", (Composite)typeDoctagGroup));
    }

    public void init(IWorkbench workbench) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        InputDialog d = new InputDialog(this.getShell(), "Type doctag generation", "Enter a parameter prefix", null, null);
        d.open();
    }
}

