/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editorinput;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.part.FileEditorInput;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editorinput.PyFileLabelProvider;
import org.python.pydev.editorinput.PySourceLocatorPrefs;
import org.python.pydev.editorinput.PydevFileEditorInput;
import org.python.pydev.ui.filetypes.FileTypesPreferencesPage;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PySourceLocatorBase {
    public IEditorInput createEditorInput(IPath path) {
        return this.createEditorInput(path, true);
    }

    public IFile getWorkspaceFile(File file) {
        IFile[] files = this.getWorkspaceFiles(file);
        return this.selectWorkspaceFile(files);
    }

    public IFile[] getWorkspaceFiles(File file) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IFile[] files = workspace.getRoot().findFilesForLocationURI(file.toURI());
        if ((files = this.filterNonExistentFiles(files)) == null || files.length == 0) {
            return null;
        }
        return files;
    }

    public IContainer getWorkspaceContainer(File file) {
        IContainer[] containers = this.getWorkspaceContainers(file);
        if (containers == null || containers.length < 1) {
            return null;
        }
        return containers[0];
    }

    public IContainer[] getWorkspaceContainers(File file) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IContainer[] containers = workspace.getRoot().findContainersForLocationURI(file.toURI());
        if ((containers = this.filterNonExistentContainers(containers)) == null || containers.length == 0) {
            return null;
        }
        return containers;
    }

    public IEditorInput createEditorInput(IPath path, boolean askIfDoesNotExist) {
        String pathTranslation = PySourceLocatorPrefs.getPathTranslation(path);
        if (pathTranslation != null) {
            if (!pathTranslation.equals("DONTASK")) {
                path = Path.fromOSString((String)pathTranslation);
            } else {
                askIfDoesNotExist = false;
            }
        }
        IEditorInput edInput = null;
        IWorkspace w = ResourcesPlugin.getWorkspace();
        IFile fileForLocation = w.getRoot().getFileForLocation(path);
        if (fileForLocation != null && fileForLocation.exists()) {
            return new FileEditorInput(fileForLocation);
        }
        IFile[] files = w.getRoot().findFilesForLocation(path);
        if (files == null || files.length == 0 || !files[0].exists()) {
            File systemFile = path.toFile();
            if (systemFile.exists()) {
                edInput = this.createEditorInput(systemFile);
            } else if (askIfDoesNotExist) {
                File file;
                IEditorInput input = this.getEditorInputFromExistingEditors(systemFile.getName());
                if (input != null) {
                    return input;
                }
                List<IFile> likelyFiles = this.getLikelyFiles(path, w);
                IFile iFile = this.selectWorkspaceFile(likelyFiles.toArray(new IFile[0]));
                if (iFile != null) {
                    PySourceLocatorPrefs.addPathTranslation(path, iFile.getLocation());
                    return new FileEditorInput(iFile);
                }
                IEditorInput pydevFileEditorInput = this.selectFilesystemFileForPath(path);
                input = pydevFileEditorInput;
                if (input != null && (file = PydevFileEditorInput.getFile(pydevFileEditorInput)) != null) {
                    PySourceLocatorPrefs.addPathTranslation(path, Path.fromOSString((String)REF.getFileAbsolutePath((File)file)));
                    return input;
                }
                PySourceLocatorPrefs.setIgnorePathTranslation(path);
            }
        } else {
            IFile workspaceFile = this.selectWorkspaceFile(files);
            if (workspaceFile != null) {
                edInput = new FileEditorInput(workspaceFile);
            }
        }
        return edInput;
    }

    private IEditorInput getEditorInputFromExistingEditors(final String matchName) {
        final Tuple workbenchAndReturn = new Tuple((Object)PlatformUI.getWorkbench().getActiveWorkbenchWindow(), null);
        Runnable r = new Runnable(){

            public void run() {
                IEditorReference[] editorReferences;
                IWorkbenchWindow workbenchWindow = (IWorkbenchWindow)workbenchAndReturn.o1;
                if (workbenchWindow == null) {
                    workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                }
                if (workbenchWindow == null) {
                    return;
                }
                IWorkbenchPage activePage = workbenchWindow.getActivePage();
                if (activePage == null) {
                    return;
                }
                IEditorReference[] iEditorReferenceArray = editorReferences = activePage.getEditorReferences();
                int n = editorReferences.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    IEditorPart editor = editorReference.getEditor(false);
                    if (editor != null && editor instanceof PyEdit) {
                        PyEdit pyEdit = (PyEdit)editor;
                        IEditorInput editorInput = pyEdit.getEditorInput();
                        if (editorInput instanceof IPathEditorInput) {
                            String considerName;
                            IPathEditorInput pathEditorInput = (IPathEditorInput)editorInput;
                            IPath localPath = pathEditorInput.getPath();
                            if (localPath != null && matchName.equals(considerName = localPath.segment(localPath.segmentCount() - 1))) {
                                workbenchAndReturn.o2 = editorInput;
                                return;
                            }
                        } else {
                            File editorFile = pyEdit.getEditorFile();
                            if (editorFile != null && editorFile.getName().equals(matchName)) {
                                workbenchAndReturn.o2 = editorInput;
                                return;
                            }
                        }
                    }
                    ++n2;
                }
            }
        };
        if (workbenchAndReturn.o1 == null) {
            Display.getDefault().syncExec(r);
        } else {
            r.run();
        }
        return (IEditorInput)workbenchAndReturn.o2;
    }

    protected IEditorInput selectFilesystemFileForPath(final IPath path) {
        final ArrayList l = new ArrayList();
        Runnable r = new Runnable(){

            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                FileDialog dialog = new FileDialog(shell);
                dialog.setText(path + " - select correspondent filesystem file.");
                String[] wildcardValidSourceFiles = FileTypesPreferencesPage.getWildcardValidSourceFiles();
                wildcardValidSourceFiles = StringUtils.addString((String[])wildcardValidSourceFiles, (String)"*");
                dialog.setFilterExtensions(wildcardValidSourceFiles);
                String string = dialog.open();
                if (string != null) {
                    l.add(string);
                }
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(r);
        } else {
            r.run();
        }
        if (l.size() > 0) {
            String fileAbsolutePath = REF.getFileAbsolutePath((String)((String)l.get(0)));
            return PydevFileEditorInput.create(new File(fileAbsolutePath), true);
        }
        return null;
    }

    private List<IFile> getLikelyFiles(IPath path, IWorkspace w) {
        ArrayList<IFile> ret = new ArrayList<IFile>();
        try {
            IResource[] resources = w.getRoot().members();
            this.getLikelyFiles(path, ret, resources);
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        return ret;
    }

    private void getLikelyFiles(IPath path, List<IFile> ret, IResource[] resources) throws CoreException {
        String strPath = path.removeFileExtension().lastSegment().toLowerCase();
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource instanceof IFile) {
                IFile f = (IFile)resource;
                if (PythonPathHelper.isValidSourceFile(f) && resource.getFullPath().removeFileExtension().lastSegment().toLowerCase().equals(strPath)) {
                    ret.add((IFile)resource);
                }
            } else if (resource instanceof IContainer) {
                this.getLikelyFiles(path, ret, ((IContainer)resource).members());
            }
            ++n2;
        }
    }

    private IEditorInput createEditorInput(File file) {
        IFile[] workspaceFile = this.getWorkspaceFiles(file);
        if (workspaceFile != null && workspaceFile.length > 0) {
            IFile file2 = this.selectWorkspaceFile(workspaceFile);
            if (file2 != null) {
                return new FileEditorInput(file2);
            }
            return new FileEditorInput(workspaceFile[0]);
        }
        return PydevFileEditorInput.create(file, true);
    }

    private IFile[] filterNonExistentFiles(IFile[] files) {
        if (files == null) {
            return null;
        }
        int length = files.length;
        ArrayList<IFile> existentFiles = new ArrayList<IFile>(length);
        int i = 0;
        while (i < length) {
            if (files[i].exists()) {
                existentFiles.add(files[i]);
            }
            ++i;
        }
        return existentFiles.toArray(new IFile[existentFiles.size()]);
    }

    public IContainer[] filterNonExistentContainers(IContainer[] containers) {
        if (containers == null) {
            return null;
        }
        int length = containers.length;
        ArrayList<IContainer> existentFiles = new ArrayList<IContainer>(length);
        int i = 0;
        while (i < length) {
            if (containers[i].exists()) {
                existentFiles.add(containers[i]);
            }
            ++i;
        }
        return existentFiles.toArray(new IContainer[existentFiles.size()]);
    }

    private IFile selectWorkspaceFile(final IFile[] files) {
        if (files == null || files.length == 0) {
            return null;
        }
        if (files.length == 1) {
            return files[0];
        }
        final ArrayList selected = new ArrayList();
        Runnable r = new Runnable(){

            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, (ILabelProvider)new PyFileLabelProvider());
                dialog.setElements((Object[])files);
                dialog.setTitle("Select Workspace File");
                dialog.setMessage("File may be matched to multiple files in the workspace.");
                if (dialog.open() == 0) {
                    selected.add((IFile)dialog.getFirstResult());
                }
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(r);
        } else {
            r.run();
        }
        if (selected.size() > 0) {
            return (IFile)selected.get(0);
        }
        return null;
    }
}

