/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.editorinput;

import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.File;
import java.net.URI;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.ide.FileStoreEditorInput;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.python.pydev.core.REF;
import org.python.pydev.editorinput.PySourceLocatorBase;
import org.python.pydev.plugin.PydevPlugin;

public class PydevFileEditorInput
implements IPathEditorInput,
ILocationProvider {
    private File fFile;
    private WorkbenchAdapter fWorkbenchAdapter = new WorkbenchAdapter();

    private PydevFileEditorInput(File file) {
        this.fFile = file;
        this.fWorkbenchAdapter = new WorkbenchAdapter();
    }

    public static IEditorInput create(File file, boolean forceExternalFile) {
        IEditorInput input;
        if (!forceExternalFile && (input = new PySourceLocatorBase().createEditorInput(Path.fromOSString((String)REF.getFileAbsolutePath((File)file)), false)) != null) {
            return input;
        }
        try {
            URI uri = file.toURI();
            return new FileStoreEditorInput(EFS.getStore((URI)uri));
        }
        catch (Throwable throwable) {
            return new PydevFileEditorInput(file);
        }
    }

    public boolean exists() {
        return this.fFile.exists();
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getName() {
        return this.fFile.getName();
    }

    public IPersistableElement getPersistable() {
        return null;
    }

    public String getToolTipText() {
        return this.fFile.getAbsolutePath();
    }

    public Object getAdapter(Class adapter) {
        if (ClassLiteral.getClass((String)"org/eclipse/ui/editors/text/ILocationProvider").equals(adapter)) {
            return this;
        }
        if (ClassLiteral.getClass((String)"org/eclipse/ui/model/IWorkbenchAdapter").equals(adapter)) {
            return this.fWorkbenchAdapter;
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public IPath getPath(Object element) {
        if (element instanceof PydevFileEditorInput) {
            PydevFileEditorInput input = (PydevFileEditorInput)element;
            return Path.fromOSString((String)input.fFile.getAbsolutePath());
        }
        return null;
    }

    public IPath getPath() {
        return Path.fromOSString((String)this.fFile.getAbsolutePath());
    }

    public static File getFile(IEditorInput o) {
        if (o == null) {
            return null;
        }
        if (o instanceof PydevFileEditorInput) {
            PydevFileEditorInput input = (PydevFileEditorInput)o;
            return input.fFile;
        }
        if (o instanceof IFileEditorInput) {
            IFileEditorInput input = (IFileEditorInput)o;
            IFile file = input.getFile();
            String resourceOSString = PydevPlugin.getIResourceOSString((IResource)file);
            if (resourceOSString == null) {
                return null;
            }
            return new File(resourceOSString);
        }
        if (o instanceof IPathEditorInput) {
            IPathEditorInput input = (IPathEditorInput)o;
            return new File(input.getPath().toOSString());
        }
        try {
            if (o instanceof IURIEditorInput) {
                IURIEditorInput iuriEditorInput = (IURIEditorInput)o;
                return new File(iuriEditorInput.getURI());
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IEditorInput)) {
            return false;
        }
        File file = PydevFileEditorInput.getFile((IEditorInput)o);
        return this.fFile.equals(file);
    }

    public int hashCode() {
        return this.fFile.hashCode();
    }

    public File getFile() {
        return this.fFile;
    }

    private static class WorkbenchAdapter
    implements IWorkbenchAdapter {
        private WorkbenchAdapter() {
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            return null;
        }

        public String getLabel(Object o) {
            return ((PydevFileEditorInput)o).getName();
        }

        public Object getParent(Object o) {
            return null;
        }
    }
}

