/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.pyunit.preferences;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.utils.ComboFieldEditor;
import org.python.pydev.utils.LabelFieldEditor;
import org.python.pydev.utils.MultiStringFieldEditor;

public class PyUnitPrefsPage2
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final int TEST_RUNNER_PYDEV = 0;
    public static final int TEST_RUNNER_NOSE = 1;
    public static final int TEST_RUNNER_PY_TEST = 2;
    public static final String[][] ENTRY_NAMES_AND_VALUES = new String[][]{{"Pydev test runner", Integer.toString(0)}, {"Nose test runner", Integer.toString(1)}, {"Py.test runner", Integer.toString(2)}};
    public static final String TEST_RUNNER = "PYDEV_TEST_RUNNER";
    public static final int DEFAULT_TEST_RUNNER = 0;
    public static final String TEST_RUNNER_DEFAULT_PARAMETERS = "PYDEV_TEST_RUNNER_DEFAULT_PARAMETERS";
    public static final String DEFAULT_TEST_RUNNER_DEFAULT_PARAMETERS = "--verbosity 0";
    public static final String USE_PYUNIT_VIEW = "PYDEV_USE_PYUNIT_VIEW";
    public static final boolean DEFAULT_USE_PYUNIT_VIEW = true;
    public static final String LAUNCH_CONFIG_OVERRIDE_PYUNIT_RUN_PARAMS_CHOICE = "LAUNCH_CONFIG_OVERRIDE_PYUNIT_RUN_PARAMS_CHOICE";
    public static final String LAUNCH_CONFIG_OVERRIDE_TEST_RUNNER = "LAUNCH_CONFIG_OVERRIDE_TEST_RUNNER";
    public static final String LAUNCH_CONFIG_OVERRIDE_PYUNIT_RUN_PARAMS = "LAUNCH_CONFIG_OVERRIDE_PYUNIT_RUN_PARAMS";

    public PyUnitPrefsPage2() {
        super(0);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.addField(PyUnitPrefsPage2.createTestRunnerEditor(p));
        this.addField((FieldEditor)new MultiStringFieldEditor(TEST_RUNNER_DEFAULT_PARAMETERS, "Parameters for test runner", p));
        this.addField((FieldEditor)new BooleanFieldEditor(USE_PYUNIT_VIEW, "Show the results in the unittest results view?", p));
        String s = "Note: if unchecked, no xml-rpc communication will be done when running tests\nand the output will only be shown in the console.";
        this.addField(new LabelFieldEditor("LabelFieldEditor", s, p));
    }

    public static ComboFieldEditor createTestRunnerEditor(Composite p) {
        return new ComboFieldEditor(TEST_RUNNER, "Test Runner", ENTRY_NAMES_AND_VALUES, p);
    }

    public void init(IWorkbench workbench) {
    }

    public static String getTestRunnerParameters(ILaunchConfiguration config) {
        boolean override = false;
        try {
            override = config.getAttribute(LAUNCH_CONFIG_OVERRIDE_PYUNIT_RUN_PARAMS_CHOICE, false);
        }
        catch (CoreException e) {
            PydevPlugin.log(e);
        }
        IPreferenceStore prefs = PydevPrefs.getPreferenceStore();
        int testRunner = prefs.getInt(TEST_RUNNER);
        String ret = prefs.getString(TEST_RUNNER_DEFAULT_PARAMETERS);
        if (override) {
            try {
                testRunner = config.getAttribute(LAUNCH_CONFIG_OVERRIDE_TEST_RUNNER, testRunner);
            }
            catch (CoreException e) {
                PydevPlugin.log(e);
            }
            try {
                ret = config.getAttribute(LAUNCH_CONFIG_OVERRIDE_PYUNIT_RUN_PARAMS, ret);
            }
            catch (CoreException e) {
                PydevPlugin.log(e);
            }
        }
        switch (testRunner) {
            case 1: {
                ret = "--nose-params " + ret;
                break;
            }
            case 2: {
                ret = "--py-test-params " + ret;
            }
        }
        return ret;
    }

    public static boolean getUsePyUnitView() {
        return PydevPrefs.getPreferenceStore().getBoolean(USE_PYUNIT_VIEW);
    }

    public static void showPage() {
        String id = "org.python.pydev.prefs.pyunitPage";
        PreferenceDialog prefDialog = PreferencesUtil.createPreferenceDialogOn(null, (String)id, null, null);
        prefDialog.open();
    }
}

