/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.dialogs;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.uiutils.DialogMemento;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.ui.dialogs.StringFromListContentProvider;
import org.python.pydev.ui.dialogs.ToStringLabelProvider;
import org.python.pydev.ui.dialogs.TreeSelectionDialog;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectExistingOrCreateNewDialog
extends TreeSelectionDialog
implements SelectionListener {
    private static final String NEW_ENTRY_TEXT = "New entry (whathever is written in the text field).";
    private final DialogMemento memento;
    private final IPreferenceStore preferenceStore;
    private String preferenceKey;
    private List<String> input;
    private Button btAdd;
    private Button btRemove;
    Set<String> currentlyAccepted = new HashSet<String>();

    public SelectExistingOrCreateNewDialog(Shell parent, IPreferenceStore preferenceStore, String preferenceKey, String shellMementoId) {
        super(parent, (ILabelProvider)new ToStringLabelProvider(), new StringFromListContentProvider());
        this.memento = new DialogMemento(parent, shellMementoId);
        this.preferenceStore = preferenceStore;
        String initialValue = preferenceStore.getString(preferenceKey);
        this.preferenceKey = preferenceKey;
        this.setInput(StringUtils.split((String)initialValue, (char)'|'));
        this.setAllowMultiple(false);
        this.setValidator(this.createValidator());
        this.setHelpAvailable(false);
        this.updateInThread = false;
    }

    private ISelectionStatusValidator createValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                if (selection != null && selection.length == 1) {
                    return new Status(0, PydevPlugin.getPluginID(), this.getEntry(selection[0].toString()));
                }
                TreeItem[] items = SelectExistingOrCreateNewDialog.this.getTreeViewer().getTree().getItems();
                if ((selection == null || selection.length == 0) && items != null) {
                    if (items.length == 1) {
                        return new Status(0, PydevPlugin.getPluginID(), this.getEntry(items[0].getData().toString()));
                    }
                    if (items.length > 0) {
                        String textInEditor = SelectExistingOrCreateNewDialog.this.text.getText();
                        TreeItem[] treeItemArray = items;
                        int n = items.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeItem item = treeItemArray[n2];
                            if (item.getData().toString().equals(textInEditor)) {
                                return new Status(0, PydevPlugin.getPluginID(), textInEditor);
                            }
                            ++n2;
                        }
                    }
                }
                if (!(selection != null && selection.length != 0 || items != null && items.length != 0)) {
                    return new Status(4, PydevPlugin.getPluginID(), "No selection available.");
                }
                return new Status(4, PydevPlugin.getPluginID(), "Only 1 entry may be selected or visible.");
            }

            private String getEntry(String string) {
                if (SelectExistingOrCreateNewDialog.NEW_ENTRY_TEXT.equals(string)) {
                    return SelectExistingOrCreateNewDialog.this.text.getText();
                }
                return string;
            }
        };
    }

    public boolean close() {
        this.memento.writeSettings(this.getShell());
        return super.close();
    }

    @Override
    public Control createDialogArea(Composite parent) {
        this.memento.readSettings();
        Control ret = super.createDialogArea(parent);
        this.getTreeViewer().getTree().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
                if (e.keyCode == 127) {
                    SelectExistingOrCreateNewDialog.this.removeSelection();
                }
            }

            public void keyPressed(KeyEvent e) {
            }
        });
        Tree tree = this.getTreeViewer().getTree();
        GridData layoutData = (GridData)tree.getLayoutData();
        layoutData.grabExcessHorizontalSpace = true;
        layoutData.grabExcessVerticalSpace = true;
        layoutData.horizontalAlignment = 4;
        layoutData.verticalAlignment = 4;
        return ret;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        GridData layoutData = new GridData(1808);
        composite.setLayoutData((Object)layoutData);
        TreeViewer ret = super.createTreeViewer(composite);
        Composite buttonBox = new Composite(composite, 0);
        GridData gridData = new GridData(0x1000008, 4, false, false);
        buttonBox.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        buttonBox.setLayout((Layout)layout);
        this.btAdd = this.createPushButton(buttonBox, "Add");
        this.btRemove = this.createPushButton(buttonBox, "Remove (DEL)");
        return ret;
    }

    private Button createPushButton(Composite parent, String text) {
        Button button = new Button(parent, 8);
        button.setText(text);
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener((SelectionListener)this);
        return button;
    }

    protected int convertHorizontalDLUsToPixels(Control control, int dlus) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int averageWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        double horizontalDialogUnitSize = (double)averageWidth * 0.25;
        return (int)Math.round((double)dlus * horizontalDialogUnitSize);
    }

    protected Point getInitialSize() {
        return this.memento.getInitialSize(super.getInitialSize(), this.getShell());
    }

    protected Point getInitialLocation(Point initialSize) {
        return this.memento.getInitialLocation(initialSize, super.getInitialLocation(initialSize), this.getShell());
    }

    @Override
    protected void computeResult() {
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        List<String> list = selection.toList();
        if (list.size() == 1) {
            Object selected = list.get(0);
            if (NEW_ENTRY_TEXT.equals(selected)) {
                list = this.newCommand();
            }
            this.setResult(list);
        } else {
            TreeItem[] items = this.getTreeViewer().getTree().getItems();
            if (items.length == 1) {
                list = new ArrayList<String>();
                Object entry = items[0].getData();
                if (NEW_ENTRY_TEXT.equals(entry)) {
                    list = this.newCommand();
                } else {
                    list.add((String)entry);
                }
                this.setResult(list);
            } else if (items.length > 1) {
                String textInEditor = this.text.getText();
                TreeItem[] treeItemArray = items;
                int n = items.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeItem item = treeItemArray[n2];
                    if (item.getData().toString().equals(textInEditor)) {
                        list = new ArrayList<String>();
                        list.add(textInEditor);
                    }
                    ++n2;
                }
                this.setResult(list);
            }
        }
    }

    public void widgetSelected(SelectionEvent e) {
        Object source = e.getSource();
        if (source == this.btAdd) {
            InputDialog dialog = new InputDialog(this.getShell(), "Add custom command to list", "Add custom command to list", "", new IInputValidator(){

                public String isValid(String newText) {
                    if (newText.trim().length() == 0) {
                        return "Command not entered.";
                    }
                    if (SelectExistingOrCreateNewDialog.this.input.contains(newText)) {
                        return "Command already entered.";
                    }
                    return null;
                }
            });
            int open = dialog.open();
            if (open == 0) {
                String value = dialog.getValue();
                this.input.add(value);
                this.saveCurrentCommands(value);
                this.updateGui();
            }
        } else if (source == this.btRemove) {
            this.removeSelection();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private List<String> newCommand() {
        ArrayList<String> list = new ArrayList<String>();
        String newCommand = this.text.getText().trim();
        if (newCommand.length() > 0) {
            list.add(newCommand);
            this.saveCurrentCommands(newCommand);
        }
        return list;
    }

    private void saveCurrentCommands(String newCommand) {
        ArrayList<String> newCommands = new ArrayList<String>(this.input);
        if (newCommand != null && !this.input.contains(newCommand)) {
            newCommands.add(newCommand);
        }
        newCommands.remove(NEW_ENTRY_TEXT);
        this.preferenceStore.setValue(this.preferenceKey, StringUtils.join((String)"|", newCommands));
    }

    @Override
    protected void setFilter(String text, IProgressMonitor monitor, boolean updateFilter) {
        if (updateFilter) {
            if (this.fFilterMatcher.lastPattern.equals(text)) {
                return;
            }
            this.fFilterMatcher.setFilter(text);
            if (monitor.isCanceled()) {
                return;
            }
        }
        this.updateFilterEntries(monitor);
        super.setFilter(text, monitor, false);
    }

    @Override
    protected void onFinishUpdateJob() {
        this.updateOKStatus();
    }

    private void updateFilterEntries(IProgressMonitor monitor) {
        this.currentlyAccepted.clear();
        for (String s : this.input) {
            if (NEW_ENTRY_TEXT.equals(s)) continue;
            if (this.fFilterMatcher.match(s)) {
                this.currentlyAccepted.add(s);
            }
            if (!monitor.isCanceled()) continue;
            return;
        }
        if (this.currentlyAccepted.size() == 0) {
            this.currentlyAccepted.add(NEW_ENTRY_TEXT);
        }
    }

    public void setInput(Object input) {
        this.input = (List)input;
        if (this.input.indexOf(NEW_ENTRY_TEXT) == -1) {
            this.input.add(NEW_ENTRY_TEXT);
        }
        super.setInput(input);
        this.updateFilterEntries((IProgressMonitor)new NullProgressMonitor());
    }

    @Override
    protected boolean matchItemToShowInTree(Object element) {
        return this.currentlyAccepted.contains(element);
    }

    private void updateGui() {
        this.setFilter(this.text.getText(), (IProgressMonitor)new NullProgressMonitor(), false);
        this.updateSelectionIfNothingSelected(this.getTreeViewer().getTree());
    }

    private void removeSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.getTreeViewer().getSelection();
        List list = selection.toList();
        for (String s : list) {
            if (NEW_ENTRY_TEXT.equals(s)) continue;
            this.input.remove(s);
        }
        this.saveCurrentCommands(null);
        this.updateGui();
    }
}

