/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.importsconf;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.python.pydev.core.docutils.WrapAndCaseUtils;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.preferences.PydevPrefs;
import org.python.pydev.utils.LabelFieldEditor;

public class ImportsPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public static final String GROUP_IMPORTS = "GROUP_IMPORTS";
    public static final boolean DEFAULT_GROUP_IMPORTS = true;
    public static final String MULTILINE_IMPORTS = "MULTILINE_IMPORTS";
    public static final boolean DEFAULT_MULTILINE_IMPORTS = true;
    public static final String BREAK_IMPORTS_MODE = "BREAK_IMPORTS_MODE";
    public static final String BREAK_IMPORTS_MODE_ESCAPE = "ESCAPE";
    public static final String BREAK_IMPORTS_MODE_PARENTHESIS = "PARENTHESIS";
    public static final String DEFAULT_BREAK_IMPORTS_MODE = "ESCAPE";
    public static boolean groupImportsForTests = true;
    public static boolean multilineImportsForTests = true;
    public static String breakImportModeForTests = "PARENTHESIS";

    public ImportsPreferencesPage() {
        super(0);
        this.setPreferenceStore(PydevPlugin.getDefault().getPreferenceStore());
        this.setDescription("Imports Preferences");
    }

    protected void createFieldEditors() {
        Composite p = this.getFieldEditorParent();
        this.addField(new LabelFieldEditor("Label_Info_File_Preferences1", WrapAndCaseUtils.wrap((String)"These setting are used whenever imports are managed in the application\n\n", (int)80), p));
        this.addField((FieldEditor)new BooleanFieldEditor(GROUP_IMPORTS, "Group 'from' imports when possible?", p));
        this.addField((FieldEditor)new BooleanFieldEditor(MULTILINE_IMPORTS, WrapAndCaseUtils.wrap((String)"Allow multiline imports when the import size would exceed the print margin?", (int)80), p));
        this.addField((FieldEditor)new RadioGroupFieldEditor(BREAK_IMPORTS_MODE, "How to break imports in multiline?", 1, (String[][])new String[][]{{"Use escape char", "ESCAPE"}, {"Use parenthesis", BREAK_IMPORTS_MODE_PARENTHESIS}}, p));
    }

    public void init(IWorkbench workbench) {
    }

    public static boolean getGroupImports() {
        if (PydevPlugin.getDefault() == null) {
            return groupImportsForTests;
        }
        return PydevPrefs.getPreferences().getBoolean(GROUP_IMPORTS);
    }

    public static boolean getMultilineImports() {
        if (PydevPlugin.getDefault() == null) {
            return multilineImportsForTests;
        }
        return PydevPrefs.getPreferences().getBoolean(MULTILINE_IMPORTS);
    }

    public static String getBreakIportMode() {
        if (PydevPlugin.getDefault() == null) {
            return breakImportModeForTests;
        }
        return PydevPrefs.getPreferences().getString(BREAK_IMPORTS_MODE);
    }
}

