/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import java.lang.ref.WeakReference;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.python.pydev.ui.pythonpathconf.AbstractInterpreterEditor;
import org.python.pydev.ui.pythonpathconf.InterpreterInfo;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractListWithNewRemoveControl
extends SelectionAdapter
implements DisposeListener {
    protected Composite box;
    private Button addBt;
    private Button removeBt;
    protected org.eclipse.swt.widgets.List itemsList;
    protected WeakReference<AbstractInterpreterEditor> container;

    protected abstract void removeSelectedFrominfo(InterpreterInfo var1, String[] var2);

    protected abstract List<String> getStringsFromInfo(InterpreterInfo var1);

    protected abstract void addInputToInfo(InterpreterInfo var1, String var2);

    protected abstract String getInput();

    public AbstractListWithNewRemoveControl(AbstractInterpreterEditor container) {
        this.container = new WeakReference<AbstractInterpreterEditor>(container);
    }

    void createTab(String tabLabel, String internalLabel) {
        Composite composite;
        AbstractInterpreterEditor interpreterEditor = (AbstractInterpreterEditor)((Object)this.container.get());
        TabItem tabItem = new TabItem(interpreterEditor.tabFolder, 0);
        tabItem.setText(tabLabel);
        Composite parent = composite = new Composite((Composite)interpreterEditor.tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Link l2 = new Link(parent, 0);
        l2.setText(internalLabel);
        l2.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                Program.launch((String)"http://pydev.org/manual_101_interpreter.html");
            }
        });
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        l2.setLayoutData((Object)gd);
        org.eclipse.swt.widgets.List list = this.getListControl(parent);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 200;
        list.setLayoutData((Object)gd);
        Composite control = this.getButtonBoxControlOthers(parent);
        gd = new GridData();
        gd.verticalAlignment = 1;
        control.setLayoutData((Object)gd);
        tabItem.setControl((Control)composite);
    }

    public Composite getButtonBoxControlOthers(Composite parent) {
        AbstractInterpreterEditor interpreterEditor = (AbstractInterpreterEditor)((Object)this.container.get());
        Assert.isNotNull((Object)((Object)interpreterEditor));
        if (this.box == null) {
            this.box = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.box.setLayout((Layout)layout);
            this.createButtons(interpreterEditor);
            this.box.addDisposeListener((DisposeListener)this);
        } else {
            this.checkParent((Control)this.box, parent);
        }
        return this.box;
    }

    protected void createButtons(AbstractInterpreterEditor interpreterEditor) {
        this.addBt = interpreterEditor.createBt(this.box, "ListEditor.add", (SelectionListener)this);
        this.removeBt = interpreterEditor.createBt(this.box, "ListEditor.remove", (SelectionListener)this);
    }

    public void widgetDisposed(DisposeEvent event) {
        if (this.addBt != null) {
            this.addBt.dispose();
            this.addBt = null;
        }
        if (this.removeBt != null) {
            this.removeBt.dispose();
            this.removeBt = null;
        }
        if (this.box != null) {
            this.box.dispose();
            this.box = null;
        }
    }

    public void widgetSelected(SelectionEvent event) {
        Widget widget = event.widget;
        if (widget == this.addBt) {
            this.addItem();
        } else if (widget == this.removeBt) {
            this.removeItem();
        }
    }

    protected void checkParent(Control control, Composite parent) {
        Assert.isTrue((control.getParent() == parent ? 1 : 0) != 0, (String)"Different parents");
    }

    private org.eclipse.swt.widgets.List getListControl(Composite parent) {
        if (this.itemsList == null) {
            this.itemsList = new org.eclipse.swt.widgets.List(parent, 2818);
            this.itemsList.setFont(parent.getFont());
            this.itemsList.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    AbstractListWithNewRemoveControl.this.itemsList = null;
                }
            });
        } else {
            this.checkParent((Control)this.itemsList, parent);
        }
        return this.itemsList;
    }

    protected void addItem() {
        String item;
        AbstractInterpreterEditor interpreterEditor = (AbstractInterpreterEditor)((Object)this.container.get());
        Assert.isNotNull((Object)((Object)interpreterEditor));
        InterpreterInfo info = interpreterEditor.getSelectedInfo();
        if (info != null && (item = this.getInput()) != null) {
            this.addInputToInfo(info, item);
            interpreterEditor.updateTree();
        }
    }

    protected void removeItem() {
        AbstractInterpreterEditor interpreterEditor = (AbstractInterpreterEditor)((Object)this.container.get());
        Assert.isNotNull((Object)((Object)interpreterEditor));
        InterpreterInfo info = interpreterEditor.getSelectedInfo();
        if (info != null) {
            String[] selected = this.itemsList.getSelection();
            this.removeSelectedFrominfo(info, selected);
            interpreterEditor.updateTree();
        }
    }

    public void removeAllFromList() {
        this.itemsList.removeAll();
    }

    public void update(InterpreterInfo info) {
        List<String> stringsFromInfo = this.getStringsFromInfo(info);
        for (String s : stringsFromInfo) {
            this.itemsList.add(s);
        }
    }
}

