/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.swt.widgets.Composite;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.runners.SimpleRunner;
import org.python.pydev.ui.pythonpathconf.AbstractInterpreterEditor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JythonInterpreterEditor
extends AbstractInterpreterEditor {
    public JythonInterpreterEditor(String labelText, Composite parent, IInterpreterManager interpreterManager) {
        super("JYTHON_INTERPRETER_PATH", labelText, parent, interpreterManager);
    }

    @Override
    public String[] getInterpreterFilterExtensions() {
        return new String[]{"*.jar", "*.*"};
    }

    @Override
    protected Tuple<String, String> getAutoNewInput() {
        try {
            Map<String, String> env = SimpleRunner.getDefaultSystemEnv(null);
            ArrayList<String> pathsToSearch = new ArrayList<String>();
            if (env.containsKey("JYTHON_HOME")) {
                pathsToSearch.add(env.get("JYTHON_HOME"));
            }
            if (env.containsKey("PYTHON_HOME")) {
                pathsToSearch.add(env.get("PYTHON_HOME"));
            }
            if (env.containsKey("JYTHONHOME")) {
                pathsToSearch.add(env.get("JYTHONHOME"));
            }
            if (env.containsKey("PYTHONHOME")) {
                pathsToSearch.add(env.get("PYTHONHOME"));
            }
            if (env.containsKey("PATH")) {
                String path = env.get("PATH");
                String separator = SimpleRunner.getPythonPathSeparator();
                List split = StringUtils.split((String)path, (String)separator);
                pathsToSearch.addAll(split);
            }
            pathsToSearch.add("/usr/bin");
            pathsToSearch.add("/usr/local/bin");
            pathsToSearch.add("/usr/share/java");
            return super.getAutoNewInputFromPaths(pathsToSearch, "jython.jar", "jython");
        }
        catch (CoreException e) {
            PydevPlugin.log(e);
            return null;
        }
    }

    @Override
    protected void doFillIntoGrid(Composite parent, int numColumns) {
        super.doFillIntoGrid(parent, numColumns);
        this.autoConfigButton.setToolTipText("Will try to find Jython on the PATH (will fail if not available)");
    }
}

