/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.utils;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.TableItem;
import org.python.pydev.utils.tablecombo.TableCombo;

public class TableComboFieldEditor
extends FieldEditor {
    protected TableCombo fCombo;
    private String fValue;
    private Object[][] fEntryNamesAndValues;

    public TableComboFieldEditor(String name, String labelText, Object[][] entryNamesAndValues, Composite parent) {
        this.init(name, labelText);
        Assert.isTrue((boolean)this.checkArray(entryNamesAndValues));
        this.fEntryNamesAndValues = entryNamesAndValues;
        this.createControl(parent);
    }

    private boolean checkArray(Object[][] table) {
        if (table == null) {
            return false;
        }
        int i = 0;
        while (i < table.length) {
            Object[] array = table[i];
            if (array == null || array.length != 3) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void adjustForNumColumns(int numColumns) {
        if (numColumns > 1) {
            Label control = this.getLabelControl();
            int left = numColumns;
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
                --left;
            }
            ((GridData)this.fCombo.getLayoutData()).horizontalSpan = left;
        } else {
            Label control = this.getLabelControl();
            if (control != null) {
                ((GridData)control.getLayoutData()).horizontalSpan = 1;
            }
            ((GridData)this.fCombo.getLayoutData()).horizontalSpan = 1;
        }
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        int comboC = 1;
        if (numColumns > 1) {
            comboC = numColumns - 1;
        }
        Object control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = 1;
        control.setLayoutData((Object)gd);
        control = this.getComboBoxControl(parent);
        gd = new GridData();
        gd.horizontalSpan = comboC;
        gd.horizontalAlignment = 4;
        control.setLayoutData((Object)gd);
        control.setFont(parent.getFont());
    }

    protected void doLoad() {
        this.updateComboForValue(this.getPreferenceStore().getString(this.getPreferenceName()));
    }

    protected void doLoadDefault() {
        this.updateComboForValue(this.getPreferenceStore().getDefaultString(this.getPreferenceName()));
    }

    protected void doStore() {
        if (this.fValue == null) {
            this.getPreferenceStore().setToDefault(this.getPreferenceName());
            return;
        }
        this.getPreferenceStore().setValue(this.getPreferenceName(), this.fValue);
    }

    public int getNumberOfControls() {
        return 2;
    }

    protected TableCombo getComboBoxControl(Composite parent) {
        if (this.fCombo == null) {
            this.fCombo = new TableCombo(parent, 2056);
            this.fCombo.setShowTableHeader(false);
            this.fCombo.setFont(parent.getFont());
            this.fCombo.defineColumns(new int[]{100});
            int i = 0;
            while (i < this.fEntryNamesAndValues.length) {
                TableItem tableItem = new TableItem(this.fCombo.getTable(), 0);
                tableItem.setText((String)this.fEntryNamesAndValues[i][0]);
                tableItem.setImage((Image)this.fEntryNamesAndValues[i][2]);
                ++i;
            }
            this.fCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent evt) {
                    String oldValue = TableComboFieldEditor.this.fValue;
                    String name = TableComboFieldEditor.this.fCombo.getText();
                    TableComboFieldEditor.this.fValue = TableComboFieldEditor.this.getValueForName(name);
                    TableComboFieldEditor.this.setPresentsDefaultValue(false);
                    TableComboFieldEditor.this.fireValueChanged("field_editor_value", oldValue, TableComboFieldEditor.this.fValue);
                }
            });
        }
        return this.fCombo;
    }

    private String getValueForName(String name) {
        int i = 0;
        while (i < this.fEntryNamesAndValues.length) {
            Object[] entry = this.fEntryNamesAndValues[i];
            if (name.equals(entry[0])) {
                return (String)entry[1];
            }
            ++i;
        }
        return (String)this.fEntryNamesAndValues[0][0];
    }

    private void updateComboForValue(String value) {
        this.fValue = value;
        int i = 0;
        while (i < this.fEntryNamesAndValues.length) {
            if (value.equals(this.fEntryNamesAndValues[i][1])) {
                this.fCombo.setText((String)this.fEntryNamesAndValues[i][0]);
                return;
            }
            ++i;
        }
        if (this.fEntryNamesAndValues.length > 0) {
            this.fValue = (String)this.fEntryNamesAndValues[0][1];
            this.fCombo.setText((String)this.fEntryNamesAndValues[0][0]);
        }
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getComboBoxControl(parent).setEnabled(enabled);
    }
}

