/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ast.adapters;

import com.rc.retroweaver.runtime.ClassLiteral;
import org.python.pydev.core.REF;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.ast.adapters.AdapterPrefs;
import org.python.pydev.refactoring.ast.adapters.IASTNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.visitors.NodeHelper;
import org.python.pydev.refactoring.ast.visitors.VisitorFactory;
import org.python.pydev.refactoring.ast.visitors.position.IndentVisitor;
import org.python.pydev.refactoring.ast.visitors.position.LastLineVisitor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNodeAdapter<T extends SimpleNode>
implements IASTNodeAdapter<T> {
    private ModuleAdapter module;
    private AbstractScopeNode<? extends SimpleNode> parent;
    private T adaptee;
    protected NodeHelper nodeHelper;
    private AdapterPrefs adapterPrefs;

    protected AbstractNodeAdapter() {
    }

    public AbstractNodeAdapter(ModuleAdapter module, AbstractScopeNode<?> parent, T node, AdapterPrefs adapterPrefs) {
        this.init(module, parent, node, adapterPrefs);
    }

    protected void init(ModuleAdapter module, AbstractScopeNode<?> parent, T node, AdapterPrefs adapterPrefs) {
        this.module = module;
        this.parent = parent;
        this.adaptee = node;
        this.nodeHelper = new NodeHelper(adapterPrefs);
        this.adapterPrefs = adapterPrefs;
    }

    public AdapterPrefs getAdapterPrefs() {
        return this.adapterPrefs;
    }

    @Override
    public T getASTNode() {
        return this.adaptee;
    }

    @Override
    public SimpleNode getASTParent() {
        return this.getParent().getASTNode();
    }

    @Override
    public String getName() {
        return this.nodeHelper.getName((SimpleNode)this.getASTNode());
    }

    @Override
    public int getNodeBodyIndent() {
        IndentVisitor visitor = (IndentVisitor)((Object)VisitorFactory.createVisitor(ClassLiteral.getClass((String)"org/python/pydev/refactoring/ast/visitors/position/IndentVisitor"), this.getASTNode()));
        return visitor.getIndent();
    }

    @Override
    public int getNodeFirstLine() {
        return ((SimpleNode)this.getASTNode()).beginLine;
    }

    public int getLastNodeFirstLineBefore(int beforeLine) {
        T astNode = this.getASTNode();
        int last = ((SimpleNode)astNode).beginLine;
        stmtType[] body = (stmtType[])REF.getAttrObj(astNode, (String)"body");
        if (body != null) {
            int i = 0;
            while (i < body.length) {
                stmtType node = body[i];
                if (!this.nodeHelper.isImport((SimpleNode)node) && !this.nodeHelper.isStr((SimpleNode)node)) {
                    int curr = node.beginLine;
                    if (curr > beforeLine) {
                        return last;
                    }
                    last = curr;
                }
                ++i;
            }
        }
        return last;
    }

    @Override
    public int getNodeIndent() {
        IndentVisitor visitor = (IndentVisitor)((Object)VisitorFactory.createVisitor(ClassLiteral.getClass((String)"org/python/pydev/refactoring/ast/visitors/position/IndentVisitor"), this.getASTNode()));
        return visitor.getIndent();
    }

    @Override
    public int getNodeLastLine() {
        LastLineVisitor visitor = (LastLineVisitor)((Object)VisitorFactory.createVisitor(ClassLiteral.getClass((String)"org/python/pydev/refactoring/ast/visitors/position/LastLineVisitor"), this.getASTNode()));
        return visitor.getLastLine();
    }

    public AbstractScopeNode<? extends SimpleNode> getParent() {
        return this.parent;
    }

    @Override
    public String getParentName() {
        return this.nodeHelper.getName(this.getASTParent());
    }

    @Override
    public SimpleNode getParentNode() {
        return this.getASTParent();
    }

    @Override
    public boolean isModule() {
        return this.getParent() == null;
    }

    @Override
    public ModuleAdapter getModule() {
        return this.module;
    }

    public String toString() {
        return new StringBuffer("Adapter of ").append(this.adaptee).toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.adaptee == null ? 0 : this.adaptee.hashCode());
        result = 31 * result + (this.module == null ? 0 : this.module.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractNodeAdapter other = (AbstractNodeAdapter)obj;
        if (this.adaptee == null ? other.adaptee != null : !this.adaptee.equals(other.adaptee)) {
            return false;
        }
        return !(this.module == null ? other.module != null : !this.module.equals(other.module));
    }

    @Override
    public /* synthetic */ AbstractNodeAdapter getParent() {
        return this.getParent();
    }
}

