/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.codegenerator.overridemethods;

import java.util.ArrayList;
import java.util.List;
import org.python.pydev.refactoring.ast.adapters.AdapterPrefs;
import org.python.pydev.refactoring.ast.adapters.FunctionDefAdapter;
import org.python.pydev.refactoring.ast.adapters.IClassDefAdapter;
import org.python.pydev.refactoring.codegenerator.overridemethods.request.OverrideMethodsRequest;
import org.python.pydev.refactoring.core.model.overridemethods.ClassTreeNode;
import org.python.pydev.refactoring.core.model.overridemethods.FunctionTreeNode;
import org.python.pydev.refactoring.core.request.IRequestProcessor;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OverrideMethodsRequestProcessor
implements IRequestProcessor<OverrideMethodsRequest> {
    private Object[] checked = new Object[0];
    private int insertionPoint = 1;
    private boolean generateMethodComments;
    private IClassDefAdapter origin;
    private AdapterPrefs adapterPrefs;

    public OverrideMethodsRequestProcessor(IClassDefAdapter origin, AdapterPrefs adapterPrefs) {
        this.origin = origin;
        this.adapterPrefs = adapterPrefs;
    }

    public void setCheckedElements(Object[] checked) {
        this.checked = checked;
    }

    public void setInsertionPoint(int strategy) {
        this.insertionPoint = strategy;
    }

    public void setGenerateMethodComments(boolean value) {
        this.generateMethodComments = value;
    }

    @Override
    public List<OverrideMethodsRequest> getRefactoringRequests() {
        ArrayList<OverrideMethodsRequest> requests = new ArrayList<OverrideMethodsRequest>();
        for (ClassTreeNode clazz : this.getClasses()) {
            for (FunctionDefAdapter method : this.getMethods(clazz)) {
                requests.add(new OverrideMethodsRequest(this.origin, this.insertionPoint, method, this.generateMethodComments, ((IClassDefAdapter)clazz.getAdapter()).getName(), this.adapterPrefs));
            }
        }
        return requests;
    }

    private List<FunctionDefAdapter> getMethods(ClassTreeNode parent) {
        ArrayList<FunctionDefAdapter> methods = new ArrayList<FunctionDefAdapter>();
        Object[] objectArray = this.checked;
        int n = this.checked.length;
        int n2 = 0;
        while (n2 < n) {
            FunctionTreeNode method;
            Object obj = objectArray[n2];
            if (obj instanceof FunctionTreeNode && (method = (FunctionTreeNode)obj).getParent() == parent) {
                methods.add((FunctionDefAdapter)method.getAdapter());
            }
            ++n2;
        }
        return methods;
    }

    private List<ClassTreeNode> getClasses() {
        ArrayList<ClassTreeNode> classes = new ArrayList<ClassTreeNode>();
        Object[] objectArray = this.checked;
        int n = this.checked.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof ClassTreeNode) {
                classes.add((ClassTreeNode)obj);
            }
            ++n2;
        }
        return classes;
    }
}

