/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.core.edit;

import org.eclipse.text.edits.TextEdit;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.prettyprinterv2.MakeAstValidForPrettyPrintingVisitor;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.ast.adapters.AdapterPrefs;
import org.python.pydev.refactoring.ast.adapters.IASTNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.ModuleAdapter;
import org.python.pydev.refactoring.ast.factory.PyAstFactory;
import org.python.pydev.refactoring.ast.visitors.NodeHelper;
import org.python.pydev.refactoring.ast.visitors.rewriter.Rewriter;
import org.python.pydev.refactoring.core.request.IExtractMethodRefactoringRequest;
import org.python.pydev.refactoring.core.request.IRefactoringRequest;

public abstract class AbstractTextEdit {
    private static final String WHITESPACE = " ";
    private static final String REPLACE_PATTERN = "\\r\\n|\\n|\\r";
    protected ModuleAdapter moduleAdapter;
    protected IASTNodeAdapter<? extends SimpleNode> offsetAdapter;
    protected NodeHelper nodeHelper;
    protected AdapterPrefs adapterPrefs;
    protected PyAstFactory astFactory;
    private AbstractScopeNode<?> scopeAdapter;

    protected abstract SimpleNode getEditNode() throws MisconfigurationException;

    public abstract TextEdit getEdit() throws MisconfigurationException;

    public abstract int getOffsetStrategy();

    public AbstractTextEdit(IRefactoringRequest req) {
        this.moduleAdapter = req.getOffsetNode().getModule();
        this.offsetAdapter = req.getOffsetNode();
        if (req instanceof IExtractMethodRefactoringRequest) {
            this.scopeAdapter = ((IExtractMethodRefactoringRequest)((Object)req)).getScopeAdapter();
        }
        this.nodeHelper = new NodeHelper(req.getAdapterPrefs());
        this.adapterPrefs = req.getAdapterPrefs();
        this.astFactory = new PyAstFactory(this.nodeHelper.getAdapterPrefs());
    }

    protected String getFormattedNode() throws MisconfigurationException {
        SimpleNode node = this.getEditNode().createCopy();
        try {
            MakeAstValidForPrettyPrintingVisitor.makeValid((SimpleNode)node);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String source = Rewriter.createSourceFromAST(node, this.adapterPrefs);
        return this.getIndentedSource(node, source, this.getIndent());
    }

    private String getIndentedSource(SimpleNode node, String source, int indent) {
        StringBuffer indented = new StringBuffer();
        String indentation = this.getIndentation(indent);
        if (this.nodeHelper.isFunctionDef(node)) {
            indented.append(this.adapterPrefs.endLineDelim);
        }
        indented.append(indentation);
        source = source.replaceAll(REPLACE_PATTERN, String.valueOf(this.adapterPrefs.endLineDelim) + indentation);
        source = source.trim();
        indented.append(source);
        indented.append(this.adapterPrefs.endLineDelim);
        if (this.nodeHelper.isFunctionDef(node)) {
            indented.append(this.adapterPrefs.endLineDelim);
        }
        return indented.toString();
    }

    protected String getIndentation(int indent) {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        while (i < indent) {
            buf.append(WHITESPACE);
            ++i;
        }
        return buf.toString();
    }

    public int getOffset() {
        return this.moduleAdapter.getOffset(this.offsetAdapter, this.getOffsetStrategy(), this.scopeAdapter);
    }

    public int getIndent() {
        return this.offsetAdapter.getNodeBodyIndent();
    }
}

