/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.core.validator;

import java.util.Arrays;
import java.util.List;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.python.pydev.refactoring.ast.adapters.AbstractNodeAdapter;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.ast.adapters.FunctionDefAdapter;
import org.python.pydev.refactoring.messages.Messages;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameValidator {
    private static final List<String> KEYWORDS = Arrays.asList("and", "assert", "break", "class", "continue", "def", "del", "elif", "else", "except", "exec", "finally", "for", "from", "global", "if", "import", "in", "is", "lambda", "not", "or", "pass", "print", "raise", "return", "try", "while", "yield");
    private static final String NAME_PATTERN = "[a-zA-Z_][a-zA-Z_0-9]*";
    private AbstractScopeNode<?> scopeNode;
    private RefactoringStatus status;

    public NameValidator(RefactoringStatus status, AbstractScopeNode<?> scope) {
        this.status = status;
        this.scopeNode = scope;
    }

    public void validateUniqueVariable(String name) {
        if (this.scopeNode.alreadyUsedName(name)) {
            this.status.addWarning(Messages.format(Messages.validationNameAlreadyUsed, name));
        }
    }

    public void validateVariableName(String name) {
        this.validateName(name);
        this.validateNotKeyword(name);
    }

    public void validateMethodName(String name) {
        this.validateName(name);
        this.validateNotKeyword(name);
    }

    private void validateNotKeyword(String name) {
        if (KEYWORDS.contains(name)) {
            this.status.addFatalError(Messages.format(Messages.validationReservedKeyword, name));
        }
    }

    private void validateName(String name) {
        if (name.equals("")) {
            this.status.addFatalError(Messages.validationNameIsEmpty);
            return;
        }
        if (!name.matches(NAME_PATTERN)) {
            this.status.addFatalError(Messages.format(Messages.validationContainsInvalidChars, name));
        }
    }

    public void validateUniqueFunction(String name) {
        AbstractNodeAdapter parentAdapter = this.scopeNode.getParent();
        if (parentAdapter != null) {
            for (FunctionDefAdapter function : ((AbstractScopeNode)parentAdapter).getFunctions()) {
                if (function.getName().compareTo(name) != 0) continue;
                this.status.addWarning(Messages.format(Messages.validationNameAlreadyUsed, name));
            }
        }
    }
}

