/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.ui.pages.extractmethod;

import java.util.List;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.python.pydev.refactoring.ast.adapters.AbstractScopeNode;
import org.python.pydev.refactoring.core.model.OffsetStrategyModel;
import org.python.pydev.refactoring.core.model.OffsetStrategyProvider;
import org.python.pydev.refactoring.core.validator.NameValidator;
import org.python.pydev.refactoring.messages.Messages;
import org.python.pydev.refactoring.ui.core.LabeledEdit;
import org.python.pydev.refactoring.ui.pages.core.SimpleTableItem;
import org.python.pydev.refactoring.ui.pages.extractmethod.VariableCellValidator;
import org.python.pydev.refactoring.ui.pages.listener.ButtonActivationListener;
import org.python.pydev.refactoring.ui.pages.listener.FunctionSignatureListener;
import org.python.pydev.refactoring.ui.pages.listener.IValidationPage;
import org.python.pydev.refactoring.ui.pages.listener.TableCellEditorListener;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractMethodComposite
extends Composite {
    private Label functionPreviewLabel;
    private Label functionSignatureLabel;
    private Label argumentsLabel;
    private Button editArgumentsButton;
    private TableColumn nameColumn;
    private Table argumentsTable;
    private Button downArgumentsButton;
    private Button upArgumentsButton;
    private LabeledEdit functionNameEdit;
    private TableCellEditorListener cellEditorListener;
    private AbstractScopeNode<?> scopeAdapter;
    private IValidationPage page;
    private FunctionSignatureListener signatureListener;
    private OffsetStrategyProvider strategyProvider;
    private ComboViewer methodInsertionComb;
    private CLabel methodInsertionLbl;
    private Composite argumentsComposite;

    public ExtractMethodComposite(IValidationPage page, Composite parent, boolean hasArguments, AbstractScopeNode<?> scope) {
        super(parent, 0);
        this.page = page;
        this.scopeAdapter = scope;
        this.strategyProvider = new OffsetStrategyProvider(this.scopeAdapter, 15);
        this.createComposite(hasArguments);
    }

    public void createComposite(boolean hasArguments) {
        this.setLayout((Layout)new GridLayout());
        this.createFunctionName(this);
        if (hasArguments) {
            this.createArguments(this);
        }
        this.createOffsetStrategy(this);
        this.createFunctionSignature(this);
        this.pack();
    }

    private void createFunctionSignature(Composite control) {
        Composite functionSignatureComposite = new Composite(control, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.makeColumnsEqualWidth = true;
        GridData compositeLData = new GridData();
        compositeLData.horizontalAlignment = 4;
        compositeLData.grabExcessHorizontalSpace = true;
        functionSignatureComposite.setLayoutData((Object)compositeLData);
        functionSignatureComposite.setLayout((Layout)compositeLayout);
        this.functionSignatureLabel = new Label(functionSignatureComposite, 0);
        GridData labelLData = new GridData();
        labelLData.horizontalAlignment = 4;
        labelLData.grabExcessHorizontalSpace = true;
        this.functionSignatureLabel.setLayoutData((Object)labelLData);
        this.functionSignatureLabel.setText(Messages.extractMethodFunctionPreview);
        this.functionPreviewLabel = new Label(functionSignatureComposite, 0);
        GridData functionSignaturePreviewData = new GridData();
        functionSignaturePreviewData.horizontalAlignment = 4;
        functionSignaturePreviewData.grabExcessHorizontalSpace = true;
        functionSignaturePreviewData.verticalAlignment = 4;
        functionSignaturePreviewData.grabExcessVerticalSpace = true;
        this.functionPreviewLabel.setLayoutData((Object)functionSignaturePreviewData);
        this.functionPreviewLabel.setText("");
    }

    private Button createButton(Composite parent, String name) {
        Button button = new Button(parent, 0x1000008);
        GridData buttonLData = new GridData();
        buttonLData.horizontalAlignment = 4;
        buttonLData.grabExcessHorizontalSpace = true;
        button.setLayoutData((Object)buttonLData);
        button.setText(name);
        return button;
    }

    private void createArguments(Composite control) {
        this.argumentsComposite = new Composite(control, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.makeColumnsEqualWidth = true;
        GridData compositeLData = new GridData();
        compositeLData.grabExcessHorizontalSpace = true;
        compositeLData.horizontalAlignment = 4;
        compositeLData.grabExcessVerticalSpace = true;
        compositeLData.verticalAlignment = 4;
        this.argumentsComposite.setLayoutData((Object)compositeLData);
        this.argumentsComposite.setLayout((Layout)compositeLayout);
        this.createArgumentsLabel(this.argumentsComposite);
        this.createArgumentsTable(this.argumentsComposite);
    }

    private void createArgumentsButton(Composite argumentsTableComposite) {
        Composite argumentsButtonComposite = new Composite(argumentsTableComposite, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.makeColumnsEqualWidth = true;
        FormData compositeLData = new FormData(0, 0);
        compositeLData.width = 80;
        compositeLData.bottom = new FormAttachment(1000, 1000, 0);
        compositeLData.right = new FormAttachment(1000, 1000, 0);
        compositeLData.top = new FormAttachment(0, 1000, 0);
        argumentsButtonComposite.setLayoutData((Object)compositeLData);
        argumentsButtonComposite.setLayout((Layout)compositeLayout);
        this.editArgumentsButton = this.createButton(argumentsButtonComposite, Messages.extractMethodEditButton);
        this.editArgumentsButton.setEnabled(false);
        this.upArgumentsButton = this.createButton(argumentsButtonComposite, Messages.extractMethodUpButton);
        this.upArgumentsButton.setEnabled(false);
        this.downArgumentsButton = this.createButton(argumentsButtonComposite, Messages.extractMethodDownButton);
        this.downArgumentsButton.setEnabled(false);
    }

    private void registerDownButtonListener() {
        this.downArgumentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                int selectionIndex = ExtractMethodComposite.this.argumentsTable.getSelectionIndex();
                if (ExtractMethodComposite.this.argumentsTable.getSelectionCount() == 1 && selectionIndex != ExtractMethodComposite.this.argumentsTable.getItemCount() && (item = ExtractMethodComposite.this.argumentsTable.getSelection()[0]) instanceof SimpleTableItem) {
                    SimpleTableItem tableItem = (SimpleTableItem)item;
                    new SimpleTableItem(ExtractMethodComposite.this.argumentsTable, tableItem.getOriginalName(), tableItem.getText(), selectionIndex + 2);
                    ExtractMethodComposite.this.argumentsTable.remove(selectionIndex);
                    ExtractMethodComposite.this.argumentsTable.setSelection(selectionIndex + 1);
                    ExtractMethodComposite.this.argumentsTable.notifyListeners(13, new Event());
                    ExtractMethodComposite.this.page.validate();
                }
            }
        });
    }

    private void registerUpButtonListener() {
        this.upArgumentsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem item;
                int selectionIndex = ExtractMethodComposite.this.argumentsTable.getSelectionIndex();
                if (ExtractMethodComposite.this.argumentsTable.getSelectionCount() == 1 && selectionIndex > 0 && (item = ExtractMethodComposite.this.argumentsTable.getSelection()[0]) instanceof SimpleTableItem) {
                    SimpleTableItem tableItem = (SimpleTableItem)item;
                    new SimpleTableItem(ExtractMethodComposite.this.argumentsTable, tableItem.getOriginalName(), tableItem.getText(), selectionIndex - 1);
                    ExtractMethodComposite.this.argumentsTable.remove(selectionIndex + 1);
                    ExtractMethodComposite.this.argumentsTable.setSelection(selectionIndex - 1);
                    ExtractMethodComposite.this.argumentsTable.notifyListeners(13, new Event());
                    ExtractMethodComposite.this.page.validate();
                }
            }
        });
    }

    private Composite createArgumentsTable(Composite parent) {
        Composite argumentsComposite = new Composite(parent, 0);
        FormLayout compositeLayout = new FormLayout();
        GridData compositeLData = new GridData(1808);
        argumentsComposite.setLayoutData((Object)compositeLData);
        argumentsComposite.setLayout((Layout)compositeLayout);
        this.argumentsTable = new Table(argumentsComposite, 67584);
        FormData tableLData = new FormData();
        tableLData.bottom = new FormAttachment(1000, 1000, 0);
        tableLData.left = new FormAttachment(0, 1000, 0);
        tableLData.right = new FormAttachment(1000, 1000, -80);
        tableLData.top = new FormAttachment(0, 1000, 4);
        this.argumentsTable.setLayoutData((Object)tableLData);
        this.argumentsTable.setHeaderVisible(true);
        this.argumentsTable.setLinesVisible(true);
        this.nameColumn = new TableColumn(this.argumentsTable, 0);
        this.nameColumn.setText(Messages.extractMethodArgumentName);
        this.createArgumentsButton(argumentsComposite);
        argumentsComposite.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle area = ExtractMethodComposite.this.argumentsTable.getClientArea();
                Point preferredSize = ExtractMethodComposite.this.argumentsTable.computeSize(-1, -1);
                int width = area.width - 2 * ExtractMethodComposite.this.argumentsTable.getBorderWidth();
                if (preferredSize.y > area.height + ExtractMethodComposite.this.argumentsTable.getHeaderHeight()) {
                    Point vBarSize = ExtractMethodComposite.this.argumentsTable.getVerticalBar().getSize();
                    width -= vBarSize.x;
                }
                Point oldSize = ExtractMethodComposite.this.argumentsTable.getSize();
                if (oldSize.x > area.width) {
                    ExtractMethodComposite.this.nameColumn.setWidth(width);
                    ExtractMethodComposite.this.argumentsTable.setSize(area.width, area.height);
                } else {
                    ExtractMethodComposite.this.argumentsTable.setSize(area.width, area.height);
                    ExtractMethodComposite.this.nameColumn.setWidth(width);
                }
            }
        });
        argumentsComposite.notifyListeners(262144, new Event());
        return argumentsComposite;
    }

    private void createArgumentsLabel(Composite argumentsComposite) {
        this.argumentsLabel = new Label(argumentsComposite, 0);
        GridData labelLData = new GridData();
        labelLData.grabExcessHorizontalSpace = true;
        labelLData.horizontalAlignment = 4;
        this.argumentsLabel.setLayoutData((Object)labelLData);
        this.argumentsLabel.setText(Messages.extractMethodArgumentsTitle);
    }

    private void createFunctionName(Composite control) {
        Composite methodNameComposite = new Composite(control, 0);
        FillLayout compositeLayout = new FillLayout(256);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        methodNameComposite.setLayoutData((Object)gridData);
        methodNameComposite.setLayout((Layout)compositeLayout);
        this.functionNameEdit = new LabeledEdit(methodNameComposite, Messages.extractMethodFunctionTitle);
    }

    private void createOffsetStrategy(Composite mainComp) {
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 512;
        GridData gridData7 = new GridData();
        gridData7.horizontalSpan = 2;
        gridData7.verticalAlignment = 2;
        gridData7.grabExcessHorizontalSpace = true;
        gridData7.horizontalAlignment = 4;
        Composite comboComp = new Composite(mainComp, 0);
        comboComp.setLayoutData((Object)gridData7);
        comboComp.setLayout((Layout)fillLayout);
        this.methodInsertionLbl = new CLabel(comboComp, 0);
        this.methodInsertionLbl.setText(Messages.offsetStrategyInsertionPointMethod);
        this.methodInsertionComb = this.createComboViewer(comboComp);
        this.methodInsertionComb.getCombo().select(0);
    }

    private ComboViewer createComboViewer(Composite comboComp) {
        ComboViewer v = new ComboViewer(comboComp);
        v.setContentProvider((IContentProvider)this.strategyProvider);
        v.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        v.setInput((Object)"");
        return v;
    }

    public LabeledEdit getFunctionNameEdit() {
        return this.functionNameEdit;
    }

    public Label getSignaturePreview() {
        return this.functionPreviewLabel;
    }

    public Table getArgumentsTable() {
        return this.argumentsTable;
    }

    public Button getUpButton() {
        return this.upArgumentsButton;
    }

    public Button getDownButton() {
        return this.downArgumentsButton;
    }

    public Button getEditButton() {
        return this.editArgumentsButton;
    }

    public void registerListeners(final IValidationPage page) {
        this.signatureListener = new FunctionSignatureListener(page, this.getSignaturePreview(), this.getFunctionNameEdit(), this.getArgumentsTable());
        this.functionNameEdit.getEdit().addListener(24, (Listener)page);
        this.functionNameEdit.getEdit().addListener(24, (Listener)this.signatureListener);
        ButtonActivationListener buttonActivationListener = new ButtonActivationListener(this.getArgumentsTable(), this.getUpButton(), this.getDownButton(), this.getEditButton());
        if (this.argumentsTable != null) {
            this.cellEditorListener = new TableCellEditorListener(page, this.argumentsTable);
            this.argumentsTable.addListener(8, (Listener)this.cellEditorListener);
            this.argumentsTable.addListener(14, (Listener)this.cellEditorListener);
            this.argumentsTable.addListener(13, (Listener)buttonActivationListener);
            this.argumentsTable.addListener(13, (Listener)this.signatureListener);
            this.editArgumentsButton.addListener(13, (Listener)this.cellEditorListener);
            this.registerUpButtonListener();
            this.registerDownButtonListener();
        }
        this.methodInsertionComb.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                if (!sel.isEmpty()) {
                    page.validate();
                }
            }
        });
    }

    public void initTable(List<String> arguments) {
        for (String argument : arguments) {
            new SimpleTableItem(this.getArgumentsTable(), argument);
        }
    }

    public Composite getArgumentsComposite() {
        return this.argumentsComposite;
    }

    public String getFunctionName() {
        return this.getFunctionNameEdit().getEdit().getText();
    }

    public int getOffsetStrategy() {
        IStructuredSelection sel = (IStructuredSelection)this.methodInsertionComb.getSelection();
        if (!sel.isEmpty()) {
            OffsetStrategyModel elem = (OffsetStrategyModel)((Object)sel.getFirstElement());
            return elem.getStrategy();
        }
        return this.strategyProvider.get(0).getStrategy();
    }

    public boolean validate() {
        if (this.argumentsTable != null) {
            VariableCellValidator cellValidator = new VariableCellValidator(this.page, this.getArgumentsTable(), this.scopeAdapter);
            cellValidator.validate();
        }
        RefactoringStatus status = new RefactoringStatus();
        NameValidator nameValidator = new NameValidator(status, this.scopeAdapter);
        nameValidator.validateMethodName(this.getFunctionName());
        nameValidator.validateUniqueFunction(this.getFunctionName());
        if (status.hasError()) {
            this.page.setErrorMessage(status.getMessageMatchingSeverity(2));
        }
        return !status.hasError();
    }
}

