/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.refactoring.utils;

import com.rc.retroweaver.runtime.Autobox;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestUtils {
    private static final Pattern CURSOR_PATTERN = Pattern.compile("##\\|");
    private static final String CURSOR = "##|";

    private TestUtils() {
    }

    public static List<Marker> getMarkers(String sourceCode) {
        LinkedList<Marker> markers = new LinkedList<Marker>();
        String[] lines = sourceCode.split("\n");
        int beginLine = 0;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            ++beginLine;
            int pos = (line = line.trim()).indexOf("##");
            if (pos >= 0) {
                StringTokenizer tok = new StringTokenizer(line.substring(pos + 2));
                String test = tok.nextToken();
                if ("exit".equals(test)) break;
                if ("type".equals(test)) {
                    String type = tok.nextToken();
                    String expr = line.substring(0, line.indexOf("##")).trim();
                    markers.add(new Marker(beginLine, expr, type));
                }
            }
            ++n2;
        }
        return markers;
    }

    public static Cursors findCursors(String input) {
        int index;
        LinkedList<Integer> positions = new LinkedList<Integer>();
        String text = input;
        while ((index = text.indexOf(CURSOR)) >= 0) {
            positions.add(Autobox.valueOf((int)index));
            text = CURSOR_PATTERN.matcher(text).replaceFirst("");
        }
        return new Cursors(text, positions);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Cursors {
        public final String text;
        public final List<Integer> positions;

        public Cursors(String text, List<Integer> positions) {
            this.text = text;
            this.positions = positions;
        }
    }

    public static final class Marker {
        public final int beginLine;
        public final String expr;
        public final String type;

        public Marker(int beginLine, String expr, String type) {
            this.beginLine = beginLine;
            this.expr = expr;
            this.type = type;
        }
    }
}

