/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.bundle;

import com.rc.retroweaver.runtime.Autobox;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.core.Tuple3;
import org.python.pydev.core.Tuple4;
import org.python.pydev.core.log.Log;

public class ImageCache {
    private Map<Object, Image> imageHash = new HashMap<Object, Image>(10);
    private Map<Object, ImageDescriptor> descriptorHash = new HashMap<Object, ImageDescriptor>(10);
    private ImageDecorator imageDecorator = new ImageDecorator();
    private URL baseURL;
    private Image missing = null;
    private Object lock = new Object();
    private Object descriptorLock = new Object();
    public static final int DECORATION_LOCATION_TOP_RIGHT = 0;
    public static final int DECORATION_LOCATION_BOTTOM_RIGHT = 1;

    public ImageCache(URL baseURL) {
        this.baseURL = baseURL;
    }

    protected ImageCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.lock;
        synchronized (object) {
            Iterator<Image> e = this.imageHash.values().iterator();
            while (e.hasNext()) {
                e.next().dispose();
            }
            if (this.missing != null) {
                this.missing.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Image get(String key) {
        Object object = this.lock;
        synchronized (object) {
            Image image = this.imageHash.get(key);
            if (image != null) return image;
            try {
                ImageDescriptor desc = this.getDescriptor(key);
                image = desc.createImage();
                this.imageHash.put(key, image);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
                return null;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                return null;
            }
            catch (Exception exception) {
                Log.log("ERROR: Missing image: " + key);
                if (this.missing != null) return this.missing;
                ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
                this.missing = desc.createImage();
                return this.missing;
            }
            return image;
        }
    }

    public Image getImageDecorated(String key, String decoration) {
        return this.getImageDecorated(key, decoration, 0);
    }

    public Image getImageDecorated(String key, String decoration, int decorationLocation) {
        return this.getImageDecorated(key, decoration, decorationLocation, null, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getImageDecorated(String key, String decoration, int decorationLocation, String secondDecoration, int secondDecorationLocation) {
        Object object = this.lock;
        synchronized (object) {
            Image image;
            Serializable cacheKey = new Tuple4<String, String, Integer, String>(key, decoration, Autobox.valueOf((int)decorationLocation), "imageDecoration");
            if (secondDecoration != null) {
                cacheKey = new Tuple3<Tuple4<String, String, Integer, String>, String, Integer>((Tuple4<String, String, Integer, String>)cacheKey, secondDecoration, Autobox.valueOf((int)secondDecorationLocation));
            }
            if ((image = this.imageHash.get(cacheKey)) == null) {
                Display display = Display.getCurrent();
                ImageData baseImageData = this.get(key).getImageData();
                image = this.decorateImage(decoration, decorationLocation, display, baseImageData);
                if (secondDecoration != null) {
                    image = this.decorateImage(secondDecoration, secondDecorationLocation, display, image.getImageData());
                }
                this.imageHash.put(cacheKey, image);
            }
            return image;
        }
    }

    private Image decorateImage(String decoration, int decorationLocation, Display display, ImageData baseImageData) throws AssertionError {
        ImageData imageData;
        ImageData decorationImageData = this.get(decoration).getImageData();
        switch (decorationLocation) {
            case 0: {
                imageData = this.imageDecorator.drawDecoration(baseImageData, decorationImageData, baseImageData.width - decorationImageData.width, 0);
                break;
            }
            case 1: {
                imageData = this.imageDecorator.drawDecoration(baseImageData, decorationImageData, baseImageData.width - decorationImageData.width, baseImageData.height - decorationImageData.height);
                break;
            }
            default: {
                throw new AssertionError((Object)("Decoration location not recognized: " + decorationLocation));
            }
        }
        Image image = new Image((Device)display, imageData);
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image getStringDecorated(String key, String stringToAddToDecoration) {
        Object object = this.lock;
        synchronized (object) {
            Image image;
            block9: {
                Tuple3<String, String, String> cacheKey = new Tuple3<String, String, String>(key, stringToAddToDecoration, "stringDecoration");
                image = this.imageHash.get(cacheKey);
                if (image == null) {
                    Display display = Display.getCurrent();
                    image = new Image((Device)display, this.get(key), 0);
                    this.imageHash.put(cacheKey, image);
                    int base = 10;
                    GC gc = new GC((Drawable)image);
                    Color colorBackground = new Color((Device)display, 255, 255, 255);
                    Color colorForeground = new Color((Device)display, 0, 83, 41);
                    Font font = new Font((Device)display, new FontData("Courier New", base - 1, 1));
                    try {
                        try {
                            gc.setForeground(colorForeground);
                            gc.setBackground(colorBackground);
                            gc.setTextAntialias(1);
                            gc.setFont(font);
                            gc.drawText(stringToAddToDecoration, 5, 0, true);
                        }
                        catch (Exception e) {
                            Log.log(e);
                            colorBackground.dispose();
                            colorForeground.dispose();
                            font.dispose();
                            gc.dispose();
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        colorBackground.dispose();
                        colorForeground.dispose();
                        font.dispose();
                        gc.dispose();
                        throw throwable;
                    }
                    colorBackground.dispose();
                    colorForeground.dispose();
                    font.dispose();
                    gc.dispose();
                }
            }
            return image;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImageDescriptor getDescriptor(String key) {
        Object object = this.descriptorLock;
        synchronized (object) {
            if (!this.descriptorHash.containsKey(key)) {
                ImageDescriptor desc;
                try {
                    URL url = new URL(this.baseURL, key);
                    desc = ImageDescriptor.createFromURL((URL)url);
                }
                catch (MalformedURLException malformedURLException) {
                    Log.log("ERROR: Missing image: " + key);
                    desc = ImageDescriptor.getMissingImageDescriptor();
                }
                this.descriptorHash.put(key, desc);
                return desc;
            }
            return this.descriptorHash.get(key);
        }
    }

    private static final class ImageDecorator
    extends CompositeImageDescriptor {
        private Point size;
        private ImageData base;
        private ImageData decoration;
        private int ox;
        private int oy;

        private ImageDecorator() {
        }

        protected Point getSize() {
            return this.size;
        }

        protected void drawCompositeImage(int width, int height) {
            this.drawImage(this.base, 0, 0);
            this.drawImage(this.decoration, this.ox, this.oy);
        }

        public final ImageData drawDecoration(ImageData base, ImageData decoration, int ox, int oy) {
            this.size = new Point(base.width, base.height);
            this.base = base;
            this.decoration = decoration;
            this.ox = ox;
            this.oy = oy;
            return this.getImageData();
        }
    }
}

