/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.docutils;

import java.util.Iterator;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.docutils.ImportHandle;
import org.python.pydev.core.docutils.PyDocIterator;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.docutils.StringUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyImportsIterator
implements Iterator<ImportHandle> {
    private PyDocIterator docIterator;
    private boolean hasNext = true;
    private ImportHandle nextImport;
    private String delimiter;
    private IDocument doc;
    private boolean addOnlyGlobalImports;

    public PyImportsIterator(IDocument doc) {
        this(doc, true);
    }

    public PyImportsIterator(IDocument doc, boolean addOnlyGlobalImports) {
        this.doc = doc;
        this.addOnlyGlobalImports = addOnlyGlobalImports;
        this.delimiter = PySelection.getDelimiter(doc);
        this.docIterator = new PyDocIterator(doc, false, false, false, true);
        this.calcNext();
    }

    private void calcNext() {
        if (!this.hasNext) {
            return;
        }
        String importFound = null;
        int startFoundLine = -1;
        int endFoundLine = -1;
        while (this.docIterator.hasNext()) {
            boolean match;
            String str = this.docIterator.next();
            if (this.addOnlyGlobalImports) {
                match = str.startsWith("import ") || str.startsWith("from ");
            } else {
                boolean bl = match = (str = StringUtils.leftTrim(str)).startsWith("import ") || str.startsWith("from ");
            }
            if (!match) continue;
            startFoundLine = this.docIterator.getLastReturnedLine();
            if (str.indexOf(40) != -1) {
                while (this.docIterator.hasNext() && str.indexOf(41) == -1) {
                    str = new StringBuffer(String.valueOf(str)).append(this.delimiter).append(this.docIterator.next()).toString();
                }
            }
            if (StringUtils.endsWith(str, '\\')) {
                while (this.docIterator.hasNext() && StringUtils.endsWith(str, '\\')) {
                    str = new StringBuffer(String.valueOf(str)).append(this.delimiter).append(this.docIterator.next()).toString();
                }
            }
            importFound = str;
            endFoundLine = this.docIterator.getLastReturnedLine();
            break;
        }
        this.hasNext = importFound != null;
        this.nextImport = this.hasNext ? new ImportHandle(this.doc, importFound, startFoundLine, endFoundLine) : null;
    }

    @Override
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    public ImportHandle next() {
        ImportHandle ret = this.nextImport;
        this.calcNext();
        return ret;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public /* synthetic */ Object next() {
        return this.next();
    }
}

