/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.tooltips.presenter;

import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.python.pydev.core.tooltips.presenter.IInformationPresenterAsTooltip;
import org.python.pydev.core.tooltips.presenter.IInformationPresenterControlManager;
import org.python.pydev.core.tooltips.presenter.ITooltipInformationProvider;
import org.python.pydev.core.tooltips.presenter.InformationPresenterControlManager;

public class ToolTipPresenterHandler {
    public static final String TIP_DATA = "TIP_DATA";
    private Shell tipShell;
    private Label tipLabelImage;
    private Label tipLabelText;
    private Widget tipWidget;
    private IInformationPresenterControlManager tooltip;
    private DefaultInformationControl.IInformationPresenter presenter;

    public ToolTipPresenterHandler(Shell parent) {
        this(parent, null);
    }

    public ToolTipPresenterHandler(Shell parent, DefaultInformationControl.IInformationPresenter presenter) {
        Display display = parent.getDisplay();
        this.tipShell = new Shell(parent, 16388);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.marginWidth = 2;
        gridLayout.marginHeight = 2;
        this.tipShell.setLayout((Layout)gridLayout);
        this.tipShell.setBackground(display.getSystemColor(29));
        this.tipLabelImage = new Label((Composite)this.tipShell, 0);
        this.tipLabelImage.setForeground(display.getSystemColor(28));
        this.tipLabelImage.setBackground(display.getSystemColor(29));
        this.tipLabelImage.setLayoutData((Object)new GridData(772));
        this.tipLabelText = new Label((Composite)this.tipShell, 0);
        this.tipLabelText.setForeground(display.getSystemColor(28));
        this.tipLabelText.setBackground(display.getSystemColor(29));
        this.tipLabelText.setLayoutData((Object)new GridData(772));
        this.tooltip = new InformationPresenterControlManager(presenter);
        this.presenter = presenter;
    }

    public void install(Control control) {
        this.tooltip.install(control);
        control.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (ToolTipPresenterHandler.this.tipShell.isVisible()) {
                    ToolTipPresenterHandler.this.tipShell.setVisible(false);
                }
            }
        });
        control.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                if (ToolTipPresenterHandler.this.tipShell.isVisible()) {
                    ToolTipPresenterHandler.this.tipShell.setVisible(false);
                }
                ToolTipPresenterHandler.this.tipWidget = null;
            }

            public void mouseHover(MouseEvent event) {
                ToolBar w;
                Point pt = new Point(event.x, event.y);
                Widget widget = event.widget;
                if (widget instanceof ToolBar) {
                    w = (ToolBar)widget;
                    widget = w.getItem(pt);
                }
                if (widget instanceof Table) {
                    w = (Table)widget;
                    widget = w.getItem(pt);
                }
                if (widget instanceof Tree) {
                    w = (Tree)widget;
                    widget = w.getItem(pt);
                }
                if (widget == null) {
                    ToolTipPresenterHandler.this.tipShell.setVisible(false);
                    ToolTipPresenterHandler.this.tipWidget = null;
                    return;
                }
                if (widget == ToolTipPresenterHandler.this.tipWidget) {
                    return;
                }
                ToolTipPresenterHandler.this.tipWidget = widget;
                Object data = widget.getData(ToolTipPresenterHandler.TIP_DATA);
                if (data == null) {
                    return;
                }
                final String text = data instanceof String ? (String)data : data.toString();
                if (text == null) {
                    return;
                }
                final Point pos = new Point(pt.x + 10, pt.y);
                ITooltipInformationProvider provider = new ITooltipInformationProvider(){

                    public Object getInformation(Control fControl) {
                        return text;
                    }

                    public Point getPosition(Control fControl) {
                        return pos;
                    }
                };
                if (ToolTipPresenterHandler.this.presenter instanceof IInformationPresenterAsTooltip) {
                    IInformationPresenterAsTooltip iInformationPresenterAsTooltip = (IInformationPresenterAsTooltip)ToolTipPresenterHandler.this.presenter;
                    iInformationPresenterAsTooltip.setData(data);
                }
                ToolTipPresenterHandler.this.tooltip.setInformationProvider(provider);
                ToolTipPresenterHandler.this.tooltip.showInformation();
            }
        });
    }
}

