/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.ui.hierarchy;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.util.Assert;
import org.python.pydev.core.IModule;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.visitors.NodeUtils;

public class HierarchyNodeModel {
    public String name;
    public List<HierarchyNodeModel> parents = new ArrayList<HierarchyNodeModel>();
    public List<HierarchyNodeModel> children = new ArrayList<HierarchyNodeModel>();
    public String moduleName;
    public ClassDef ast;
    public IModule module;

    public HierarchyNodeModel(String name) {
        this(name, "default", null);
    }

    public HierarchyNodeModel(String pack, ClassDef ast) {
        this(NodeUtils.getRepresentationString((SimpleNode)ast), pack, ast);
    }

    public HierarchyNodeModel(String name, String pack, ClassDef ast) {
        Assert.isNotNull((Object)name);
        this.name = name;
        this.moduleName = pack;
        this.ast = ast;
    }

    public HierarchyNodeModel(IModule module, ClassDef def) {
        this(module.getName(), def);
        this.module = module;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        HierarchyNodeModel h = (HierarchyNodeModel)obj;
        return this.name.equals(h.name) && this.moduleName.equals(h.moduleName);
    }

    public String toString() {
        return "HierarchyNodeModel[" + this.name + " - " + this.moduleName + "]";
    }
}

