/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.nodes;

import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PPaintContext;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class PImage
extends PNode {
    public static final String PROPERTY_IMAGE = "image";
    public static final int PROPERTY_CODE_IMAGE = 32768;
    private transient Image image;

    public PImage() {
    }

    public PImage(Image newImage) {
        this();
        this.setImage(newImage);
    }

    public PImage(String fileName) {
        this(Toolkit.getDefaultToolkit().getImage(fileName));
    }

    public PImage(URL url) {
        this();
        if (url != null) {
            this.setImage(Toolkit.getDefaultToolkit().getImage(url));
        }
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(String fileName) {
        this.setImage(Toolkit.getDefaultToolkit().getImage(fileName));
    }

    public void setImage(Image newImage) {
        Image old = this.image;
        if (newImage instanceof BufferedImage) {
            this.image = newImage;
        } else {
            ImageIcon imageLoader = new ImageIcon(newImage);
            switch (imageLoader.getImageLoadStatus()) {
                case 1: {
                    System.err.println("media tracker still loading image after requested to wait until finished");
                }
                case 8: {
                    this.image = imageLoader.getImage();
                    break;
                }
                case 2: {
                    System.err.println("media tracker aborted image load");
                    this.image = null;
                    break;
                }
                case 4: {
                    System.err.println("media tracker errored image load");
                    this.image = null;
                }
            }
        }
        if (this.image != null) {
            this.setBounds(0.0, 0.0, this.getImage().getWidth(null), this.getImage().getHeight(null));
            this.invalidatePaint();
        } else {
            this.image = null;
        }
        this.firePropertyChange(32768, PROPERTY_IMAGE, old, this.image);
    }

    protected void paint(PPaintContext paintContext) {
        if (this.getImage() != null) {
            double iw = this.image.getWidth(null);
            double ih = this.image.getHeight(null);
            PBounds b = this.getBoundsReference();
            Graphics2D g2 = paintContext.getGraphics();
            if (b.x != 0.0 || b.y != 0.0 || b.width != iw || b.height != ih) {
                g2.translate(b.x, b.y);
                g2.scale(b.width / iw, b.height / ih);
                g2.drawImage(this.image, 0, 0, null);
                g2.scale(iw / b.width, ih / b.height);
                g2.translate(-b.x, -b.y);
            } else {
                g2.drawImage(this.image, 0, 0, null);
            }
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        BufferedImage bufferedImage = PImage.toBufferedImage(this.image, false);
        if (bufferedImage != null) {
            ImageIO.write((RenderedImage)bufferedImage, "png", out);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.image = ImageIO.read(in);
    }

    public static BufferedImage toBufferedImage(Image image, boolean alwaysCreateCopy) {
        if (image == null) {
            return null;
        }
        if (!alwaysCreateCopy && image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        GraphicsConfiguration graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        BufferedImage result = graphicsConfiguration.createCompatibleImage(image.getWidth(null), image.getHeight(null));
        Graphics2D g2 = result.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return result;
    }

    protected String paramString() {
        StringBuffer result = new StringBuffer();
        result.append("image=" + (this.image == null ? "null" : this.image.toString()));
        result.append(',');
        result.append(super.paramString());
        return result.toString();
    }
}

