/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolox.swt;

import edu.umd.cs.piccolox.swt.SWTShapeManager;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class SWTGraphics2D
extends Graphics2D {
    protected static int CACHE_COUNT = 0;
    protected static HashMap FONT_CACHE = new HashMap();
    protected static HashMap COLOR_CACHE = new HashMap();
    protected static HashMap SHAPE_CACHE = new HashMap();
    protected static BufferedImage BUFFER = new BufferedImage(1, 1, 2);
    static java.awt.Point PT = new java.awt.Point();
    static Rectangle2D RECT = new Rectangle2D.Double();
    static Rectangle2D LINE_RECT = new Rectangle2D.Double();
    static org.eclipse.swt.graphics.Rectangle SWT_RECT = new org.eclipse.swt.graphics.Rectangle(0, 0, 0, 0);
    protected GC gc;
    protected Device device;
    protected AffineTransform transform = new AffineTransform();
    protected org.eclipse.swt.graphics.Font curFont;
    protected double lineWidth = 1.0;

    public SWTGraphics2D(GC gc, Device device) {
        this.gc = gc;
        this.device = device;
    }

    public Rectangle getClipBounds() {
        org.eclipse.swt.graphics.Rectangle rect = this.gc.getClipping();
        Rectangle aRect = new Rectangle(rect.x, rect.y, rect.width, rect.height);
        try {
            SWTShapeManager.transform(aRect, this.transform.createInverse());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aRect;
    }

    public void clipRect(int x, int y, int width, int height) {
        RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(RECT, this.transform);
        SWTShapeManager.awtToSWT(RECT, SWT_RECT);
        org.eclipse.swt.graphics.Rectangle clip = this.gc.getClipping();
        clip = clip.intersection(SWT_RECT);
        this.gc.setClipping(clip);
    }

    public void setClip(int x, int y, int width, int height) {
        RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(RECT, this.transform);
        SWTShapeManager.awtToSWT(RECT, SWT_RECT);
        this.gc.setClipping(SWT_RECT);
    }

    public void clip(Shape s) {
        Rectangle2D clipBds = s.getBounds2D();
        SWTShapeManager.transform(clipBds, this.transform);
        SWTShapeManager.awtToSWT(clipBds, SWT_RECT);
        org.eclipse.swt.graphics.Rectangle clip = this.gc.getClipping();
        clip = clip.intersection(SWT_RECT);
        this.gc.setClipping(SWT_RECT);
    }

    public void setClip(Shape clip) {
        if (clip == null) {
            this.gc.setClipping(null);
        } else {
            Rectangle2D clipBds = clip.getBounds2D();
            SWTShapeManager.transform(clipBds, this.transform);
            SWTShapeManager.awtToSWT(clipBds, SWT_RECT);
            this.gc.setClipping(SWT_RECT);
        }
    }

    public Shape getClip() {
        org.eclipse.swt.graphics.Rectangle rect = this.gc.getClipping();
        Rectangle2D.Double aRect = new Rectangle2D.Double(rect.x, rect.y, rect.width, rect.height);
        try {
            SWTShapeManager.transform(aRect, this.transform.createInverse());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aRect;
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return ((Graphics2D)BUFFER.getGraphics()).getDeviceConfiguration();
    }

    public Paint getPaint() {
        return this.getColor();
    }

    public void setPaint(Paint paint) {
        if (paint instanceof java.awt.Color) {
            this.setColor((java.awt.Color)paint);
        }
    }

    public java.awt.Color getColor() {
        Color color = this.gc.getForeground();
        java.awt.Color awtColor = new java.awt.Color(color.getRed(), color.getGreen(), color.getBlue());
        return awtColor;
    }

    public void setColor(java.awt.Color c) {
        Color cachedColor = (Color)COLOR_CACHE.get(c);
        if (cachedColor == null) {
            cachedColor = new Color(this.device, c.getRed(), c.getGreen(), c.getBlue());
            COLOR_CACHE.put(c, cachedColor);
        }
        this.gc.setForeground(cachedColor);
    }

    public void setColor(Color c) {
        this.gc.setForeground(c);
    }

    public void setBackground(java.awt.Color c) {
        Color cachedColor = (Color)COLOR_CACHE.get(c);
        if (cachedColor == null) {
            cachedColor = new Color(this.device, c.getRed(), c.getGreen(), c.getBlue());
            COLOR_CACHE.put(c, cachedColor);
        }
        this.gc.setBackground(cachedColor);
    }

    public void setBackground(Color c) {
        this.gc.setBackground(c);
    }

    public java.awt.Color getBackground() {
        Color color = this.gc.getBackground();
        java.awt.Color awtColor = new java.awt.Color(color.getRed(), color.getGreen(), color.getBlue());
        return awtColor;
    }

    public org.eclipse.swt.graphics.Font getSWTFont() {
        return this.curFont;
    }

    public FontMetrics getSWTFontMetrics() {
        this.gc.setFont(this.curFont);
        return this.gc.getFontMetrics();
    }

    public Font getFont() {
        if (this.curFont != null) {
            int style = 0;
            FontData[] fd = this.curFont.getFontData();
            if (fd.length > 0) {
                if ((fd[0].getStyle() & 1) != 0) {
                    style |= 1;
                }
                if ((fd[0].getStyle() & 2) != 0) {
                    style |= 2;
                }
                return new Font(fd[0].getName(), style, fd[0].getHeight());
            }
            return null;
        }
        return null;
    }

    public void setFont(Font font) {
        String fontString = "name=" + font.getFamily() + ";bold=" + font.isBold() + ";italic=" + font.isItalic() + ";size=" + font.getSize();
        this.curFont = this.getFont(fontString);
    }

    public void setFont(org.eclipse.swt.graphics.Font font) {
        this.curFont = font;
    }

    public org.eclipse.swt.graphics.Font getFont(String fontString) {
        org.eclipse.swt.graphics.Font cachedFont = (org.eclipse.swt.graphics.Font)FONT_CACHE.get(fontString);
        if (cachedFont == null) {
            int style = 0;
            if (fontString.indexOf("bold=true") != -1) {
                style |= 1;
            }
            if (fontString.indexOf("italic=true") != -1) {
                style |= 2;
            }
            String name = fontString.substring(0, fontString.indexOf(";"));
            String size = fontString.substring(fontString.lastIndexOf(";") + 1, fontString.length());
            int sizeInt = 12;
            try {
                sizeInt = Integer.parseInt(size.substring(size.indexOf("=") + 1, size.length()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            cachedFont = new org.eclipse.swt.graphics.Font(this.device, name.substring(name.indexOf("=") + 1, name.length()), sizeInt, style);
            FONT_CACHE.put(fontString, cachedFont);
        }
        return cachedFont;
    }

    protected org.eclipse.swt.graphics.Font getTransformedFont() {
        if (this.curFont != null) {
            FontData fontData = this.curFont.getFontData()[0];
            int height = fontData.getHeight();
            RECT.setRect(0.0, 0.0, height, height);
            SWTShapeManager.transform(RECT, this.transform);
            height = (int)(RECT.getHeight() + 0.5);
            String fontString = "name=" + fontData.getName() + ";bold=" + ((fontData.getStyle() & 1) != 0) + ";italic=" + ((fontData.getStyle() & 2) != 0) + ";size=" + height;
            return this.getFont(fontString);
        }
        return null;
    }

    public void translate(int x, int y) {
        this.transform.translate(x, y);
    }

    public void translate(double tx, double ty) {
        this.transform.translate(tx, ty);
    }

    public void rotate(double theta) {
        this.transform.rotate(theta);
    }

    public void rotate(double theta, double x, double y) {
        this.transform.rotate(theta, x, y);
    }

    public void scale(double sx, double sy) {
        this.transform.scale(sx, sy);
    }

    public void shear(double shx, double shy) {
        this.transform.shear(shx, shy);
    }

    public void transform(AffineTransform Tx) {
        this.transform.concatenate(Tx);
    }

    public void setTransform(AffineTransform Tx) {
        this.transform = (AffineTransform)Tx.clone();
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    public void clearRect(int x, int y, int width, int height) {
        this.fillRect(x, y, width, height);
    }

    public void draw(Shape s) {
        if (s instanceof Rectangle2D) {
            Rectangle2D r2 = (Rectangle2D)s;
            this.drawRect(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
        } else if (s instanceof Ellipse2D) {
            Ellipse2D e2 = (Ellipse2D)s;
            this.drawOval(e2.getX(), e2.getY(), e2.getWidth(), e2.getHeight());
        } else if (s instanceof RoundRectangle2D) {
            RoundRectangle2D r2 = (RoundRectangle2D)s;
            this.drawRoundRect(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight(), r2.getArcWidth(), r2.getArcHeight());
        } else if (s instanceof Arc2D) {
            Arc2D a2 = (Arc2D)s;
            this.drawArc(a2.getX(), a2.getY(), a2.getWidth(), a2.getHeight(), a2.getAngleStart(), a2.getAngleExtent());
        } else {
            double[] pts = (double[])SHAPE_CACHE.get(s);
            if (pts == null) {
                pts = SWTShapeManager.shapeToPolyline(s);
                SHAPE_CACHE.put(s, pts);
            }
            this.drawPolyline(pts);
        }
    }

    public void fill(Shape s) {
        if (s instanceof Rectangle2D) {
            Rectangle2D r2 = (Rectangle2D)s;
            this.fillRect(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight());
        } else if (s instanceof Ellipse2D) {
            Ellipse2D e2 = (Ellipse2D)s;
            this.fillOval(e2.getX(), e2.getY(), e2.getWidth(), e2.getHeight());
        } else if (s instanceof RoundRectangle2D) {
            RoundRectangle2D r2 = (RoundRectangle2D)s;
            this.fillRoundRect(r2.getX(), r2.getY(), r2.getWidth(), r2.getHeight(), r2.getArcWidth(), r2.getArcHeight());
        } else if (s instanceof Arc2D) {
            Arc2D a2 = (Arc2D)s;
            this.fillArc(a2.getX(), a2.getY(), a2.getWidth(), a2.getHeight(), a2.getAngleStart(), a2.getAngleExtent());
        } else {
            double[] pts = (double[])SHAPE_CACHE.get(s);
            if (pts == null) {
                pts = SWTShapeManager.shapeToPolyline(s);
                SHAPE_CACHE.put(s, pts);
            }
            this.fillPolygon(pts);
        }
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        int[] ptArray = new int[2 * nPoints];
        int i = 0;
        while (i < nPoints) {
            PT.setLocation(xPoints[i], yPoints[i]);
            this.transform.transform(PT, PT);
            ptArray[2 * i] = xPoints[i];
            ptArray[2 * i + 1] = yPoints[i];
            ++i;
        }
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.drawPolyline(ptArray);
    }

    public void drawPolyline(double[] pts) {
        int[] intPts = SWTShapeManager.transform(pts, this.transform);
        this.gc.drawPolyline(intPts);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        int[] ptArray = new int[2 * nPoints];
        int i = 0;
        while (i < nPoints) {
            PT.setLocation(xPoints[i], yPoints[i]);
            this.transform.transform(PT, PT);
            ptArray[2 * i] = xPoints[i];
            ptArray[2 * i + 1] = yPoints[i];
            ++i;
        }
        this.gc.drawPolygon(ptArray);
    }

    public void fillPolygon(double[] pts) {
        int[] intPts = SWTShapeManager.transform(pts, this.transform);
        this.gc.fillPolygon(intPts);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        int[] ptArray = new int[2 * nPoints];
        int i = 0;
        while (i < nPoints) {
            PT.setLocation(xPoints[i], yPoints[i]);
            this.transform.transform(PT, PT);
            ptArray[2 * i] = xPoints[i];
            ptArray[2 * i + 1] = yPoints[i];
            ++i;
        }
        this.gc.fillPolygon(ptArray);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this.drawLine((double)x1, (double)y1, (double)x2, (double)y2);
    }

    public void drawLine(double x1, double y1, double x2, double y2) {
        PT.setLocation(x1, y1);
        this.transform.transform(PT, PT);
        x1 = (int)PT.getX();
        y1 = (int)PT.getY();
        PT.setLocation(x2, y2);
        this.transform.transform(PT, PT);
        x2 = (int)PT.getX();
        y2 = (int)PT.getY();
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.drawLine((int)(x1 + 0.5), (int)(y1 + 0.5), (int)(x2 + 0.5), (int)(y2 + 0.5));
    }

    public void copyArea(org.eclipse.swt.graphics.Image img, double x, double y) {
        PT.setLocation(x, y);
        this.transform.transform(PT, PT);
        this.gc.copyArea(img, (int)(PT.getX() + 0.5), (int)(PT.getY() + 0.5));
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(RECT, this.transform);
        PT.setLocation(dx, dy);
        this.transform.transform(PT, PT);
        this.gc.copyArea((int)RECT.getX(), (int)RECT.getY(), (int)RECT.getWidth(), (int)RECT.getHeight(), (int)PT.getX(), (int)PT.getY());
    }

    public void drawString(String str, double x, double y) {
        PT.setLocation(x, y);
        this.transform.transform(PT, PT);
        this.gc.setFont(this.getTransformedFont());
        this.gc.drawString(str, (int)(PT.getX() + 0.5), (int)(PT.getY() + 0.5), true);
    }

    public void drawString(String str, int x, int y) {
        this.drawString(str, (double)x, (double)y);
    }

    public void drawString(String str, float x, float y) {
        this.drawString(str, (double)x, (double)y);
    }

    public void drawText(String s, double x, double y) {
        PT.setLocation(x, y);
        this.transform.transform(PT, PT);
        this.gc.setFont(this.getTransformedFont());
        this.gc.drawText(s, (int)(PT.getX() + 0.5), (int)(PT.getY() + 0.5), true);
    }

    public void drawText(String s, double x, double y, int flags) {
        PT.setLocation(x, y);
        this.transform.transform(PT, PT);
        this.gc.setFont(this.getTransformedFont());
        this.gc.drawText(s, (int)(PT.getX() + 0.5), (int)(PT.getY() + 0.5), flags);
    }

    public void drawRect(int x, int y, int width, int height) {
        this.drawRect((double)x, (double)y, (double)width, (double)height);
    }

    public void drawRect(double x, double y, double width, double height) {
        RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(RECT, this.transform);
        SWTShapeManager.awtToSWT(RECT, SWT_RECT);
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.drawRectangle(SWT_RECT);
    }

    public void fillRect(int x, int y, int width, int height) {
        this.fillRect((double)x, (double)y, (double)width, (double)height);
    }

    public void fillRect(double x, double y, double width, double height) {
        RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(RECT, this.transform);
        SWTShapeManager.awtToSWT(RECT, SWT_RECT);
        this.gc.fillRectangle(SWT_RECT);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.drawRoundRect((double)x, (double)y, (double)width, (double)height, (double)arcWidth, (double)arcHeight);
    }

    public void drawRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(RECT, this.transform);
        x = RECT.getX();
        y = RECT.getY();
        width = RECT.getWidth();
        height = RECT.getHeight();
        RECT.setRect(0.0, 0.0, arcWidth, arcHeight);
        SWTShapeManager.transform(RECT, this.transform);
        arcWidth = RECT.getWidth();
        arcHeight = RECT.getHeight();
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.drawRoundRectangle((int)(x + 0.5), (int)(y + 0.5), (int)(width + 0.5), (int)(height + 0.5), (int)(arcWidth + 0.5), (int)(arcHeight + 0.5));
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fillRoundRect((double)x, (double)y, (double)width, (double)height, (double)arcWidth, (double)arcHeight);
    }

    public void fillRoundRect(double x, double y, double width, double height, double arcWidth, double arcHeight) {
        RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(RECT, this.transform);
        x = RECT.getX();
        y = RECT.getY();
        width = RECT.getWidth();
        height = RECT.getHeight();
        RECT.setRect(0.0, 0.0, arcWidth, arcHeight);
        SWTShapeManager.transform(RECT, this.transform);
        arcWidth = RECT.getWidth();
        arcHeight = RECT.getHeight();
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.fillRoundRectangle((int)(x + 0.5), (int)(y + 0.5), (int)(width + 0.5), (int)(height + 0.5), (int)(arcWidth + 0.5), (int)(arcHeight + 0.5));
    }

    public void drawOval(int x, int y, int width, int height) {
        this.drawOval((double)x, (double)y, (double)width, (double)height);
    }

    public void drawOval(double x, double y, double width, double height) {
        RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(RECT, this.transform);
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.drawOval((int)(RECT.getX() + 0.5), (int)(RECT.getY() + 0.5), (int)(RECT.getWidth() + 0.5), (int)(RECT.getHeight() + 0.5));
    }

    public void fillOval(int x, int y, int width, int height) {
        this.fillOval((double)x, (double)y, (double)width, (double)height);
    }

    public void fillOval(double x, double y, double width, double height) {
        RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(RECT, this.transform);
        this.gc.fillOval((int)(RECT.getX() + 0.5), (int)(RECT.getY() + 0.5), (int)(RECT.getWidth() + 0.5), (int)(RECT.getHeight() + 0.5));
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int extent) {
        this.drawArc((double)x, (double)y, (double)width, (double)height, (double)startAngle, (double)extent);
    }

    public void drawArc(double x, double y, double width, double height, double startAngle, double extent) {
        RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(RECT, this.transform);
        this.gc.setLineWidth(this.getTransformedLineWidth());
        this.gc.drawArc((int)(RECT.getX() + 0.5), (int)(RECT.getY() + 0.5), (int)(RECT.getWidth() + 0.5), (int)(RECT.getHeight() + 0.5), (int)(startAngle + 0.5), (int)(startAngle + extent + 0.5));
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int extent) {
        this.drawArc((double)x, (double)y, (double)width, (double)height, (double)startAngle, (double)extent);
    }

    public void fillArc(double x, double y, double width, double height, double startAngle, double extent) {
        RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(RECT, this.transform);
        this.gc.drawArc((int)(RECT.getX() + 0.5), (int)(RECT.getY() + 0.5), (int)(RECT.getWidth() + 0.5), (int)(RECT.getHeight() + 0.5), (int)(startAngle + 0.5), (int)(startAngle + extent + 0.5));
    }

    public void drawImage(org.eclipse.swt.graphics.Image image, double x, double y) {
        org.eclipse.swt.graphics.Rectangle bounds = image.getBounds();
        RECT.setRect(x, y, bounds.width, bounds.height);
        SWTShapeManager.transform(RECT, this.transform);
        SWTShapeManager.awtToSWT(RECT, SWT_RECT);
        this.gc.drawImage(image, 0, 0, bounds.width, bounds.height, SWTGraphics2D.SWT_RECT.x, SWTGraphics2D.SWT_RECT.y, SWTGraphics2D.SWT_RECT.width, SWTGraphics2D.SWT_RECT.height);
    }

    public void drawImage(org.eclipse.swt.graphics.Image image, int srcX, int srcY, int srcW, int srcH, double destX, double destY, double destW, double destH) {
        RECT.setRect(destX, destY, destW, destH);
        SWTShapeManager.transform(RECT, this.transform);
        SWTShapeManager.awtToSWT(RECT, SWT_RECT);
        this.gc.drawImage(image, srcX, srcY, srcW, srcH, SWTGraphics2D.SWT_RECT.x, SWTGraphics2D.SWT_RECT.y, SWTGraphics2D.SWT_RECT.width, SWTGraphics2D.SWT_RECT.height);
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    protected int getTransformedLineWidth() {
        LINE_RECT.setRect(0.0, 0.0, this.lineWidth, this.lineWidth);
        SWTShapeManager.transform(LINE_RECT, this.transform);
        return (int)(Math.max(LINE_RECT.getWidth(), 1.0) + 0.5);
    }

    public void fillGradientRectangle(double x, double y, double width, double height, boolean vertical) {
        RECT.setRect(x, y, width, height);
        SWTShapeManager.transform(RECT, this.transform);
        SWTShapeManager.awtToSWT(RECT, SWT_RECT);
        this.gc.fillGradientRectangle(SWTGraphics2D.SWT_RECT.x, SWTGraphics2D.SWT_RECT.y, SWTGraphics2D.SWT_RECT.width, SWTGraphics2D.SWT_RECT.height, vertical);
    }

    public void setXORMode(boolean xOr) {
        this.gc.setXORMode(xOr);
    }

    public int getAdvanceWidth(char ch) {
        org.eclipse.swt.graphics.Font scaledFont = this.gc.getFont();
        this.gc.setFont(this.curFont);
        int width = this.gc.getAdvanceWidth(ch);
        this.gc.setFont(scaledFont);
        return width;
    }

    public int getCharWidth(char ch) {
        org.eclipse.swt.graphics.Font scaledFont = this.gc.getFont();
        this.gc.setFont(this.curFont);
        int width = this.gc.getCharWidth(ch);
        this.gc.setFont(scaledFont);
        return width;
    }

    public Point stringExtent(String str) {
        org.eclipse.swt.graphics.Font scaledFont = this.gc.getFont();
        this.gc.setFont(this.curFont);
        Point extent = this.gc.stringExtent(str);
        this.gc.setFont(scaledFont);
        return extent;
    }

    public Point textExtent(String str) {
        org.eclipse.swt.graphics.Font scaledFont = this.gc.getFont();
        this.gc.setFont(this.curFont);
        Point extent = this.gc.textExtent(str);
        this.gc.setFont(scaledFont);
        return extent;
    }

    public Point textExtent(String str, int flags) {
        org.eclipse.swt.graphics.Font scaledFont = this.gc.getFont();
        this.gc.setFont(this.curFont);
        Point extent = this.gc.textExtent(str, flags);
        this.gc.setFont(scaledFont);
        return extent;
    }

    public void drawString(AttributedCharacterIterator iterator, int x, int y) {
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        return false;
    }

    public void setComposite(Composite comp) {
    }

    public void setStroke(Stroke s) {
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return null;
    }

    public void setRenderingHints(Map hints) {
    }

    public void addRenderingHints(Map hints) {
    }

    public RenderingHints getRenderingHints() {
        return null;
    }

    public Composite getComposite() {
        return null;
    }

    public Stroke getStroke() {
        return null;
    }

    public FontRenderContext getFontRenderContext() {
        return null;
    }

    public Graphics create() {
        return null;
    }

    public void setPaintMode() {
    }

    public void setXORMode(java.awt.Color c1) {
    }

    public java.awt.FontMetrics getFontMetrics(Font f) {
        return null;
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return false;
    }

    public void drawImage(BufferedImage img, BufferedImageOp op, int x, int y) {
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int x, int y, java.awt.Color bgcolor, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, java.awt.Color bgcolor, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return false;
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, java.awt.Color bgcolor, ImageObserver observer) {
        return false;
    }

    public void dispose() {
    }

    public static void incrementGCCount() {
        ++CACHE_COUNT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decrementGCCount() {
        if (--CACHE_COUNT == 0) {
            Iterator i;
            HashMap hashMap = FONT_CACHE;
            synchronized (hashMap) {
                i = FONT_CACHE.values().iterator();
                while (i.hasNext()) {
                    org.eclipse.swt.graphics.Font font = (org.eclipse.swt.graphics.Font)i.next();
                    font.dispose();
                }
                FONT_CACHE.clear();
            }
            hashMap = COLOR_CACHE;
            synchronized (hashMap) {
                i = COLOR_CACHE.values().iterator();
                while (i.hasNext()) {
                    Color color = (Color)i.next();
                    color.dispose();
                }
                COLOR_CACHE.clear();
            }
        }
    }
}

