/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.builder;

import com.python.pydev.analysis.AnalysisPreferences;
import com.python.pydev.analysis.builder.AnalysisBuilderVisitor;
import com.python.pydev.analysis.builder.AnalysisRunner;
import com.rc.retroweaver.runtime.Autobox;
import com.rc.retroweaver.runtime.ClassLiteral;
import java.io.File;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.parser.ChangedParserInfoForObservers;
import org.python.pydev.core.parser.ErrorParserInfoForObservers;
import org.python.pydev.core.parser.IParserObserver;
import org.python.pydev.core.parser.IParserObserver3;
import org.python.pydev.core.parser.ISimpleNode;
import org.python.pydev.editor.codecompletion.revisited.modules.AbstractModule;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.plugin.nature.PythonNature;

public class AnalysisParserObserver
implements IParserObserver,
IParserObserver3 {
    public static final String ANALYSIS_PARSER_OBSERVER_FORCE = "AnalysisParserObserver:force";

    public void parserChanged(ChangedParserInfoForObservers info) {
        int whenAnalyze;
        SimpleNode root = (SimpleNode)info.root;
        if (info.file == null) {
            return;
        }
        IFile fileAdapter = null;
        if (info.file instanceof IFile) {
            fileAdapter = (IFile)info.file;
        }
        if (fileAdapter == null && (fileAdapter = (IFile)info.file.getAdapter(ClassLiteral.getClass((String)"org/eclipse/core/resources/IFile"))) == null) {
            return;
        }
        boolean force = false;
        if (info.argsToReparse != null && info.argsToReparse.length > 0 && info.argsToReparse[0] instanceof Tuple) {
            Tuple t = (Tuple)info.argsToReparse[0];
            if (t.o1 instanceof String && t.o2 instanceof Boolean && t.o1.equals(ANALYSIS_PARSER_OBSERVER_FORCE)) {
                force = (Boolean)t.o2;
            }
        }
        if ((whenAnalyze = AnalysisPreferences.getAnalysisPreferences().getWhenAnalyze()) == 2 || force) {
            IModule module;
            PythonNature nature = PythonNature.getPythonNature((IResource)fileAdapter);
            if (nature == null) {
                return;
            }
            if (!nature.isOkToUse()) {
                return;
            }
            if (!nature.startRequests()) {
                return;
            }
            try {
                String moduleName = nature.resolveModuleOnlyInProjectSources((IResource)fileAdapter, true);
                if (moduleName == null) {
                    AnalysisRunner.deleteMarkers((IResource)fileAdapter);
                    return;
                }
                try {
                    String file = fileAdapter.getRawLocation().toOSString();
                    module = AbstractModule.createModule((SimpleNode)root, (File)new File(file), (String)moduleName);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                    return;
                }
            }
            finally {
                nature.endRequests();
            }
            AnalysisBuilderVisitor visitor = new AnalysisBuilderVisitor();
            visitor.memo = new HashMap();
            visitor.memo.put("IS_FULL_BUILD", Autobox.valueOf((boolean)false));
            visitor.memo.put("DOCUMENT_TIME", Autobox.valueOf((long)info.documentTime));
            visitor.visitingWillStart((IProgressMonitor)new NullProgressMonitor(), false, null);
            visitor.doVisitChangedResource((IPythonNature)nature, (IResource)fileAdapter, info.doc, null, module, (IProgressMonitor)new NullProgressMonitor(), force, 2, info.documentTime);
            visitor.visitingEnded((IProgressMonitor)new NullProgressMonitor());
        }
    }

    public void parserChanged(ISimpleNode root, IAdaptable resource, IDocument doc) {
        throw new RuntimeException("As it uses IParserObserver2, this interface should not be asked for.");
    }

    public void parserError(Throwable error, IAdaptable file, IDocument doc) {
    }

    public void parserError(ErrorParserInfoForObservers info) {
    }
}

