/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.visitors;

import com.python.pydev.analysis.IAnalysisPreferences;
import com.python.pydev.analysis.messages.CompositeMessage;
import com.python.pydev.analysis.messages.IMessage;
import com.python.pydev.analysis.messages.Message;
import com.python.pydev.analysis.visitors.Found;
import com.python.pydev.analysis.visitors.GenAndTok;
import com.python.pydev.analysis.visitors.ScopeItems;
import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.IToken;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.Name;
import org.python.pydev.parser.jython.ast.NameTok;
import org.python.pydev.parser.jython.ast.Pass;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.stmtType;
import org.python.pydev.parser.visitors.NodeUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MessagesManager {
    private IAnalysisPreferences prefs;
    public Map<IToken, List<IMessage>> messages = new HashMap<IToken, List<IMessage>>();
    public List<IMessage> independentMessages = new ArrayList<IMessage>();
    private String moduleName;
    private IDocument document;
    private Set<String> namesToIgnoreCache = null;
    private ScopeItems lastScope;

    public MessagesManager(IAnalysisPreferences prefs, String moduleName, IDocument doc) {
        this.prefs = prefs;
        this.moduleName = moduleName;
        this.document = doc;
    }

    public boolean shouldAddUnusedImportMessage() {
        if (this.moduleName == null) {
            return true;
        }
        String onlyModName = FullRepIterable.headAndTail((String)this.moduleName, (boolean)true)[1];
        Set<String> patternsToBeIgnored = this.prefs.getModuleNamePatternsToBeIgnored();
        for (String pattern : patternsToBeIgnored) {
            if (!onlyModName.matches(pattern)) continue;
            return false;
        }
        return true;
    }

    public void addMessage(int type, IToken generator, Object ... objects) {
        if (this.isUnusedImportMessage(type) && !this.shouldAddUnusedImportMessage()) {
            return;
        }
        this.doAddMessage(this.independentMessages, type, objects, generator);
    }

    private boolean isUnusedImportMessage(int type) {
        return type == 1 || type == 8;
    }

    public void addMessage(int type, IToken token) {
        List<IMessage> msgs = this.getMsgsList(token);
        this.doAddMessage(msgs, type, token.getRepresentation(), token);
    }

    private void doAddMessage(List<IMessage> msgs, int type, Object string, IToken token) {
        int startLine;
        String line;
        if (this.isUnusedImportMessage(type) && !this.shouldAddUnusedImportMessage()) {
            return;
        }
        Message messageToAdd = new Message(type, string, token, this.prefs);
        String messageToIgnore = this.prefs.getRequiredMessageToIgnore(messageToAdd.getType());
        if (messageToIgnore != null && (line = PySelection.getLine((IDocument)this.document, (int)(startLine = messageToAdd.getStartLine(this.document) - 1))).indexOf(messageToIgnore) != -1) {
            return;
        }
        msgs.add(messageToAdd);
    }

    public void addMessage(int type, IToken generator, IToken tok) {
        this.addMessage(type, generator, tok, tok.getRepresentation());
    }

    public void addMessage(int type, IToken generator, IToken tok, String rep) {
        List<IMessage> msgs = this.getMsgsList(generator);
        this.doAddMessage(msgs, type, rep, generator);
    }

    public List<IMessage> getMsgsList(IToken generator) {
        List<IMessage> msgs = this.messages.get(generator);
        if (msgs == null) {
            msgs = new ArrayList<IMessage>();
            this.messages.put(generator, msgs);
        }
        return msgs;
    }

    public void addUndefinedMessage(IToken token) {
        this.addUndefinedMessage(token, null);
    }

    public void addUndefinedMessage(IToken token, String rep) {
        Tuple<Boolean, String> undef = this.isActuallyUndefined(token, rep);
        if (((Boolean)undef.o1).booleanValue()) {
            this.addMessage(3, token, undef.o2);
        }
    }

    public void addUndefinedVarInImportMessage(IToken token, String rep) {
        Tuple<Boolean, String> undef = this.isActuallyUndefined(token, rep);
        if (((Boolean)undef.o1).booleanValue()) {
            this.addMessage(9, token, undef.o2);
        }
    }

    protected Tuple<Boolean, String> isActuallyUndefined(IToken token, String rep) {
        String builtinType;
        int i;
        String tokenRepresentation = token.getRepresentation();
        if (tokenRepresentation != null) {
            String firstPart = FullRepIterable.getFirstPart((String)tokenRepresentation);
            if (this.prefs.getTokensAlwaysInGlobals().contains(firstPart)) {
                return new Tuple((Object)Autobox.valueOf((boolean)false), (Object)firstPart);
            }
        }
        boolean isActuallyUndefined = true;
        if (rep == null) {
            rep = tokenRepresentation;
        }
        if ((i = rep.indexOf(46)) != -1) {
            rep = rep.substring(0, i);
        }
        if ((builtinType = NodeUtils.getBuiltinType((String)rep)) != null) {
            isActuallyUndefined = false;
        }
        return new Tuple((Object)Autobox.valueOf((boolean)isActuallyUndefined), (Object)rep);
    }

    public void addUnusedMessage(SimpleNode node, Found f) {
        for (GenAndTok g : f) {
            boolean addMessage;
            int type;
            block14: {
                SimpleNode ast;
                if (g.generator instanceof SourceToken && ((ast = ((SourceToken)g.generator).getAst()) instanceof Import || ast instanceof ImportFrom)) {
                    if (AbstractVisitor.isWildImport((SimpleNode)ast)) {
                        this.addMessage(8, g.generator, g.tok);
                        continue;
                    }
                    if (g.generator instanceof AbstractVisitor.ImportPartSourceToken) continue;
                    this.addMessage(1, g.generator, g.tok);
                    continue;
                }
                if (!this.startsWithNamesToIgnore(g)) continue;
                type = 2;
                if (g.tok instanceof SourceToken) {
                    NameTok n;
                    SourceToken t = (SourceToken)g.tok;
                    SimpleNode ast2 = t.getAst();
                    if (ast2 instanceof NameTok) {
                        n = (NameTok)ast2;
                        if (n.ctx == 6 || n.ctx == 5 || n.ctx == 3) {
                            type = 10;
                        }
                    } else if (ast2 instanceof Name) {
                        n = (Name)ast2;
                        if (n.ctx == 6 || n.ctx == 8) {
                            type = 10;
                        }
                    }
                }
                addMessage = true;
                if (type != 10 || !(node instanceof FunctionDef)) break block14;
                addMessage = false;
                FunctionDef def = (FunctionDef)node;
                stmtType[] stmtTypeArray = def.body;
                int n = def.body.length;
                int n2 = 0;
                while (n2 < n) {
                    block15: {
                        block16: {
                            stmtType b = stmtTypeArray[n2];
                            if (b instanceof Pass) break block15;
                            if (!(b instanceof Expr)) break block16;
                            Expr expr = (Expr)b;
                            if (expr.value instanceof Str) break block15;
                        }
                        addMessage = true;
                        break;
                    }
                    ++n2;
                }
            }
            if (!addMessage) continue;
            this.addMessage(type, g.generator, g.tok);
        }
    }

    private boolean startsWithNamesToIgnore(GenAndTok g) {
        if (this.namesToIgnoreCache == null) {
            this.namesToIgnoreCache = this.prefs.getNamesIgnoredByUnusedVariable();
        }
        String representation = g.tok.getRepresentation();
        boolean addIt = true;
        for (String str : this.namesToIgnoreCache) {
            if (!representation.startsWith(str)) continue;
            addIt = false;
            break;
        }
        return addIt;
    }

    public void addReimportMessage(Found f) {
        for (GenAndTok g : f) {
            if (!(g.generator instanceof SourceToken) || g.generator instanceof AbstractVisitor.ImportPartSourceToken || AbstractVisitor.isWildImport((IToken)g.generator)) continue;
            this.addMessage(5, g.generator, g.tok);
        }
    }

    public List<IMessage> getMessages() {
        ArrayList<IMessage> result = new ArrayList<IMessage>();
        for (List<IMessage> l : this.messages.values()) {
            if (l.size() < 1) continue;
            Map<Integer, List<IMessage>> messagesByType = this.getMessagesByType(l);
            for (int type : messagesByType.keySet()) {
                l = messagesByType.get(Autobox.valueOf((int)type));
                IMessage message = l.get(0);
                if (message.getSeverity() == 0 && this.doIgnoreMessageIfJustInformational(message.getType())) continue;
                if (l.size() == 1) {
                    this.addToResult(result, message);
                    continue;
                }
                CompositeMessage compositeMessage = new CompositeMessage(message.getType(), message.getGenerator(), this.prefs);
                for (IMessage m : l) {
                    compositeMessage.addMessage(m);
                }
                this.addToResult(result, compositeMessage);
            }
        }
        for (IMessage message : this.independentMessages) {
            if (message.getSeverity() == 0 && this.doIgnoreMessageIfJustInformational(message.getType())) continue;
            this.addToResult(result, message);
        }
        return result;
    }

    private boolean doIgnoreMessageIfJustInformational(int type) {
        return type == 10 || type == 12 || type == 11;
    }

    private void addToResult(List<IMessage> result, IMessage message) {
        String asAbsoluteImport;
        IToken generator;
        if (this.isUnusedImportMessage(message.getType()) && (generator = message.getGenerator()) instanceof SourceToken && ((asAbsoluteImport = generator.getAsAbsoluteImport()).indexOf("__future__.") != -1 || asAbsoluteImport.indexOf("__metaclass__") != -1)) {
            return;
        }
        result.add(message);
    }

    private Map<Integer, List<IMessage>> getMessagesByType(List<IMessage> l) {
        HashMap<Integer, List<IMessage>> messagesByType = new HashMap<Integer, List<IMessage>>();
        for (IMessage message : l) {
            List<IMessage> messages = messagesByType.get(Autobox.valueOf((int)message.getType()));
            if (messages == null) {
                messages = new ArrayList<IMessage>();
                messagesByType.put(Autobox.valueOf((int)message.getType()), messages);
            }
            messages.add(message);
        }
        return messagesByType;
    }

    public void setLastScope(ScopeItems m) {
        this.lastScope = m;
    }
}

