/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.django.ui.wizards.project;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.callbacks.ICallback;
import org.python.pydev.core.callbacks.ICallback0;
import org.python.pydev.core.uiutils.RunInUiThread;
import org.python.pydev.django.DjangoPlugin;
import org.python.pydev.django.nature.DjangoNature;
import org.python.pydev.django.ui.wizards.project.DjangoNewProjectPage;
import org.python.pydev.django.ui.wizards.project.DjangoSettingsPage;
import org.python.pydev.editor.actions.PyAction;
import org.python.pydev.plugin.PyStructureConfigHelpers;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;
import org.python.pydev.runners.UniversalRunner;
import org.python.pydev.ui.wizards.project.IWizardNewProjectNameAndLocationPage;
import org.python.pydev.ui.wizards.project.PythonProjectWizard;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DjangoProjectWizard
extends PythonProjectWizard {
    public static final String WIZARD_ID = "org.python.pydev.ui.wizards.project.DjangoProjectWizard";
    protected DjangoSettingsPage settingsPage = this.createDjangoSettingsPage(new ICallback0<IWizardNewProjectNameAndLocationPage>(){

        public IWizardNewProjectNameAndLocationPage call() {
            return DjangoProjectWizard.this.projectPage;
        }

        public /* synthetic */ Object call() {
            return this.call();
        }
    });
    protected static final String RUN_DJANGO_ADMIN = "from django.core import management\nmanagement.execute_from_command_line()";

    protected IWizardNewProjectNameAndLocationPage createProjectPage() {
        return new DjangoNewProjectPage("Setting project properties");
    }

    protected DjangoSettingsPage createDjangoSettingsPage(ICallback0<IWizardNewProjectNameAndLocationPage> projectPage) {
        return new DjangoSettingsPage("Django Settings", projectPage);
    }

    public void addPages() {
        super.addPages();
        this.addPage((IWizardPage)this.settingsPage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createAndConfigProject(IProject projectHandle, IProjectDescription description, String projectType, String projectInterpreter, IProgressMonitor monitor, Object ... additionalArgsToConfigProject) throws CoreException {
        Assert.isTrue((additionalArgsToConfigProject.length == 1 ? 1 : 0) != 0);
        DjangoSettingsPage.DjangoSettings djSettings = (DjangoSettingsPage.DjangoSettings)additionalArgsToConfigProject[0];
        final boolean shouldCreatSourceFolder = this.projectPage.shouldCreatSourceFolder();
        ICallback<List<IContainer>, IProject> getSourceFolderHandlesCallback = new ICallback<List<IContainer>, IProject>(){

            public List<IContainer> call(IProject projectHandle) {
                if (shouldCreatSourceFolder) {
                    IFolder folder = projectHandle.getFolder("src");
                    ArrayList<IContainer> ret = new ArrayList<IContainer>();
                    ret.add((IContainer)folder);
                    return ret;
                }
                ArrayList<IContainer> ret = new ArrayList<IContainer>();
                ret.add((IContainer)projectHandle);
                return ret;
            }

            public /* synthetic */ Object call(Object object) {
                return this.call((IProject)object);
            }
        };
        ICallback<Map<String, String>, IProject> getVariableSubstitutionCallback = new ICallback<Map<String, String>, IProject>(){

            public Map<String, String> call(IProject projectHandle) {
                HashMap<String, String> variableSubstitution = new HashMap<String, String>();
                String manageLocation = new StringBuffer(String.valueOf(projectHandle.getName())).append("/manage.py").toString();
                if (shouldCreatSourceFolder) {
                    manageLocation = new StringBuffer("src/").append(manageLocation).toString();
                }
                variableSubstitution.put("DJANGO_MANAGE_LOCATION", manageLocation);
                return variableSubstitution;
            }

            public /* synthetic */ Object call(Object object) {
                return this.call((IProject)object);
            }
        };
        PyStructureConfigHelpers.createPydevProject((IProjectDescription)description, (IProject)projectHandle, (IProgressMonitor)monitor, (String)projectType, (String)projectInterpreter, (ICallback)getSourceFolderHandlesCallback, null, (ICallback)getVariableSubstitutionCallback);
        DjangoNature.addNature(projectHandle, null);
        try {
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            PythonNature nature = PythonNature.getPythonNature((IProject)projectHandle);
            Assert.isNotNull((Object)nature);
            ICodeCompletionASTManager astManager = nature.getAstManager();
            Object sync = new Object();
            int i = 0;
            while (i < 100 && astManager == null) {
                Object object = sync;
                synchronized (object) {
                    try {
                        sync.wait(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                astManager = nature.getAstManager();
                ++i;
            }
            if (astManager == null) {
                throw new RuntimeException("Error creating Django project. ASTManager not available after 10 seconds.\nPlease report this bug at the sourceforge tracker.");
            }
            UniversalRunner.AbstractRunner runner = UniversalRunner.getRunner((IPythonNature)nature);
            Object projectContainer = shouldCreatSourceFolder ? projectHandle.getFolder("src") : projectHandle;
            Tuple output = runner.runCodeAndGetOutput(RUN_DJANGO_ADMIN, new String[]{"startproject", projectHandle.getName()}, projectContainer.getLocation().toFile(), (IProgressMonitor)new NullProgressMonitor());
            if (((String)output.o2).indexOf("ImportError: no module named django") != -1) {
                RunInUiThread.async((Runnable)new Runnable(){

                    public void run() {
                        MessageDialog.openError((Shell)PyAction.getShell(), (String)"Unable to create project.", (String)"Unable to create project because the selected interpreter does not have django.");
                    }
                });
                projectHandle.delete(true, null);
                return;
            }
            IFile settingsFile = projectContainer.getFile((IPath)new Path(new StringBuffer(String.valueOf(projectHandle.getName())).append("/settings.py").toString()));
            settingsFile.refreshLocal(0, null);
            IDocument docFromResource = REF.getDocFromResource((IResource)settingsFile);
            if (docFromResource == null) {
                throw new RuntimeException(new StringBuffer("Error creating Django project.\nsettings.py file not created.\nStdout: ").append((String)output.o1).append("\n").append("Stderr: ").append((String)output.o2).toString());
            }
            String settings = docFromResource.get();
            if (djSettings.djangoVersion.contains("1.2")) {
                settings = settings.replaceFirst("'ENGINE': 'django.db.backends.'", new StringBuffer("'ENGINE': 'django.db.backends.").append(djSettings.databaseEngine).append("'").toString());
                settings = settings.replaceFirst("'NAME': ''", new StringBuffer("'NAME': '").append(djSettings.databaseName).append("'").toString());
                settings = settings.replaceFirst("'HOST': ''", new StringBuffer("'HOST': '").append(djSettings.databaseHost).append("'").toString());
                settings = settings.replaceFirst("'PORT': ''", new StringBuffer("'PORT': '").append(djSettings.databasePort).append("'").toString());
                settings = settings.replaceFirst("'USER': ''", new StringBuffer("'USER': '").append(djSettings.databaseUser).append("'").toString());
                settings = settings.replaceFirst("'PASSWORD': ''", new StringBuffer("'PASSWORD': '").append(djSettings.databasePassword).append("'").toString());
            } else {
                settings = settings.replaceFirst("DATABASE_ENGINE = ''", new StringBuffer("DATABASE_ENGINE = '").append(djSettings.databaseEngine).append("'").toString());
                settings = settings.replaceFirst("DATABASE_NAME = ''", new StringBuffer("DATABASE_NAME = '").append(djSettings.databaseName).append("'").toString());
                settings = settings.replaceFirst("DATABASE_HOST = ''", new StringBuffer("DATABASE_HOST = '").append(djSettings.databaseHost).append("'").toString());
                settings = settings.replaceFirst("DATABASE_PORT = ''", new StringBuffer("DATABASE_PORT = '").append(djSettings.databasePort).append("'").toString());
                settings = settings.replaceFirst("DATABASE_USER = ''", new StringBuffer("DATABASE_USER = '").append(djSettings.databaseUser).append("'").toString());
                settings = settings.replaceFirst("DATABASE_PASSWORD = ''", new StringBuffer("DATABASE_PASSWORD = '").append(djSettings.databasePassword).append("'").toString());
            }
            settingsFile.setContents((InputStream)new ByteArrayInputStream(settings.getBytes()), 0, monitor);
        }
        finally {
            monitor.done();
        }
    }

    protected IProject createNewProject(Object ... additionalArgsToConfigProject) {
        if (additionalArgsToConfigProject != null && additionalArgsToConfigProject.length > 0) {
            throw new RuntimeException("Did not expect to receive arguments here.");
        }
        DjangoSettingsPage.DjangoSettings djSettings = this.settingsPage.getSettings();
        return super.createNewProject(new Object[]{djSettings});
    }

    protected void initializeDefaultPageImageDescriptor() {
        ImageDescriptor desc = PydevPlugin.imageDescriptorFromPlugin((String)DjangoPlugin.getPluginID(), (String)"icons/django_logo.png");
        this.setDefaultPageImageDescriptor(desc);
    }

    public boolean canFinish() {
        IWizardPage currentPage = this.getContainer().getCurrentPage();
        return currentPage == this.settingsPage;
    }
}

