/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.actions;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.ui.actions.OpenAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.progress.UIJob;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.parser.IParserObserver;
import org.python.pydev.core.parser.ISimpleNode;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.actions.PyOpenAction;
import org.python.pydev.editor.actions.refactoring.PyRefactorAction;
import org.python.pydev.editor.codecompletion.PyCodeCompletionImages;
import org.python.pydev.editor.codecompletion.revisited.PythonPathHelper;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.AbstractJavaClassModule;
import org.python.pydev.editor.codecompletion.revisited.javaintegration.JavaDefinition;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.refactoring.AbstractPyRefactoring;
import org.python.pydev.editor.refactoring.IPyRefactoring;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.editor.refactoring.TooManyMatchesException;
import org.python.pydev.parser.PyParser;
import org.python.pydev.plugin.PydevPlugin;

public class PyGoToDefinition
extends PyRefactorAction {
    protected boolean areRefactorPreconditionsOK(RefactoringRequest request) {
        return true;
    }

    public void run(IAction action) {
        this.workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IEditorPart[] dirtyEditors = this.workbenchWindow.getActivePage().getDirtyEditors();
        HashSet<PyEdit> askReparse = new HashSet<PyEdit>();
        IEditorPart[] iEditorPartArray = dirtyEditors;
        int n = dirtyEditors.length;
        int n2 = 0;
        while (n2 < n) {
            IEditorPart iEditorPart = iEditorPartArray[n2];
            if (iEditorPart instanceof PyEdit) {
                PyEdit pyEdit = (PyEdit)iEditorPart;
                long astModificationTimeStamp = pyEdit.getAstModificationTimeStamp();
                IDocument doc = pyEdit.getDocument();
                if (astModificationTimeStamp == -1L || astModificationTimeStamp != ((IDocumentExtension4)doc).getModificationStamp()) {
                    askReparse.add(pyEdit);
                }
            }
            ++n2;
        }
        if (askReparse.size() == 0) {
            this.findDefinitionsAndOpen(true);
        } else {
            Object lock = new Object();
            Iterator iterator = askReparse.iterator();
            while (iterator.hasNext()) {
                PyEdit pyEdit = (PyEdit)iterator.next();
                FindParserObserver observer = new FindParserObserver(pyEdit, askReparse, lock);
                PyParser parser = pyEdit.getParser();
                parser.addParseListener((IParserObserver)observer);
                parser.forceReparse(new Object[0]);
            }
        }
    }

    public ItemPointer[] findDefinitionsAndOpen(boolean doOpenDefinition) {
        RefactoringRequest refactoringRequest;
        this.request = null;
        this.ps = new PySelection(this.getTextEditor());
        PyEdit pyEdit = this.getPyEdit();
        try {
            refactoringRequest = this.getRefactoringRequest();
        }
        catch (MisconfigurationException e1) {
            PydevPlugin.log((Throwable)e1);
            return new ItemPointer[0];
        }
        Shell shell = PyGoToDefinition.getShell();
        try {
            if (this.areRefactorPreconditionsOK(refactoringRequest)) {
                ItemPointer[] defs = this.findDefinition(pyEdit);
                if (doOpenDefinition) {
                    PyGoToDefinition.openDefinition(defs, pyEdit, shell);
                }
                return defs;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PydevPlugin.log((Throwable)e);
            String msg = e.getMessage();
            if (msg == null) {
                msg = "Unable to get error msg (null)";
            }
            ErrorDialog.openError((Shell)shell, (String)"Error", (String)"Unable to do requested action", (IStatus)new Status(4, PydevPlugin.getPluginID(), 0, msg, (Throwable)e));
        }
        return null;
    }

    public static void openDefinition(ItemPointer[] defs, final PyEdit pyEdit, final Shell shell) {
        if (defs == null) {
            shell.getDisplay().beep();
            return;
        }
        HashSet<ItemPointer> set = new HashSet<ItemPointer>();
        ItemPointer[] itemPointerArray = defs;
        int n = defs.length;
        int n2 = 0;
        while (n2 < n) {
            ItemPointer pointer = itemPointerArray[n2];
            if (pointer.file != null) {
                set.add(pointer);
            }
            ++n2;
        }
        final ItemPointer[] where = set.toArray(new ItemPointer[0]);
        if (where == null) {
            shell.getDisplay().beep();
            return;
        }
        if (where.length > 0) {
            if (where.length == 1) {
                ItemPointer itemPointer = where[0];
                PyGoToDefinition.doOpen(itemPointer, pyEdit, shell);
            } else {
                Display disp = shell.getDisplay();
                disp.syncExec(new Runnable(){

                    public void run() {
                        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, new ILabelProvider(){

                            public Image getImage(Object element) {
                                return PyCodeCompletionImages.getImageForType((int)6);
                            }

                            public String getText(Object element) {
                                ItemPointer pointer = (ItemPointer)element;
                                File f = (File)pointer.file;
                                int line = pointer.start.line;
                                return String.valueOf(f.getName()) + "  (" + f.getParent() + ") - line:" + line;
                            }

                            public void addListener(ILabelProviderListener listener) {
                            }

                            public void dispose() {
                            }

                            public boolean isLabelProperty(Object element, String property) {
                                return false;
                            }

                            public void removeListener(ILabelProviderListener listener) {
                            }
                        });
                        dialog.setTitle("Found matches");
                        dialog.setTitle("Select the one you believe matches most your search.");
                        dialog.setElements((Object[])where);
                        dialog.open();
                        Object[] result = dialog.getResult();
                        if (result != null && result.length > 0) {
                            PyGoToDefinition.doOpen((ItemPointer)result[0], pyEdit, shell);
                        }
                    }
                });
            }
        } else {
            shell.getDisplay().beep();
        }
    }

    private static void doOpen(ItemPointer itemPointer, PyEdit pyEdit, Shell shell) {
        File f = (File)itemPointer.file;
        String filename = f.getName();
        if (PythonPathHelper.isValidSourceFile((String)filename) || filename.indexOf(46) == -1 || itemPointer.zipFilePath != null && PythonPathHelper.isValidSourceFile((String)itemPointer.zipFilePath)) {
            PyOpenAction openAction = (PyOpenAction)pyEdit.getAction("OpenEditor");
            openAction.run(itemPointer);
        } else if (itemPointer.definition instanceof JavaDefinition) {
            JavaDefinition javaDefinition = (JavaDefinition)itemPointer.definition;
            OpenAction openAction = new OpenAction((IWorkbenchSite)pyEdit.getSite());
            StructuredSelection selection = new StructuredSelection(new Object[]{javaDefinition.javaElement});
            openAction.run((IStructuredSelection)selection);
        } else {
            String message;
            if (itemPointer.definition != null && itemPointer.definition.module instanceof AbstractJavaClassModule) {
                AbstractJavaClassModule module = (AbstractJavaClassModule)itemPointer.definition.module;
                message = "The definition was found at: " + f.toString() + "\n" + "as the java module: " + module.getName();
            } else {
                message = "The definition was found at: " + f.toString() + "\n" + "(which cannot be opened because it is a compiled extension)";
            }
            MessageDialog.openInformation((Shell)shell, (String)"Compiled Extension file", (String)message);
        }
    }

    public ItemPointer[] findDefinition(PyEdit pyEdit) throws TooManyMatchesException, MisconfigurationException {
        IPyRefactoring pyRefactoring = AbstractPyRefactoring.getPyRefactoring();
        return pyRefactoring.findDefinition(this.getRefactoringRequest());
    }

    protected String perform(IAction action, IProgressMonitor monitor) throws Exception {
        return null;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class FindParserObserver
    implements IParserObserver {
        private Object lock;
        private Set<PyEdit> askReparse;
        private PyEdit editToReparse;

        public FindParserObserver(PyEdit editToReparse, Set<PyEdit> askReparse, Object lock) {
            this.editToReparse = editToReparse;
            this.askReparse = askReparse;
            this.lock = lock;
        }

        public void parserChanged(ISimpleNode root, IAdaptable file, IDocument doc) {
            this.editToReparse.getParser().removeParseListener((IParserObserver)this);
            this.doFindIfLast();
        }

        public void parserError(Throwable error, IAdaptable file, IDocument doc) {
            this.editToReparse.getParser().removeParseListener((IParserObserver)this);
            this.doFindIfLast();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doFindIfLast() {
            Object object = this.lock;
            synchronized (object) {
                this.askReparse.remove(this.editToReparse);
                if (this.askReparse.size() > 0) {
                    return;
                }
            }
            UIJob job = new UIJob("Find"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    try {
                        PyGoToDefinition.this.findDefinitionsAndOpen(true);
                    }
                    catch (Throwable e) {
                        Log.log((Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setPriority(10);
            job.schedule();
        }
    }
}

