/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.refactorer;

import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AdditionalProjectInterpreterInfo;
import com.python.pydev.analysis.additionalinfo.IInfo;
import com.python.pydev.refactoring.refactorer.Refactorer;
import com.python.pydev.ui.hierarchy.HierarchyNodeModel;
import com.rc.retroweaver.runtime.Autobox;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.OperationCanceledException;
import org.python.pydev.core.ICompletionCache;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.editor.codecompletion.revisited.CompletionCache;
import org.python.pydev.editor.codecompletion.revisited.CompletionStateFactory;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceModule;
import org.python.pydev.editor.codecompletion.revisited.visitors.AssignDefinition;
import org.python.pydev.editor.codecompletion.revisited.visitors.Definition;
import org.python.pydev.editor.model.ItemPointer;
import org.python.pydev.editor.refactoring.RefactoringRequest;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.exprType;
import org.python.pydev.parser.visitors.NodeUtils;
import org.python.pydev.parser.visitors.scope.ASTEntry;
import org.python.pydev.parser.visitors.scope.EasyASTIteratorVisitor;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.plugin.nature.PythonNature;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RefactorerFinds {
    private Refactorer refactorer;

    public RefactorerFinds(Refactorer refactorer) {
        this.refactorer = refactorer;
    }

    private void findParentDefinitions(IPythonNature nature, Definition d, List<Definition> definitions, List<String> withoutAstDefinitions, HierarchyNodeModel model, ICompletionCache completionCache) throws Exception {
        exprType[] exprTypeArray = model.ast.bases;
        int n = model.ast.bases.length;
        int n2 = 0;
        while (n2 < n) {
            exprType exp = exprTypeArray[n2];
            String n3 = NodeUtils.getFullRepresentationString((SimpleNode)exp);
            int line = exp.beginLine;
            int col = exp.beginColumn + n3.length();
            Definition[] defs = (Definition[])d.module.findDefinition(CompletionStateFactory.getEmptyCompletionState((String)n3, (IPythonNature)nature, (ICompletionCache)completionCache), line, col, nature);
            if (defs.length > 0) {
                definitions.addAll(Arrays.asList(defs));
            } else {
                withoutAstDefinitions.add(n3);
            }
            ++n2;
        }
    }

    private void findParents(IPythonNature nature, Definition d, HierarchyNodeModel initialModel, HashMap<HierarchyNodeModel, HierarchyNodeModel> allFound, RefactoringRequest request) throws Exception {
        HashSet<HierarchyNodeModel> foundOnRound = new HashSet<HierarchyNodeModel>();
        foundOnRound.add(initialModel);
        CompletionCache completionCache = new CompletionCache();
        while (foundOnRound.size() > 0) {
            HashSet nextRound = new HashSet(foundOnRound);
            foundOnRound.clear();
            for (HierarchyNodeModel toFindOnRound : nextRound) {
                ArrayList<Definition> definitions = new ArrayList<Definition>();
                ArrayList<String> withoutAstDefinitions = new ArrayList<String>();
                this.findParentDefinitions(nature, d, definitions, withoutAstDefinitions, toFindOnRound, (ICompletionCache)completionCache);
                request.communicateWork(StringUtils.format((String)"Found: %s parents for: %s", (Object[])new Object[]{Autobox.valueOf((int)definitions.size()), d.value}));
                for (Definition definition : definitions) {
                    HierarchyNodeModel model2 = this.createHierarhyNodeFromClassDef(definition);
                    if (model2 != null) {
                        if (!allFound.containsKey(model2)) {
                            allFound.put(model2, model2);
                            toFindOnRound.parents.add(model2);
                            foundOnRound.add(model2);
                            continue;
                        }
                        model2 = allFound.get(model2);
                        Assert.isNotNull((Object)model2);
                        toFindOnRound.parents.add(model2);
                        continue;
                    }
                    withoutAstDefinitions.add(definition.value);
                }
                for (String def : withoutAstDefinitions) {
                    toFindOnRound.parents.add(new HierarchyNodeModel(def));
                }
            }
        }
    }

    private void findChildren(RefactoringRequest request, HierarchyNodeModel initialModel, HashMap<HierarchyNodeModel, HierarchyNodeModel> allFound) {
        List infoForProject;
        try {
            infoForProject = AdditionalProjectInterpreterInfo.getAdditionalInfoForProjectAndReferencing((IPythonNature)request.nature);
        }
        catch (MisconfigurationException e) {
            PydevPlugin.log((Throwable)e);
            return;
        }
        HashSet<HierarchyNodeModel> foundOnRound = new HashSet<HierarchyNodeModel>();
        foundOnRound.add(initialModel);
        while (foundOnRound.size() > 0) {
            HashSet nextRound = new HashSet(foundOnRound);
            foundOnRound.clear();
            for (HierarchyNodeModel toFindOnRound : nextRound) {
                HashSet<SourceModule> modulesToAnalyze = this.findLikelyModulesWithChildren(request, toFindOnRound, infoForProject);
                request.communicateWork(new StringBuffer("Likely modules with matches:").append(modulesToAnalyze.size()).toString());
                this.findChildrenOnModules(request, allFound, foundOnRound, toFindOnRound, modulesToAnalyze);
            }
        }
    }

    private void findChildrenOnModules(RefactoringRequest request, HashMap<HierarchyNodeModel, HierarchyNodeModel> allFound, HashSet<HierarchyNodeModel> foundOnRound, HierarchyNodeModel toFindOnRound, HashSet<SourceModule> modulesToAnalyze) {
        Iterator<SourceModule> iterator = modulesToAnalyze.iterator();
        while (iterator.hasNext()) {
            SourceModule module;
            SourceModule m = module = iterator.next();
            request.communicateWork(new StringBuffer("Analyzing:").append(m.getName()).toString());
            Iterator entries = EasyASTIteratorVisitor.createClassIterator((SimpleNode)m.getAst());
            while (entries.hasNext()) {
                ASTEntry entry = (ASTEntry)entries.next();
                ClassDef def = (ClassDef)entry.node;
                List parentNames = NodeUtils.getParentNames((ClassDef)def, (boolean)true);
                if (!parentNames.contains(toFindOnRound.name)) continue;
                HierarchyNodeModel newNode = new HierarchyNodeModel((IModule)module, def);
                if (!allFound.containsKey(newNode)) {
                    toFindOnRound.children.add(newNode);
                    allFound.put(newNode, newNode);
                    foundOnRound.add(newNode);
                    continue;
                }
                newNode = allFound.get(newNode);
                Assert.isNotNull((Object)newNode);
                toFindOnRound.children.add(newNode);
            }
        }
    }

    private HashSet<SourceModule> findLikelyModulesWithChildren(RefactoringRequest request, HierarchyNodeModel model, List<AbstractAdditionalDependencyInfo> infoForProject) {
        HashSet<SourceModule> modulesToAnalyze = new HashSet<SourceModule>();
        for (AbstractAdditionalDependencyInfo additionalInfo : infoForProject) {
            List tokensEqualTo = additionalInfo.getTokensEqualTo(model.name, 4);
            for (IInfo info : tokensEqualTo) {
                String declaringModuleName = info.getDeclaringModuleName();
                IModule module = null;
                IPythonNature pythonNature = null;
                if (additionalInfo instanceof AdditionalProjectInterpreterInfo) {
                    AdditionalProjectInterpreterInfo projectInterpreterInfo = (AdditionalProjectInterpreterInfo)additionalInfo;
                    pythonNature = PythonNature.getPythonNature((IProject)projectInterpreterInfo.getProject());
                }
                if (pythonNature == null) {
                    pythonNature = request.nature;
                }
                if ((module = pythonNature.getAstManager().getModule(declaringModuleName, pythonNature, false)) == null && pythonNature != request.nature) {
                    module = request.nature.getAstManager().getModule(declaringModuleName, request.nature, false);
                }
                if (!(module instanceof SourceModule)) continue;
                modulesToAnalyze.add((SourceModule)module);
            }
        }
        return modulesToAnalyze;
    }

    public HierarchyNodeModel findClassHierarchy(RefactoringRequest request) {
        block4: {
            HierarchyNodeModel model;
            Definition d;
            block5: {
                request.setAdditionalInfo("findDefinitionInAdditionalInfo", (Object)Autobox.valueOf((boolean)false));
                ItemPointer[] pointers = this.refactorer.findDefinition(request);
                if (pointers.length != 1) break block4;
                d = pointers[0].definition;
                model = this.createHierarhyNodeFromClassDef(d);
                if (model != null) break block5;
                return null;
            }
            try {
                HashMap<HierarchyNodeModel, HierarchyNodeModel> allFound = new HashMap<HierarchyNodeModel, HierarchyNodeModel>();
                allFound.put(model, model);
                request.communicateWork("Finding superclasses");
                this.findParents(request.nature, d, model, allFound, request);
                request.communicateWork("Finding subclasses");
                this.findChildren(request, model, allFound);
                request.communicateWork("Done");
                return model;
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private HierarchyNodeModel createHierarhyNodeFromClassDef(Definition d) {
        HierarchyNodeModel model = null;
        if (d.ast instanceof ClassDef) {
            model = new HierarchyNodeModel(d.module, (ClassDef)d.ast);
        }
        return model;
    }

    public boolean areAllInSameClassHierarchy(List<AssignDefinition> defs) {
        return true;
    }
}

