/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.refactoring.refactorer.search;

import com.python.pydev.refactoring.refactorer.search.AbstractPythonSearchQuery;
import com.python.pydev.refactoring.refactorer.search.PythonFileSearchResult;
import com.python.pydev.refactoring.refactorer.search.PythonSearchResultUpdater;
import com.python.pydev.refactoring.refactorer.search.PythonTextSearchVisitor;
import com.python.pydev.ui.search.FileMatch;
import com.python.pydev.ui.search.LineElement;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.FileTextSearchScope;
import org.eclipse.search.ui.text.Match;
import org.python.pydev.core.docutils.StringUtils;

public class PythonFileSearchQuery
extends AbstractPythonSearchQuery
implements ISearchQuery {
    private final FileTextSearchScope fScope;
    private PythonFileSearchResult fResult;

    public PythonFileSearchQuery(String searchText, FileTextSearchScope scope) {
        super(searchText);
        this.fScope = scope;
    }

    public FileTextSearchScope getSearchScope() {
        return this.fScope;
    }

    public IStatus run(IProgressMonitor monitor) {
        AbstractTextSearchResult textResult = (AbstractTextSearchResult)this.getSearchResult();
        textResult.removeAll();
        boolean searchInBinaries = !this.isScopeAllFileTypes();
        TextSearchResultCollector collector = new TextSearchResultCollector(textResult, false, searchInBinaries);
        return new PythonTextSearchVisitor(collector, this.getSearchString()).search((TextSearchScope)this.fScope, monitor);
    }

    public String getResultLabel(int nMatches) {
        String searchString = this.getSearchString();
        if (searchString.length() > 0) {
            if (this.isScopeAllFileTypes()) {
                if (nMatches == 1) {
                    return StringUtils.format((String)"%s - 1 match in %s", (Object[])new Object[]{searchString, this.getDescription()});
                }
                return StringUtils.format((String)"%s - {1} matches in %s", (Object[])new Object[]{searchString, new Integer(nMatches), this.getDescription()});
            }
            if (nMatches == 1) {
                return StringUtils.format((String)"%s - 1 match in %s (%s)", (Object[])new Object[]{searchString, this.getDescription(), this.getFilterDescription()});
            }
            return StringUtils.format((String)"%s - {1} matches in %s (%s)", (Object[])new Object[]{searchString, new Integer(nMatches), this.getDescription(), this.getFilterDescription()});
        }
        if (nMatches == 1) {
            return StringUtils.format((String)"1 file name matching %s in %s", (Object[])new Object[]{this.getFilterDescription(), this.getDescription()});
        }
        return StringUtils.format((String)"%s file names matching %s in %s", (Object[])new Object[]{this.getFilterDescription(), new Integer(nMatches), this.getDescription()});
    }

    protected String getFilterDescription() {
        return this.fScope.getFilterDescription();
    }

    protected String getDescription() {
        return this.fScope.getDescription();
    }

    public ISearchResult getSearchResult() {
        if (this.fResult == null) {
            this.fResult = new PythonFileSearchResult(this);
            new PythonSearchResultUpdater(this.fResult);
        }
        return this.fResult;
    }

    private static final class TextSearchResultCollector
    extends TextSearchRequestor {
        private final AbstractTextSearchResult fResult;
        private final boolean fIsFileSearchOnly;
        private final boolean fSearchInBinaries;
        private ArrayList<Match> fCachedMatches;

        private TextSearchResultCollector(AbstractTextSearchResult result, boolean isFileSearchOnly, boolean searchInBinaries) {
            this.fResult = result;
            this.fIsFileSearchOnly = isFileSearchOnly;
            this.fSearchInBinaries = searchInBinaries;
        }

        public boolean acceptFile(IFile file) throws CoreException {
            if (this.fIsFileSearchOnly) {
                this.fResult.addMatch((Match)new FileMatch(file));
            }
            this.flushMatches();
            return true;
        }

        public boolean reportBinaryFile(IFile file) {
            return this.fSearchInBinaries;
        }

        public boolean acceptPatternMatch(TextSearchMatchAccess matchRequestor) throws CoreException {
            int offset = matchRequestor.getMatchOffset();
            IFile file = matchRequestor.getFile();
            int len = matchRequestor.getMatchLength();
            this.fCachedMatches.add((Match)new FileMatch(file, offset, len, this.getLineElement(offset, matchRequestor)));
            return true;
        }

        private LineElement getLineElement(int offset, TextSearchMatchAccess matchRequestor) {
            int lineNumber = 1;
            int lineStart = 0;
            if (!this.fCachedMatches.isEmpty()) {
                FileMatch last = (FileMatch)this.fCachedMatches.get(this.fCachedMatches.size() - 1);
                LineElement lineElement = last.getLineElement();
                if (lineElement.contains(offset)) {
                    return lineElement;
                }
                lineStart = lineElement.getOffset() + lineElement.getLength();
                lineNumber = lineElement.getLine() + 1;
            }
            if (offset < lineStart) {
                return null;
            }
            int i = lineStart;
            int contentLength = matchRequestor.getFileContentLength();
            while (i < contentLength) {
                char ch;
                if ((ch = matchRequestor.getFileContentChar(i++)) != '\n' && ch != '\r') continue;
                if (ch == '\r' && i < contentLength && matchRequestor.getFileContentChar(i) == '\n') {
                    ++i;
                }
                if (offset < i) {
                    String lineContent = TextSearchResultCollector.getContents(matchRequestor, lineStart, i);
                    return new LineElement((IResource)matchRequestor.getFile(), lineNumber, lineStart, lineContent);
                }
                ++lineNumber;
                lineStart = i;
            }
            if (offset < i) {
                String lineContent = TextSearchResultCollector.getContents(matchRequestor, lineStart, i);
                return new LineElement((IResource)matchRequestor.getFile(), lineNumber, lineStart, lineContent);
            }
            return null;
        }

        private static String getContents(TextSearchMatchAccess matchRequestor, int start, int end) {
            StringBuffer buf = new StringBuffer();
            int i = start;
            while (i < end) {
                char ch = matchRequestor.getFileContentChar(i);
                if (Character.isWhitespace(ch) || Character.isISOControl(ch)) {
                    buf.append(' ');
                } else {
                    buf.append(ch);
                }
                ++i;
            }
            return buf.toString();
        }

        public void beginReporting() {
            this.fCachedMatches = new ArrayList();
        }

        public void endReporting() {
            this.flushMatches();
            this.fCachedMatches = null;
        }

        private void flushMatches() {
            if (!this.fCachedMatches.isEmpty()) {
                this.fResult.addMatches(this.fCachedMatches.toArray(new Match[this.fCachedMatches.size()]));
                this.fCachedMatches.clear();
            }
        }
    }
}

